/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.cluster.metadata;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.function.LongSupplier;
import java.util.stream.Collectors;
import org.apache.lucene.document.LongPoint;
import org.apache.lucene.index.LeafReader;
import org.apache.lucene.index.PointValues;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.Version;
import org.elasticsearch.cluster.AbstractDiffable;
import org.elasticsearch.cluster.Diff;
import org.elasticsearch.cluster.metadata.IndexAbstraction;
import org.elasticsearch.cluster.metadata.IndexMetadata;
import org.elasticsearch.cluster.metadata.Metadata;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.common.time.DateFormatter;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.core.Tuple;
import org.elasticsearch.index.Index;
import org.elasticsearch.xcontent.ConstructingObjectParser;
import org.elasticsearch.xcontent.ParseField;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.ToXContentObject;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xcontent.XContentParser;

public final class DataStream
extends AbstractDiffable<DataStream>
implements ToXContentObject {
    public static final String BACKING_INDEX_PREFIX = ".ds-";
    public static final DateFormatter DATE_FORMATTER = DateFormatter.forPattern("uuuu.MM.dd");
    public static Comparator<LeafReader> TIMESERIES_LEAF_READERS_SORTER = Comparator.comparingLong(r -> {
        try {
            PointValues points = r.getPointValues("@timestamp");
            if (points != null) {
                byte[] sortValue = points.getMaxPackedValue();
                return LongPoint.decodeDimension(sortValue, 0);
            }
            return Long.MIN_VALUE;
        }
        catch (IOException e) {
            throw new ElasticsearchException("Can't access [@timestamp] field for the index!", (Throwable)e, new Object[0]);
        }
    }).reversed();
    public static final Version NEW_FEATURES_VERSION = Version.V_7_11_0;
    private final LongSupplier timeProvider;
    private final String name;
    private final TimestampField timeStampField;
    private final List<Index> indices;
    private final long generation;
    private final Map<String, Object> metadata;
    private final boolean hidden;
    private final boolean replicated;
    private final boolean system;
    public static final ParseField NAME_FIELD = new ParseField("name", new String[0]);
    public static final ParseField TIMESTAMP_FIELD_FIELD = new ParseField("timestamp_field", new String[0]);
    public static final ParseField INDICES_FIELD = new ParseField("indices", new String[0]);
    public static final ParseField GENERATION_FIELD = new ParseField("generation", new String[0]);
    public static final ParseField METADATA_FIELD = new ParseField("_meta", new String[0]);
    public static final ParseField HIDDEN_FIELD = new ParseField("hidden", new String[0]);
    public static final ParseField REPLICATED_FIELD = new ParseField("replicated", new String[0]);
    public static final ParseField SYSTEM_FIELD = new ParseField("system", new String[0]);
    private static final ConstructingObjectParser<DataStream, Void> PARSER = new ConstructingObjectParser("data_stream", args -> new DataStream((String)args[0], (TimestampField)args[1], (List)args[2], (Long)args[3], (Map)args[4], args[5] != null && (Boolean)args[5] != false, args[6] != null && (Boolean)args[6] != false, args[7] != null && (Boolean)args[7] != false));

    public DataStream(String name, TimestampField timeStampField, List<Index> indices, long generation, Map<String, Object> metadata, boolean hidden, boolean replicated, boolean system) {
        this(name, timeStampField, indices, generation, metadata, hidden, replicated, system, System::currentTimeMillis);
    }

    DataStream(String name, TimestampField timeStampField, List<Index> indices, long generation, Map<String, Object> metadata, boolean hidden, boolean replicated, boolean system, LongSupplier timeProvider) {
        this.name = name;
        this.timeStampField = timeStampField;
        this.indices = org.elasticsearch.core.List.copyOf(indices);
        this.generation = generation;
        this.metadata = metadata;
        this.hidden = hidden;
        this.replicated = replicated;
        this.timeProvider = timeProvider;
        this.system = system;
        assert (DataStream.assertConsistent(this.indices));
    }

    private static boolean assertConsistent(List<Index> indices) {
        assert (indices.size() > 0);
        HashSet<String> indexNames = new HashSet<String>();
        for (Index index : indices) {
            boolean added = indexNames.add(index.getName());
            assert (added) : "found duplicate index entries in " + indices;
        }
        return true;
    }

    public String getName() {
        return this.name;
    }

    public TimestampField getTimeStampField() {
        return this.timeStampField;
    }

    public List<Index> getIndices() {
        return this.indices;
    }

    public long getGeneration() {
        return this.generation;
    }

    public Index getWriteIndex() {
        return this.indices.get(this.indices.size() - 1);
    }

    @Nullable
    public Map<String, Object> getMetadata() {
        return this.metadata;
    }

    public boolean isHidden() {
        return this.hidden;
    }

    public boolean isReplicated() {
        return this.replicated;
    }

    public boolean isSystem() {
        return this.system;
    }

    public DataStream rollover(Index writeIndex, long generation) {
        this.ensureNotReplicated();
        return this.unsafeRollover(writeIndex, generation);
    }

    public DataStream unsafeRollover(Index writeIndex, long generation) {
        ArrayList<Index> backingIndices = new ArrayList<Index>(this.indices);
        backingIndices.add(writeIndex);
        return new DataStream(this.name, this.timeStampField, backingIndices, generation, this.metadata, this.hidden, false, this.system);
    }

    public Tuple<String, Long> nextWriteIndexAndGeneration(Metadata clusterMetadata, Version minNodeVersion) {
        this.ensureNotReplicated();
        return this.unsafeNextWriteIndexAndGeneration(clusterMetadata, minNodeVersion);
    }

    public Tuple<String, Long> unsafeNextWriteIndexAndGeneration(Metadata clusterMetadata, Version minNodeVersion) {
        String newWriteIndexName;
        long generation = this.generation;
        long currentTimeMillis = this.timeProvider.getAsLong();
        do {
            newWriteIndexName = DataStream.getDefaultBackingIndexName(this.getName(), ++generation, currentTimeMillis, minNodeVersion);
        } while (clusterMetadata.getIndicesLookup().containsKey(newWriteIndexName));
        return Tuple.tuple(newWriteIndexName, generation);
    }

    private void ensureNotReplicated() {
        if (this.replicated) {
            throw new IllegalArgumentException("data stream [" + this.name + "] cannot be rolled over, because it is a replicated data stream");
        }
    }

    public DataStream removeBackingIndex(Index index) {
        int backingIndexPosition = this.indices.indexOf(index);
        if (backingIndexPosition == -1) {
            throw new IllegalArgumentException(String.format(Locale.ROOT, "index [%s] is not part of data stream [%s]", index.getName(), this.name));
        }
        if (this.indices.size() == backingIndexPosition + 1) {
            throw new IllegalArgumentException(String.format(Locale.ROOT, "cannot remove backing index [%s] of data stream [%s] because it is the write index", index.getName(), this.name));
        }
        ArrayList<Index> backingIndices = new ArrayList<Index>(this.indices);
        backingIndices.remove(index);
        assert (backingIndices.size() == this.indices.size() - 1);
        return new DataStream(this.name, this.timeStampField, backingIndices, this.generation + 1L, this.metadata, this.hidden, this.replicated, this.system);
    }

    public DataStream replaceBackingIndex(Index existingBackingIndex, Index newBackingIndex) {
        ArrayList<Index> backingIndices = new ArrayList<Index>(this.indices);
        int backingIndexPosition = backingIndices.indexOf(existingBackingIndex);
        if (backingIndexPosition == -1) {
            throw new IllegalArgumentException(String.format(Locale.ROOT, "index [%s] is not part of data stream [%s]", existingBackingIndex.getName(), this.name));
        }
        if (this.indices.size() == backingIndexPosition + 1) {
            throw new IllegalArgumentException(String.format(Locale.ROOT, "cannot replace backing index [%s] of data stream [%s] because it is the write index", existingBackingIndex.getName(), this.name));
        }
        backingIndices.set(backingIndexPosition, newBackingIndex);
        return new DataStream(this.name, this.timeStampField, backingIndices, this.generation + 1L, this.metadata, this.hidden, this.replicated, this.system);
    }

    public DataStream addBackingIndex(Metadata clusterMetadata, Index index) {
        IndexAbstraction.DataStream parentDataStream = ((IndexAbstraction)clusterMetadata.getIndicesLookup().get(index.getName())).getParentDataStream();
        if (parentDataStream != null) {
            if (parentDataStream.getDataStream().equals(this)) {
                return this;
            }
            throw new IllegalArgumentException(String.format(Locale.ROOT, "cannot add index [%s] to data stream [%s] because it is already a backing index on data stream [%s]", index.getName(), this.getName(), parentDataStream.getName()));
        }
        IndexMetadata im = clusterMetadata.index(((IndexAbstraction)clusterMetadata.getIndicesLookup().get(index.getName())).getWriteIndex());
        if (im.getAliases().size() > 0) {
            throw new IllegalArgumentException(String.format(Locale.ROOT, "cannot add index [%s] to data stream [%s] until its alias(es) [%s] are removed", index.getName(), this.getName(), Strings.collectionToCommaDelimitedString(im.getAliases().stream().map(Map.Entry::getKey).sorted().collect(Collectors.toList()))));
        }
        ArrayList<Index> backingIndices = new ArrayList<Index>(this.indices);
        backingIndices.add(0, index);
        assert (backingIndices.size() == this.indices.size() + 1);
        return new DataStream(this.name, this.timeStampField, backingIndices, this.generation + 1L, this.metadata, this.hidden, this.replicated, this.system);
    }

    public DataStream promoteDataStream() {
        return new DataStream(this.name, this.timeStampField, this.indices, this.getGeneration(), this.metadata, this.hidden, false, this.system, this.timeProvider);
    }

    @Nullable
    public DataStream snapshot(Collection<String> indicesInSnapshot) {
        ArrayList<Index> reconciledIndices = new ArrayList<Index>(this.indices);
        if (!reconciledIndices.removeIf(x -> !indicesInSnapshot.contains(x.getName()))) {
            return this;
        }
        if (reconciledIndices.size() == 0) {
            return null;
        }
        return new DataStream(this.name, this.timeStampField, reconciledIndices, this.generation, this.metadata == null ? null : new HashMap<String, Object>(this.metadata), this.hidden, this.replicated, this.system);
    }

    public static String getDefaultBackingIndexName(String dataStreamName, long generation) {
        return DataStream.getDefaultBackingIndexName(dataStreamName, generation, System.currentTimeMillis(), Version.CURRENT);
    }

    public static String getDefaultBackingIndexName(String dataStreamName, long generation, Version minNodeVersion) {
        return DataStream.getDefaultBackingIndexName(dataStreamName, generation, System.currentTimeMillis(), minNodeVersion);
    }

    public static String getDefaultBackingIndexName(String dataStreamName, long generation, long epochMillis) {
        return String.format(Locale.ROOT, ".ds-%s-%s-%06d", dataStreamName, DATE_FORMATTER.formatMillis(epochMillis), generation);
    }

    public static String getDefaultBackingIndexName(String dataStreamName, long generation, long epochMillis, Version minNodeVersion) {
        if (minNodeVersion.onOrAfter(NEW_FEATURES_VERSION)) {
            return String.format(Locale.ROOT, ".ds-%s-%s-%06d", dataStreamName, DATE_FORMATTER.formatMillis(epochMillis), generation);
        }
        return DataStream.getLegacyDefaultBackingIndexName(dataStreamName, generation);
    }

    public static String getLegacyDefaultBackingIndexName(String dataStreamName, long generation) {
        return String.format(Locale.ROOT, ".ds-%s-%06d", dataStreamName, generation);
    }

    public DataStream(StreamInput in) throws IOException {
        this(in.readString(), new TimestampField(in), in.readList(Index::new), in.readVLong(), in.getVersion().onOrAfter(NEW_FEATURES_VERSION) ? in.readMap() : null, in.getVersion().onOrAfter(NEW_FEATURES_VERSION) && in.readBoolean(), in.getVersion().onOrAfter(NEW_FEATURES_VERSION) && in.readBoolean(), in.getVersion().onOrAfter(Version.V_7_13_0) && in.readBoolean());
    }

    public static Diff<DataStream> readDiffFrom(StreamInput in) throws IOException {
        return DataStream.readDiffFrom(DataStream::new, in);
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeString(this.name);
        this.timeStampField.writeTo(out);
        out.writeList(this.indices);
        out.writeVLong(this.generation);
        if (out.getVersion().onOrAfter(NEW_FEATURES_VERSION)) {
            out.writeMap(this.metadata);
            out.writeBoolean(this.hidden);
            out.writeBoolean(this.replicated);
            if (out.getVersion().onOrAfter(Version.V_7_13_0)) {
                out.writeBoolean(this.system);
            }
        }
    }

    public static DataStream fromXContent(XContentParser parser) throws IOException {
        return PARSER.parse(parser, null);
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        builder.field(NAME_FIELD.getPreferredName(), this.name);
        builder.field(TIMESTAMP_FIELD_FIELD.getPreferredName(), this.timeStampField);
        builder.xContentList(INDICES_FIELD.getPreferredName(), this.indices);
        builder.field(GENERATION_FIELD.getPreferredName(), this.generation);
        if (this.metadata != null) {
            builder.field(METADATA_FIELD.getPreferredName(), this.metadata);
        }
        builder.field(HIDDEN_FIELD.getPreferredName(), this.hidden);
        builder.field(REPLICATED_FIELD.getPreferredName(), this.replicated);
        builder.field(SYSTEM_FIELD.getPreferredName(), this.system);
        builder.endObject();
        return builder;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DataStream that = (DataStream)o;
        return this.name.equals(that.name) && this.timeStampField.equals(that.timeStampField) && this.indices.equals(that.indices) && this.generation == that.generation && Objects.equals(this.metadata, that.metadata) && this.hidden == that.hidden && this.replicated == that.replicated;
    }

    public int hashCode() {
        return Objects.hash(this.name, this.timeStampField, this.indices, this.generation, this.metadata, this.hidden, this.replicated);
    }

    static {
        PARSER.declareString(ConstructingObjectParser.constructorArg(), NAME_FIELD);
        PARSER.declareObject(ConstructingObjectParser.constructorArg(), TimestampField.PARSER, TIMESTAMP_FIELD_FIELD);
        PARSER.declareObjectArray(ConstructingObjectParser.constructorArg(), (p, c) -> Index.fromXContent(p), INDICES_FIELD);
        PARSER.declareLong(ConstructingObjectParser.constructorArg(), GENERATION_FIELD);
        PARSER.declareObject(ConstructingObjectParser.optionalConstructorArg(), (p, c) -> p.map(), METADATA_FIELD);
        PARSER.declareBoolean(ConstructingObjectParser.optionalConstructorArg(), HIDDEN_FIELD);
        PARSER.declareBoolean(ConstructingObjectParser.optionalConstructorArg(), REPLICATED_FIELD);
        PARSER.declareBoolean(ConstructingObjectParser.optionalConstructorArg(), SYSTEM_FIELD);
    }

    public static final class TimestampField
    implements Writeable,
    ToXContentObject {
        public static final String FIXED_TIMESTAMP_FIELD = "@timestamp";
        static ParseField NAME_FIELD = new ParseField("name", new String[0]);
        private static final ConstructingObjectParser<TimestampField, Void> PARSER = new ConstructingObjectParser("timestamp_field", args -> new TimestampField((String)args[0]));
        private final String name;

        public TimestampField(String name) {
            if (!FIXED_TIMESTAMP_FIELD.equals(name)) {
                throw new IllegalArgumentException("unexpected timestamp field [" + name + "]");
            }
            this.name = name;
        }

        public TimestampField(StreamInput in) throws IOException {
            this(in.readString());
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            out.writeString(this.name);
        }

        @Override
        public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            builder.startObject();
            builder.field(NAME_FIELD.getPreferredName(), this.name);
            builder.endObject();
            return builder;
        }

        public String getName() {
            return this.name;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            TimestampField that = (TimestampField)o;
            return this.name.equals(that.name);
        }

        public int hashCode() {
            return Objects.hash(this.name);
        }

        static {
            PARSER.declareString(ConstructingObjectParser.constructorArg(), NAME_FIELD);
        }
    }
}

