/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.cluster;

import com.carrotsearch.hppc.cursors.IntCursor;
import com.carrotsearch.hppc.cursors.IntObjectCursor;
import com.carrotsearch.hppc.cursors.ObjectCursor;
import com.carrotsearch.hppc.cursors.ObjectObjectCursor;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.elasticsearch.Version;
import org.elasticsearch.cluster.Diff;
import org.elasticsearch.cluster.Diffable;
import org.elasticsearch.common.collect.ImmutableOpenIntMap;
import org.elasticsearch.common.collect.ImmutableOpenMap;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;

public final class DiffableUtils {
    private static final MapDiff<?, ?, ?> EMPTY = new MapDiff<Object, Object, Object>(null, null, Collections.emptyList(), Collections.emptyMap(), Collections.emptyMap()){

        @Override
        public Object apply(Object part) {
            return part;
        }
    };

    private DiffableUtils() {
    }

    public static KeySerializer<String> getStringKeySerializer() {
        return StringKeySerializer.INSTANCE;
    }

    public static KeySerializer<Integer> getIntKeySerializer() {
        return IntKeySerializer.INSTANCE;
    }

    public static KeySerializer<Integer> getVIntKeySerializer() {
        return VIntKeySerializer.INSTANCE;
    }

    public static <K, T extends Diffable<T>> MapDiff<K, T, ImmutableOpenMap<K, T>> diff(ImmutableOpenMap<K, T> before, ImmutableOpenMap<K, T> after, KeySerializer<K> keySerializer) {
        assert (after != null && before != null);
        return before.equals(after) ? DiffableUtils.emptyDiff() : new ImmutableOpenMapDiff<K, T>(before, after, keySerializer, DiffableValueSerializer.getWriteOnlyInstance());
    }

    public static <K, T> MapDiff<K, T, ImmutableOpenMap<K, T>> diff(ImmutableOpenMap<K, T> before, ImmutableOpenMap<K, T> after, KeySerializer<K> keySerializer, ValueSerializer<K, T> valueSerializer) {
        assert (after != null && before != null);
        return before.equals(after) ? DiffableUtils.emptyDiff() : new ImmutableOpenMapDiff<K, T>(before, after, keySerializer, valueSerializer);
    }

    public static <T extends Diffable<T>> MapDiff<Integer, T, ImmutableOpenIntMap<T>> diff(ImmutableOpenIntMap<T> before, ImmutableOpenIntMap<T> after, KeySerializer<Integer> keySerializer) {
        assert (after != null && before != null);
        return before.equals(after) ? DiffableUtils.emptyDiff() : new ImmutableOpenIntMapDiff<T>(before, after, keySerializer, DiffableValueSerializer.getWriteOnlyInstance());
    }

    public static <T> MapDiff<Integer, T, ImmutableOpenIntMap<T>> diff(ImmutableOpenIntMap<T> before, ImmutableOpenIntMap<T> after, KeySerializer<Integer> keySerializer, ValueSerializer<Integer, T> valueSerializer) {
        assert (after != null && before != null);
        return before.equals(after) ? DiffableUtils.emptyDiff() : new ImmutableOpenIntMapDiff<T>(before, after, keySerializer, valueSerializer);
    }

    public static <K, T extends Diffable<T>> MapDiff<K, T, Map<K, T>> diff(Map<K, T> before, Map<K, T> after, KeySerializer<K> keySerializer) {
        assert (after != null && before != null);
        return before.equals(after) ? DiffableUtils.emptyDiff() : new JdkMapDiff<K, T>(before, after, keySerializer, DiffableValueSerializer.getWriteOnlyInstance());
    }

    public static <K, T> MapDiff<K, T, Map<K, T>> diff(Map<K, T> before, Map<K, T> after, KeySerializer<K> keySerializer, ValueSerializer<K, T> valueSerializer) {
        assert (after != null && before != null);
        return before.equals(after) ? DiffableUtils.emptyDiff() : new JdkMapDiff<K, T>(before, after, keySerializer, valueSerializer);
    }

    private static <K, T, M> MapDiff<K, T, M> emptyDiff() {
        return EMPTY;
    }

    public static <K, T> MapDiff<K, T, ImmutableOpenMap<K, T>> readImmutableOpenMapDiff(StreamInput in, KeySerializer<K> keySerializer, ValueSerializer<K, T> valueSerializer) throws IOException {
        return DiffableUtils.diffOrEmpty(new ImmutableOpenMapDiff<K, T>(in, keySerializer, valueSerializer));
    }

    public static <T> MapDiff<Integer, T, ImmutableOpenIntMap<T>> readImmutableOpenIntMapDiff(StreamInput in, KeySerializer<Integer> keySerializer, ValueSerializer<Integer, T> valueSerializer) throws IOException {
        return DiffableUtils.diffOrEmpty(new ImmutableOpenIntMapDiff<T>(in, keySerializer, valueSerializer));
    }

    public static <K, T> MapDiff<K, T, Map<K, T>> readJdkMapDiff(StreamInput in, KeySerializer<K> keySerializer, ValueSerializer<K, T> valueSerializer) throws IOException {
        return DiffableUtils.diffOrEmpty(new JdkMapDiff<K, T>(in, keySerializer, valueSerializer));
    }

    public static <K, T extends Diffable<T>> MapDiff<K, T, ImmutableOpenMap<K, T>> readImmutableOpenMapDiff(StreamInput in, KeySerializer<K> keySerializer, DiffableValueReader<K, T> diffableValueReader) throws IOException {
        return DiffableUtils.diffOrEmpty(new ImmutableOpenMapDiff<K, T>(in, keySerializer, diffableValueReader));
    }

    public static <T extends Diffable<T>> MapDiff<Integer, T, ImmutableOpenIntMap<T>> readImmutableOpenIntMapDiff(StreamInput in, KeySerializer<Integer> keySerializer, Writeable.Reader<T> reader, Writeable.Reader<Diff<T>> diffReader) throws IOException {
        return DiffableUtils.diffOrEmpty(new ImmutableOpenIntMapDiff<T>(in, keySerializer, new DiffableValueReader(reader, diffReader)));
    }

    public static <K, T extends Diffable<T>> MapDiff<K, T, Map<K, T>> readJdkMapDiff(StreamInput in, KeySerializer<K> keySerializer, Writeable.Reader<T> reader, Writeable.Reader<Diff<T>> diffReader) throws IOException {
        return DiffableUtils.diffOrEmpty(new JdkMapDiff<K, T>(in, keySerializer, new DiffableValueReader(reader, diffReader)));
    }

    private static <K, T, H> MapDiff<K, T, H> diffOrEmpty(MapDiff<K, T, H> diff) {
        if (diff.getUpserts().isEmpty() && diff.getDiffs().isEmpty() && diff.getDeletes().isEmpty()) {
            return DiffableUtils.emptyDiff();
        }
        return diff;
    }

    private static final class StringKeySerializer
    implements KeySerializer<String> {
        private static final StringKeySerializer INSTANCE = new StringKeySerializer();

        private StringKeySerializer() {
        }

        @Override
        public void writeKey(String key, StreamOutput out) throws IOException {
            out.writeString(key);
        }

        @Override
        public String readKey(StreamInput in) throws IOException {
            return in.readString();
        }
    }

    private static final class IntKeySerializer
    implements KeySerializer<Integer> {
        public static final IntKeySerializer INSTANCE = new IntKeySerializer();

        private IntKeySerializer() {
        }

        @Override
        public void writeKey(Integer key, StreamOutput out) throws IOException {
            out.writeInt(key);
        }

        @Override
        public Integer readKey(StreamInput in) throws IOException {
            return in.readInt();
        }
    }

    private static final class VIntKeySerializer
    implements KeySerializer<Integer> {
        public static final IntKeySerializer INSTANCE = new IntKeySerializer();

        private VIntKeySerializer() {
        }

        @Override
        public void writeKey(Integer key, StreamOutput out) throws IOException {
            if (key < 0) {
                throw new IllegalArgumentException("Map key [" + key + "] must be positive");
            }
            out.writeVInt(key);
        }

        @Override
        public Integer readKey(StreamInput in) throws IOException {
            return in.readVInt();
        }
    }

    public static abstract class MapDiff<K, T, M>
    implements Diff<M> {
        protected final List<K> deletes;
        protected final Map<K, Diff<T>> diffs;
        protected final Map<K, T> upserts;
        protected final KeySerializer<K> keySerializer;
        protected final ValueSerializer<K, T> valueSerializer;

        protected MapDiff(KeySerializer<K> keySerializer, ValueSerializer<K, T> valueSerializer) {
            this.keySerializer = keySerializer;
            this.valueSerializer = valueSerializer;
            this.deletes = new ArrayList<K>();
            this.diffs = new HashMap<K, Diff<T>>();
            this.upserts = new HashMap<K, T>();
        }

        protected MapDiff(KeySerializer<K> keySerializer, ValueSerializer<K, T> valueSerializer, List<K> deletes, Map<K, Diff<T>> diffs, Map<K, T> upserts) {
            this.keySerializer = keySerializer;
            this.valueSerializer = valueSerializer;
            this.deletes = deletes;
            this.diffs = diffs;
            this.upserts = upserts;
        }

        protected MapDiff(StreamInput in, KeySerializer<K> keySerializer, ValueSerializer<K, T> valueSerializer) throws IOException {
            this.keySerializer = keySerializer;
            this.valueSerializer = valueSerializer;
            this.deletes = in.readList(keySerializer::readKey);
            int diffsCount = in.readVInt();
            this.diffs = diffsCount == 0 ? Collections.emptyMap() : new HashMap(diffsCount);
            for (int i = 0; i < diffsCount; ++i) {
                K key = keySerializer.readKey(in);
                Diff<T> diff = valueSerializer.readDiff(in, key);
                this.diffs.put(key, diff);
            }
            int upsertsCount = in.readVInt();
            this.upserts = upsertsCount == 0 ? Collections.emptyMap() : new HashMap(upsertsCount);
            for (int i = 0; i < upsertsCount; ++i) {
                K key = keySerializer.readKey(in);
                T newValue = valueSerializer.read(in, key);
                this.upserts.put(key, newValue);
            }
        }

        public List<K> getDeletes() {
            return this.deletes;
        }

        public Map<K, Diff<T>> getDiffs() {
            return this.diffs;
        }

        public Map<K, T> getUpserts() {
            return this.upserts;
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            out.writeCollection(this.deletes, (o, v) -> this.keySerializer.writeKey(v, o));
            Version version = out.getVersion();
            int diffCount = 0;
            for (Diff<T> diff : this.diffs.values()) {
                if (!this.valueSerializer.supportsVersion((T)diff, version)) continue;
                ++diffCount;
            }
            out.writeVInt(diffCount);
            for (Map.Entry entry : this.diffs.entrySet()) {
                if (!this.valueSerializer.supportsVersion((T)((Diff)entry.getValue()), version)) continue;
                this.keySerializer.writeKey(entry.getKey(), out);
                this.valueSerializer.writeDiff((Diff)entry.getValue(), out);
            }
            int upsertsCount = 0;
            for (T t : this.upserts.values()) {
                if (!this.valueSerializer.supportsVersion(t, version)) continue;
                ++upsertsCount;
            }
            out.writeVInt(upsertsCount);
            for (Map.Entry<K, T> entry : this.upserts.entrySet()) {
                if (!this.valueSerializer.supportsVersion(entry.getValue(), version)) continue;
                this.keySerializer.writeKey(entry.getKey(), out);
                this.valueSerializer.write(entry.getValue(), out);
            }
        }
    }

    public static class ImmutableOpenMapDiff<K, T>
    extends MapDiff<K, T, ImmutableOpenMap<K, T>> {
        protected ImmutableOpenMapDiff(StreamInput in, KeySerializer<K> keySerializer, ValueSerializer<K, T> valueSerializer) throws IOException {
            super(in, keySerializer, valueSerializer);
        }

        public ImmutableOpenMapDiff(ImmutableOpenMap<K, T> before, ImmutableOpenMap<K, T> after, KeySerializer<K> keySerializer, ValueSerializer<K, T> valueSerializer) {
            super(keySerializer, valueSerializer);
            assert (after != null && before != null);
            for (ObjectCursor objectCursor : before.keys()) {
                if (after.containsKey(objectCursor.value)) continue;
                this.deletes.add(objectCursor.value);
            }
            for (ObjectObjectCursor objectObjectCursor : after) {
                T beforePart = before.get(objectObjectCursor.key);
                if (beforePart == null) {
                    this.upserts.put(objectObjectCursor.key, objectObjectCursor.value);
                    continue;
                }
                if (objectObjectCursor.value.equals(beforePart)) continue;
                if (valueSerializer.supportsDiffableValues()) {
                    this.diffs.put(objectObjectCursor.key, valueSerializer.diff(objectObjectCursor.value, beforePart));
                    continue;
                }
                this.upserts.put(objectObjectCursor.key, objectObjectCursor.value);
            }
        }

        @Override
        public ImmutableOpenMap<K, T> apply(ImmutableOpenMap<K, T> map) {
            ImmutableOpenMap.Builder<K, T> builder = ImmutableOpenMap.builder(map);
            for (Object e : this.deletes) {
                builder.remove(e);
            }
            for (Map.Entry entry : this.diffs.entrySet()) {
                builder.put(entry.getKey(), ((Diff)entry.getValue()).apply(builder.get(entry.getKey())));
            }
            for (Map.Entry entry : this.upserts.entrySet()) {
                builder.put(entry.getKey(), entry.getValue());
            }
            return builder.build();
        }
    }

    public static abstract class DiffableValueSerializer<K, V extends Diffable<V>>
    implements ValueSerializer<K, V> {
        private static final DiffableValueSerializer WRITE_ONLY_INSTANCE = new DiffableValueSerializer(){

            @Override
            public Object read(StreamInput in, Object key) throws IOException {
                throw new UnsupportedOperationException();
            }

            @Override
            public Diff<Object> readDiff(StreamInput in, Object key) throws IOException {
                throw new UnsupportedOperationException();
            }
        };

        private static <K, V extends Diffable<V>> DiffableValueSerializer<K, V> getWriteOnlyInstance() {
            return WRITE_ONLY_INSTANCE;
        }

        @Override
        public boolean supportsDiffableValues() {
            return true;
        }

        @Override
        public Diff<V> diff(V value, V beforePart) {
            return value.diff(beforePart);
        }

        @Override
        public void write(V value, StreamOutput out) throws IOException {
            value.writeTo(out);
        }

        @Override
        public void writeDiff(Diff<V> value, StreamOutput out) throws IOException {
            value.writeTo(out);
        }
    }

    public static interface KeySerializer<K> {
        public void writeKey(K var1, StreamOutput var2) throws IOException;

        public K readKey(StreamInput var1) throws IOException;
    }

    public static interface ValueSerializer<K, V> {
        public void write(V var1, StreamOutput var2) throws IOException;

        public V read(StreamInput var1, K var2) throws IOException;

        public boolean supportsDiffableValues();

        default public boolean supportsVersion(Diff<V> value, Version version) {
            return true;
        }

        default public boolean supportsVersion(V value, Version version) {
            return true;
        }

        public Diff<V> diff(V var1, V var2);

        public void writeDiff(Diff<V> var1, StreamOutput var2) throws IOException;

        public Diff<V> readDiff(StreamInput var1, K var2) throws IOException;
    }

    private static class ImmutableOpenIntMapDiff<T>
    extends MapDiff<Integer, T, ImmutableOpenIntMap<T>> {
        protected ImmutableOpenIntMapDiff(StreamInput in, KeySerializer<Integer> keySerializer, ValueSerializer<Integer, T> valueSerializer) throws IOException {
            super(in, keySerializer, valueSerializer);
        }

        ImmutableOpenIntMapDiff(ImmutableOpenIntMap<T> before, ImmutableOpenIntMap<T> after, KeySerializer<Integer> keySerializer, ValueSerializer<Integer, T> valueSerializer) {
            super(keySerializer, valueSerializer);
            assert (after != null && before != null);
            for (IntCursor intCursor : before.keys()) {
                if (after.containsKey(intCursor.value)) continue;
                this.deletes.add(intCursor.value);
            }
            for (IntObjectCursor intObjectCursor : after) {
                T beforePart = before.get(intObjectCursor.key);
                if (beforePart == null) {
                    this.upserts.put(intObjectCursor.key, intObjectCursor.value);
                    continue;
                }
                if (intObjectCursor.value.equals(beforePart)) continue;
                if (valueSerializer.supportsDiffableValues()) {
                    this.diffs.put(intObjectCursor.key, valueSerializer.diff(intObjectCursor.value, beforePart));
                    continue;
                }
                this.upserts.put(intObjectCursor.key, intObjectCursor.value);
            }
        }

        @Override
        public ImmutableOpenIntMap<T> apply(ImmutableOpenIntMap<T> map) {
            ImmutableOpenIntMap.Builder<T> builder = ImmutableOpenIntMap.builder(map);
            for (Integer n : this.deletes) {
                builder.remove(n);
            }
            for (Map.Entry entry : this.diffs.entrySet()) {
                builder.put((Integer)entry.getKey(), ((Diff)entry.getValue()).apply(builder.get((Integer)entry.getKey())));
            }
            for (Map.Entry entry : this.upserts.entrySet()) {
                builder.put((Integer)entry.getKey(), entry.getValue());
            }
            return builder.build();
        }
    }

    private static class JdkMapDiff<K, T>
    extends MapDiff<K, T, Map<K, T>> {
        protected JdkMapDiff(StreamInput in, KeySerializer<K> keySerializer, ValueSerializer<K, T> valueSerializer) throws IOException {
            super(in, keySerializer, valueSerializer);
        }

        JdkMapDiff(Map<K, T> before, Map<K, T> after, KeySerializer<K> keySerializer, ValueSerializer<K, T> valueSerializer) {
            super(keySerializer, valueSerializer);
            assert (after != null && before != null);
            for (K k : before.keySet()) {
                if (after.containsKey(k)) continue;
                this.deletes.add(k);
            }
            for (Map.Entry entry : after.entrySet()) {
                T beforePart = before.get(entry.getKey());
                if (beforePart == null) {
                    this.upserts.put(entry.getKey(), entry.getValue());
                    continue;
                }
                if (entry.getValue().equals(beforePart)) continue;
                if (valueSerializer.supportsDiffableValues()) {
                    this.diffs.put(entry.getKey(), valueSerializer.diff(entry.getValue(), beforePart));
                    continue;
                }
                this.upserts.put(entry.getKey(), entry.getValue());
            }
        }

        @Override
        public Map<K, T> apply(Map<K, T> map) {
            HashMap builder = new HashMap(map);
            for (Object e : this.deletes) {
                builder.remove(e);
            }
            for (Map.Entry entry : this.diffs.entrySet()) {
                builder.put(entry.getKey(), ((Diff)entry.getValue()).apply(builder.get(entry.getKey())));
            }
            builder.putAll(this.upserts);
            return builder;
        }
    }

    public static class DiffableValueReader<K, V extends Diffable<V>>
    extends DiffableValueSerializer<K, V> {
        private final Writeable.Reader<V> reader;
        private final Writeable.Reader<Diff<V>> diffReader;

        public DiffableValueReader(Writeable.Reader<V> reader, Writeable.Reader<Diff<V>> diffReader) {
            this.reader = reader;
            this.diffReader = diffReader;
        }

        @Override
        public V read(StreamInput in, K key) throws IOException {
            return (V)((Diffable)this.reader.read(in));
        }

        @Override
        public Diff<V> readDiff(StreamInput in, K key) throws IOException {
            return this.diffReader.read(in);
        }
    }

    public static class StringSetValueSerializer<K>
    extends NonDiffableValueSerializer<K, Set<String>> {
        private static final StringSetValueSerializer INSTANCE = new StringSetValueSerializer();

        public static <K> StringSetValueSerializer<K> getInstance() {
            return INSTANCE;
        }

        @Override
        public void write(Set<String> value, StreamOutput out) throws IOException {
            out.writeStringCollection(value);
        }

        @Override
        public Set<String> read(StreamInput in, K key) throws IOException {
            return Collections.unmodifiableSet(new HashSet<String>(Arrays.asList(in.readStringArray())));
        }
    }

    public static abstract class NonDiffableValueSerializer<K, V>
    implements ValueSerializer<K, V> {
        @Override
        public boolean supportsDiffableValues() {
            return false;
        }

        @Override
        public Diff<V> diff(V value, V beforePart) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void writeDiff(Diff<V> value, StreamOutput out) throws IOException {
            throw new UnsupportedOperationException();
        }

        @Override
        public Diff<V> readDiff(StreamInput in, K key) throws IOException {
            throw new UnsupportedOperationException();
        }
    }
}

