/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.client.transform.transforms.pivot;

import java.io.IOException;
import java.util.Locale;
import java.util.Objects;
import org.elasticsearch.script.Script;
import org.elasticsearch.xcontent.ParseField;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.ToXContentObject;
import org.elasticsearch.xcontent.XContentBuilder;

public abstract class SingleGroupSource
implements ToXContentObject {
    protected static final ParseField FIELD = new ParseField("field", new String[0]);
    protected static final ParseField SCRIPT = new ParseField("script", new String[0]);
    protected static final ParseField MISSING_BUCKET = new ParseField("missing_bucket", new String[0]);
    protected final String field;
    protected final Script script;
    protected final boolean missingBucket;

    public SingleGroupSource(String field, Script script, boolean missingBucket) {
        this.field = field;
        this.script = script;
        this.missingBucket = missingBucket;
    }

    public abstract Type getType();

    public String getField() {
        return this.field;
    }

    public Script getScript() {
        return this.script;
    }

    public boolean getMissingBucket() {
        return this.missingBucket;
    }

    protected void innerXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        if (this.field != null) {
            builder.field(FIELD.getPreferredName(), this.field);
        }
        if (this.script != null) {
            builder.field(SCRIPT.getPreferredName(), this.script);
        }
        if (this.missingBucket) {
            builder.field(MISSING_BUCKET.getPreferredName(), this.missingBucket);
        }
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof SingleGroupSource)) {
            return false;
        }
        SingleGroupSource that = (SingleGroupSource)other;
        return this.missingBucket == that.missingBucket && Objects.equals(this.field, that.field) && Objects.equals(this.script, that.script);
    }

    public int hashCode() {
        return Objects.hash(this.field, this.script, this.missingBucket);
    }

    public static enum Type {
        TERMS,
        HISTOGRAM,
        DATE_HISTOGRAM,
        GEOTILE_GRID;


        public String value() {
            return this.name().toLowerCase(Locale.ROOT);
        }
    }
}

