/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.client.transform.transforms.pivot;

import java.io.IOException;
import java.util.Objects;
import org.elasticsearch.client.transform.transforms.pivot.SingleGroupSource;
import org.elasticsearch.script.Script;
import org.elasticsearch.xcontent.ConstructingObjectParser;
import org.elasticsearch.xcontent.ParseField;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.ToXContentObject;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xcontent.XContentParser;

public class HistogramGroupSource
extends SingleGroupSource
implements ToXContentObject {
    protected static final ParseField INTERVAL = new ParseField("interval", new String[0]);
    private static final ConstructingObjectParser<HistogramGroupSource, Void> PARSER = new ConstructingObjectParser("histogram_group_source", true, args -> new HistogramGroupSource((String)args[0], (Script)args[1], args[2] == null ? false : (Boolean)args[2], (Double)args[3]));
    private final double interval;

    public static HistogramGroupSource fromXContent(XContentParser parser) {
        return PARSER.apply(parser, null);
    }

    HistogramGroupSource(String field, Script script, double interval) {
        this(field, script, false, interval);
    }

    HistogramGroupSource(String field, Script script, boolean missingBucket, double interval) {
        super(field, script, missingBucket);
        if (interval <= 0.0) {
            throw new IllegalArgumentException("[interval] must be greater than 0.");
        }
        this.interval = interval;
    }

    @Override
    public SingleGroupSource.Type getType() {
        return SingleGroupSource.Type.HISTOGRAM;
    }

    public double getInterval() {
        return this.interval;
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        super.innerXContent(builder, params);
        builder.field(INTERVAL.getPreferredName(), this.interval);
        builder.endObject();
        return builder;
    }

    @Override
    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || this.getClass() != other.getClass()) {
            return false;
        }
        HistogramGroupSource that = (HistogramGroupSource)other;
        return this.missingBucket == that.missingBucket && Objects.equals(this.field, that.field) && Objects.equals(this.script, that.script) && Objects.equals(this.interval, that.interval);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.field, this.script, this.interval, this.missingBucket);
    }

    public static Builder builder() {
        return new Builder();
    }

    static {
        PARSER.declareString(ConstructingObjectParser.optionalConstructorArg(), FIELD);
        Script.declareScript(PARSER, ConstructingObjectParser.optionalConstructorArg(), SCRIPT);
        PARSER.declareBoolean(ConstructingObjectParser.optionalConstructorArg(), MISSING_BUCKET);
        PARSER.declareDouble(ConstructingObjectParser.optionalConstructorArg(), INTERVAL);
    }

    public static class Builder {
        private String field;
        private Script script;
        private boolean missingBucket;
        private double interval;

        public Builder setField(String field) {
            this.field = field;
            return this;
        }

        public Builder setInterval(double interval) {
            this.interval = interval;
            return this;
        }

        public Builder setScript(Script script) {
            this.script = script;
            return this;
        }

        public Builder setMissingBucket(boolean missingBucket) {
            this.missingBucket = missingBucket;
            return this;
        }

        public HistogramGroupSource build() {
            return new HistogramGroupSource(this.field, this.script, this.missingBucket, this.interval);
        }
    }
}

