/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.client.transform.transforms;

import java.io.IOException;
import java.util.Objects;
import org.elasticsearch.xcontent.ConstructingObjectParser;
import org.elasticsearch.xcontent.ObjectParser;
import org.elasticsearch.xcontent.ParseField;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.ToXContentObject;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xcontent.XContentParser;

public class SettingsConfig
implements ToXContentObject {
    private static final ParseField MAX_PAGE_SEARCH_SIZE = new ParseField("max_page_search_size", new String[0]);
    private static final ParseField DOCS_PER_SECOND = new ParseField("docs_per_second", new String[0]);
    private static final ParseField DATES_AS_EPOCH_MILLIS = new ParseField("dates_as_epoch_millis", new String[0]);
    private static final ParseField ALIGN_CHECKPOINTS = new ParseField("align_checkpoints", new String[0]);
    private static final ParseField USE_PIT = new ParseField("use_point_in_time", new String[0]);
    private static final int DEFAULT_MAX_PAGE_SEARCH_SIZE = -1;
    private static final float DEFAULT_DOCS_PER_SECOND = -1.0f;
    private static final int DEFAULT_DATES_AS_EPOCH_MILLIS = -1;
    private static final int DEFAULT_ALIGN_CHECKPOINTS = -1;
    private static final int DEFAULT_USE_PIT = -1;
    private final Integer maxPageSearchSize;
    private final Float docsPerSecond;
    private final Integer datesAsEpochMillis;
    private final Integer alignCheckpoints;
    private final Integer usePit;
    private static final ConstructingObjectParser<SettingsConfig, Void> PARSER = new ConstructingObjectParser("settings_config", true, args -> new SettingsConfig((Integer)args[0], (Float)args[1], (Integer)args[2], (Integer)args[3], (Integer)args[4]));

    public static SettingsConfig fromXContent(XContentParser parser) {
        return PARSER.apply(parser, null);
    }

    SettingsConfig(Integer maxPageSearchSize, Float docsPerSecond, Integer datesAsEpochMillis, Integer alignCheckpoints, Integer usePit) {
        this.maxPageSearchSize = maxPageSearchSize;
        this.docsPerSecond = docsPerSecond;
        this.datesAsEpochMillis = datesAsEpochMillis;
        this.alignCheckpoints = alignCheckpoints;
        this.usePit = usePit;
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        if (this.maxPageSearchSize != null) {
            if (this.maxPageSearchSize.equals(-1)) {
                builder.field(MAX_PAGE_SEARCH_SIZE.getPreferredName(), (Integer)null);
            } else {
                builder.field(MAX_PAGE_SEARCH_SIZE.getPreferredName(), this.maxPageSearchSize);
            }
        }
        if (this.docsPerSecond != null) {
            if (this.docsPerSecond.equals(Float.valueOf(-1.0f))) {
                builder.field(DOCS_PER_SECOND.getPreferredName(), (Float)null);
            } else {
                builder.field(DOCS_PER_SECOND.getPreferredName(), this.docsPerSecond);
            }
        }
        if (this.datesAsEpochMillis != null) {
            if (this.datesAsEpochMillis.equals(-1)) {
                builder.field(DATES_AS_EPOCH_MILLIS.getPreferredName(), (Boolean)null);
            } else {
                builder.field(DATES_AS_EPOCH_MILLIS.getPreferredName(), this.datesAsEpochMillis > 0);
            }
        }
        if (this.alignCheckpoints != null) {
            if (this.alignCheckpoints.equals(-1)) {
                builder.field(ALIGN_CHECKPOINTS.getPreferredName(), (Boolean)null);
            } else {
                builder.field(ALIGN_CHECKPOINTS.getPreferredName(), this.alignCheckpoints > 0);
            }
        }
        if (this.usePit != null) {
            if (this.usePit.equals(-1)) {
                builder.field(USE_PIT.getPreferredName(), (Boolean)null);
            } else {
                builder.field(USE_PIT.getPreferredName(), this.usePit > 0);
            }
        }
        builder.endObject();
        return builder;
    }

    public Integer getMaxPageSearchSize() {
        return this.maxPageSearchSize;
    }

    public Float getDocsPerSecond() {
        return this.docsPerSecond;
    }

    public Boolean getDatesAsEpochMillis() {
        return this.datesAsEpochMillis != null ? Boolean.valueOf(this.datesAsEpochMillis > 0) : null;
    }

    public Boolean getAlignCheckpoints() {
        return this.alignCheckpoints != null ? Boolean.valueOf(this.alignCheckpoints > 0) : null;
    }

    public Boolean getUsePit() {
        return this.usePit != null ? Boolean.valueOf(this.usePit > 0) : null;
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (other == null || other.getClass() != this.getClass()) {
            return false;
        }
        SettingsConfig that = (SettingsConfig)other;
        return Objects.equals(this.maxPageSearchSize, that.maxPageSearchSize) && Objects.equals(this.docsPerSecond, that.docsPerSecond) && Objects.equals(this.datesAsEpochMillis, that.datesAsEpochMillis) && Objects.equals(this.alignCheckpoints, that.alignCheckpoints) && Objects.equals(this.usePit, that.usePit);
    }

    public int hashCode() {
        return Objects.hash(this.maxPageSearchSize, this.docsPerSecond, this.datesAsEpochMillis, this.alignCheckpoints, this.usePit);
    }

    public static Builder builder() {
        return new Builder();
    }

    static {
        PARSER.declareIntOrNull(ConstructingObjectParser.optionalConstructorArg(), -1, MAX_PAGE_SEARCH_SIZE);
        PARSER.declareFloatOrNull(ConstructingObjectParser.optionalConstructorArg(), -1.0f, DOCS_PER_SECOND);
        PARSER.declareField(ConstructingObjectParser.optionalConstructorArg(), p -> p.currentToken() == XContentParser.Token.VALUE_NULL ? -1 : (p.booleanValue() ? 1 : 0), DATES_AS_EPOCH_MILLIS, ObjectParser.ValueType.BOOLEAN_OR_NULL);
        PARSER.declareField(ConstructingObjectParser.optionalConstructorArg(), p -> p.currentToken() == XContentParser.Token.VALUE_NULL ? -1 : (p.booleanValue() ? 1 : 0), ALIGN_CHECKPOINTS, ObjectParser.ValueType.BOOLEAN_OR_NULL);
        PARSER.declareField(ConstructingObjectParser.optionalConstructorArg(), p -> p.currentToken() == XContentParser.Token.VALUE_NULL ? -1 : (p.booleanValue() ? 1 : 0), USE_PIT, ObjectParser.ValueType.BOOLEAN_OR_NULL);
    }

    public static class Builder {
        private Integer maxPageSearchSize;
        private Float docsPerSecond;
        private Integer datesAsEpochMillis;
        private Integer alignCheckpoints;
        private Integer usePit;

        public Builder setMaxPageSearchSize(Integer maxPageSearchSize) {
            this.maxPageSearchSize = maxPageSearchSize == null ? -1 : maxPageSearchSize;
            return this;
        }

        public Builder setRequestsPerSecond(Float documentsPerSecond) {
            this.docsPerSecond = Float.valueOf(documentsPerSecond == null ? -1.0f : documentsPerSecond.floatValue());
            return this;
        }

        public Builder setDatesAsEpochMillis(Boolean datesAsEpochMillis) {
            this.datesAsEpochMillis = datesAsEpochMillis == null ? -1 : (datesAsEpochMillis != false ? 1 : 0);
            return this;
        }

        public Builder setAlignCheckpoints(Boolean alignCheckpoints) {
            this.alignCheckpoints = alignCheckpoints == null ? -1 : (alignCheckpoints != false ? 1 : 0);
            return this;
        }

        public Builder setUsePit(Boolean usePit) {
            this.usePit = usePit == null ? -1 : (usePit != false ? 1 : 0);
            return this;
        }

        public SettingsConfig build() {
            return new SettingsConfig(this.maxPageSearchSize, this.docsPerSecond, this.datesAsEpochMillis, this.alignCheckpoints, this.usePit);
        }
    }
}

