/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.client.security.support;

import java.io.IOException;
import java.util.Objects;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.xcontent.ConstructingObjectParser;
import org.elasticsearch.xcontent.ParseField;
import org.elasticsearch.xcontent.XContentParser;

public final class CertificateInfo {
    public static final ParseField PATH = new ParseField("path", new String[0]);
    public static final ParseField FORMAT = new ParseField("format", new String[0]);
    public static final ParseField ALIAS = new ParseField("alias", new String[0]);
    public static final ParseField SUBJECT_DN = new ParseField("subject_dn", new String[0]);
    public static final ParseField SERIAL_NUMBER = new ParseField("serial_number", new String[0]);
    public static final ParseField HAS_PRIVATE_KEY = new ParseField("has_private_key", new String[0]);
    public static final ParseField EXPIRY = new ParseField("expiry", new String[0]);
    private final String path;
    private final String format;
    private final String alias;
    private final String subjectDn;
    private final String serialNumber;
    private final boolean hasPrivateKey;
    private final String expiry;
    public static final ConstructingObjectParser<CertificateInfo, Void> PARSER = new ConstructingObjectParser("certificate_info", true, args -> new CertificateInfo((String)args[0], (String)args[1], (String)args[2], (String)args[3], (String)args[4], (Boolean)args[5], (String)args[6]));

    public CertificateInfo(String path, String format, @Nullable String alias, String subjectDn, String serialNumber, boolean hasPrivateKey, String expiry) {
        this.path = path;
        this.format = format;
        this.alias = alias;
        this.subjectDn = subjectDn;
        this.serialNumber = serialNumber;
        this.hasPrivateKey = hasPrivateKey;
        this.expiry = expiry;
    }

    public String getPath() {
        return this.path;
    }

    public String getFormat() {
        return this.format;
    }

    public String getAlias() {
        return this.alias;
    }

    public String getSubjectDn() {
        return this.subjectDn;
    }

    public String getSerialNumber() {
        return this.serialNumber;
    }

    public boolean hasPrivateKey() {
        return this.hasPrivateKey;
    }

    public String getExpiry() {
        return this.expiry;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || this.getClass() != other.getClass()) {
            return false;
        }
        CertificateInfo that = (CertificateInfo)other;
        return this.path.equals(that.path) && this.format.equals(that.format) && this.hasPrivateKey == that.hasPrivateKey && Objects.equals(this.alias, that.alias) && this.serialNumber.equals(that.serialNumber) && this.subjectDn.equals(that.subjectDn) && this.expiry.equals(that.expiry);
    }

    public int hashCode() {
        return Objects.hash(this.path, this.format, this.alias, this.subjectDn, this.serialNumber, this.hasPrivateKey, this.expiry);
    }

    public static CertificateInfo fromXContent(XContentParser parser) throws IOException {
        return PARSER.parse(parser, null);
    }

    static {
        PARSER.declareString(ConstructingObjectParser.constructorArg(), PATH);
        PARSER.declareString(ConstructingObjectParser.constructorArg(), FORMAT);
        PARSER.declareStringOrNull(ConstructingObjectParser.constructorArg(), ALIAS);
        PARSER.declareString(ConstructingObjectParser.constructorArg(), SUBJECT_DN);
        PARSER.declareString(ConstructingObjectParser.constructorArg(), SERIAL_NUMBER);
        PARSER.declareBoolean(ConstructingObjectParser.constructorArg(), HAS_PRIVATE_KEY);
        PARSER.declareString(ConstructingObjectParser.constructorArg(), EXPIRY);
    }
}

