/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.client.ml.job.config;

import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.SortedSet;
import java.util.TreeSet;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.xcontent.ObjectParser;
import org.elasticsearch.xcontent.ParseField;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.ToXContentObject;
import org.elasticsearch.xcontent.XContentBuilder;

public class MlFilter
implements ToXContentObject {
    public static final ParseField TYPE = new ParseField("type", new String[0]);
    public static final ParseField ID = new ParseField("filter_id", new String[0]);
    public static final ParseField DESCRIPTION = new ParseField("description", new String[0]);
    public static final ParseField ITEMS = new ParseField("items", new String[0]);
    public static final ParseField RESULTS_FIELD = new ParseField("filters", new String[0]);
    public static final ObjectParser<Builder, Void> PARSER = new ObjectParser(TYPE.getPreferredName(), true, () -> new Builder());
    private final String id;
    private final String description;
    private final SortedSet<String> items;

    private MlFilter(String id, String description, SortedSet<String> items) {
        this.id = Objects.requireNonNull(id);
        this.description = description;
        this.items = Collections.unmodifiableSortedSet(items);
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        builder.field(ID.getPreferredName(), this.id);
        if (this.description != null) {
            builder.field(DESCRIPTION.getPreferredName(), this.description);
        }
        builder.field(ITEMS.getPreferredName(), this.items);
        builder.endObject();
        return builder;
    }

    public String getId() {
        return this.id;
    }

    public String getDescription() {
        return this.description;
    }

    public SortedSet<String> getItems() {
        return this.items;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof MlFilter)) {
            return false;
        }
        MlFilter other = (MlFilter)obj;
        return this.id.equals(other.id) && Objects.equals(this.description, other.description) && this.items.equals(other.items);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.description, this.items);
    }

    public static Builder builder(String filterId) {
        return new Builder().setId(filterId);
    }

    static {
        PARSER.declareString((builder, s) -> {}, TYPE);
        PARSER.declareString(Builder::setId, ID);
        PARSER.declareStringOrNull(Builder::setDescription, DESCRIPTION);
        PARSER.declareStringArray(Builder::setItems, ITEMS);
    }

    public static class Builder {
        private String id;
        private String description;
        private SortedSet<String> items = new TreeSet<String>();

        private Builder() {
        }

        public Builder setId(String id) {
            this.id = Objects.requireNonNull(id);
            return this;
        }

        @Nullable
        public String getId() {
            return this.id;
        }

        public Builder setDescription(String description) {
            this.description = description;
            return this;
        }

        public Builder setItems(SortedSet<String> items) {
            this.items = Objects.requireNonNull(items);
            return this;
        }

        public Builder setItems(List<String> items) {
            this.items = new TreeSet<String>(items);
            return this;
        }

        public Builder setItems(String ... items) {
            this.setItems(Arrays.asList(items));
            return this;
        }

        public MlFilter build() {
            return new MlFilter(this.id, this.description, this.items);
        }
    }
}

