/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.client.ml.dataframe.evaluation.common;

import java.io.IOException;
import java.util.Objects;
import org.elasticsearch.common.Strings;
import org.elasticsearch.xcontent.ConstructingObjectParser;
import org.elasticsearch.xcontent.ParseField;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.ToXContentObject;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xcontent.XContentParser;

public class AucRocPoint
implements ToXContentObject {
    private static final ParseField TPR = new ParseField("tpr", new String[0]);
    private static final ParseField FPR = new ParseField("fpr", new String[0]);
    private static final ParseField THRESHOLD = new ParseField("threshold", new String[0]);
    private static final ConstructingObjectParser<AucRocPoint, Void> PARSER = new ConstructingObjectParser("auc_roc_point", true, args -> new AucRocPoint((Double)args[0], (Double)args[1], (Double)args[2]));
    private final double tpr;
    private final double fpr;
    private final double threshold;

    public static AucRocPoint fromXContent(XContentParser parser) {
        return PARSER.apply(parser, null);
    }

    public AucRocPoint(double tpr, double fpr, double threshold) {
        this.tpr = tpr;
        this.fpr = fpr;
        this.threshold = threshold;
    }

    public double getTruePositiveRate() {
        return this.tpr;
    }

    public double getFalsePositiveRate() {
        return this.fpr;
    }

    public double getThreshold() {
        return this.threshold;
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        return builder.startObject().field(TPR.getPreferredName(), this.tpr).field(FPR.getPreferredName(), this.fpr).field(THRESHOLD.getPreferredName(), this.threshold).endObject();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AucRocPoint that = (AucRocPoint)o;
        return this.tpr == that.tpr && this.fpr == that.fpr && this.threshold == that.threshold;
    }

    public int hashCode() {
        return Objects.hash(this.tpr, this.fpr, this.threshold);
    }

    public String toString() {
        return Strings.toString(this);
    }

    static {
        PARSER.declareDouble(ConstructingObjectParser.constructorArg(), TPR);
        PARSER.declareDouble(ConstructingObjectParser.constructorArg(), FPR);
        PARSER.declareDouble(ConstructingObjectParser.constructorArg(), THRESHOLD);
    }
}

