/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.client.ml.dataframe.evaluation.classification;

import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.elasticsearch.client.ml.dataframe.evaluation.EvaluationMetric;
import org.elasticsearch.client.ml.dataframe.evaluation.classification.PerClassSingleValue;
import org.elasticsearch.xcontent.ConstructingObjectParser;
import org.elasticsearch.xcontent.ObjectParser;
import org.elasticsearch.xcontent.ParseField;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xcontent.XContentParser;

public class PrecisionMetric
implements EvaluationMetric {
    public static final String NAME = "precision";
    private static final ObjectParser<PrecisionMetric, Void> PARSER = new ObjectParser("precision", true, PrecisionMetric::new);

    public static PrecisionMetric fromXContent(XContentParser parser) {
        return PARSER.apply(parser, null);
    }

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        builder.endObject();
        return builder;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        return o != null && this.getClass() == o.getClass();
    }

    public int hashCode() {
        return Objects.hashCode(NAME);
    }

    public static class Result
    implements EvaluationMetric.Result {
        private static final ParseField CLASSES = new ParseField("classes", new String[0]);
        private static final ParseField AVG_PRECISION = new ParseField("avg_precision", new String[0]);
        private static final ConstructingObjectParser<Result, Void> PARSER = new ConstructingObjectParser("precision_result", true, a -> new Result((List)a[0], (Double)a[1]));
        private final List<PerClassSingleValue> classes;
        private final double avgPrecision;

        public static Result fromXContent(XContentParser parser) {
            return PARSER.apply(parser, null);
        }

        public Result(List<PerClassSingleValue> classes, double avgPrecision) {
            this.classes = Collections.unmodifiableList(Objects.requireNonNull(classes));
            this.avgPrecision = avgPrecision;
        }

        @Override
        public String getMetricName() {
            return PrecisionMetric.NAME;
        }

        public List<PerClassSingleValue> getClasses() {
            return this.classes;
        }

        public double getAvgPrecision() {
            return this.avgPrecision;
        }

        @Override
        public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            builder.startObject();
            builder.field(CLASSES.getPreferredName(), this.classes);
            builder.field(AVG_PRECISION.getPreferredName(), this.avgPrecision);
            builder.endObject();
            return builder;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Result that = (Result)o;
            return Objects.equals(this.classes, that.classes) && this.avgPrecision == that.avgPrecision;
        }

        public int hashCode() {
            return Objects.hash(this.classes, this.avgPrecision);
        }

        static {
            PARSER.declareObjectArray(ConstructingObjectParser.constructorArg(), PerClassSingleValue.PARSER, CLASSES);
            PARSER.declareDouble(ConstructingObjectParser.constructorArg(), AVG_PRECISION);
        }
    }
}

