/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.client.ml.dataframe;

import java.io.IOException;
import java.util.List;
import java.util.Objects;
import org.elasticsearch.client.ml.NodeAttributes;
import org.elasticsearch.client.ml.dataframe.DataFrameAnalyticsState;
import org.elasticsearch.client.ml.dataframe.PhaseProgress;
import org.elasticsearch.client.ml.dataframe.stats.AnalysisStats;
import org.elasticsearch.client.ml.dataframe.stats.common.DataCounts;
import org.elasticsearch.client.ml.dataframe.stats.common.MemoryUsage;
import org.elasticsearch.common.inject.internal.ToStringBuilder;
import org.elasticsearch.common.xcontent.XContentParserUtils;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.xcontent.ConstructingObjectParser;
import org.elasticsearch.xcontent.ParseField;
import org.elasticsearch.xcontent.XContentParser;

public class DataFrameAnalyticsStats {
    static final ParseField ID = new ParseField("id", new String[0]);
    static final ParseField STATE = new ParseField("state", new String[0]);
    static final ParseField FAILURE_REASON = new ParseField("failure_reason", new String[0]);
    static final ParseField PROGRESS = new ParseField("progress", new String[0]);
    static final ParseField DATA_COUNTS = new ParseField("data_counts", new String[0]);
    static final ParseField MEMORY_USAGE = new ParseField("memory_usage", new String[0]);
    static final ParseField ANALYSIS_STATS = new ParseField("analysis_stats", new String[0]);
    static final ParseField NODE = new ParseField("node", new String[0]);
    static final ParseField ASSIGNMENT_EXPLANATION = new ParseField("assignment_explanation", new String[0]);
    private static final ConstructingObjectParser<DataFrameAnalyticsStats, Void> PARSER = new ConstructingObjectParser("data_frame_analytics_stats", true, args -> new DataFrameAnalyticsStats((String)args[0], (DataFrameAnalyticsState)((Object)((Object)args[1])), (String)args[2], (List)args[3], (DataCounts)args[4], (MemoryUsage)args[5], (AnalysisStats)args[6], (NodeAttributes)args[7], (String)args[8]));
    private final String id;
    private final DataFrameAnalyticsState state;
    private final String failureReason;
    private final List<PhaseProgress> progress;
    private final DataCounts dataCounts;
    private final MemoryUsage memoryUsage;
    private final AnalysisStats analysisStats;
    private final NodeAttributes node;
    private final String assignmentExplanation;

    public static DataFrameAnalyticsStats fromXContent(XContentParser parser) throws IOException {
        return PARSER.parse(parser, null);
    }

    private static AnalysisStats parseAnalysisStats(XContentParser parser) throws IOException {
        XContentParserUtils.ensureExpectedToken(XContentParser.Token.START_OBJECT, parser.currentToken(), parser);
        XContentParserUtils.ensureExpectedToken(XContentParser.Token.FIELD_NAME, parser.nextToken(), parser);
        AnalysisStats analysisStats = parser.namedObject(AnalysisStats.class, parser.currentName(), true);
        XContentParserUtils.ensureExpectedToken(XContentParser.Token.END_OBJECT, parser.nextToken(), parser);
        return analysisStats;
    }

    public DataFrameAnalyticsStats(String id, DataFrameAnalyticsState state, @Nullable String failureReason, @Nullable List<PhaseProgress> progress, @Nullable DataCounts dataCounts, @Nullable MemoryUsage memoryUsage, @Nullable AnalysisStats analysisStats, @Nullable NodeAttributes node, @Nullable String assignmentExplanation) {
        this.id = id;
        this.state = state;
        this.failureReason = failureReason;
        this.progress = progress;
        this.dataCounts = dataCounts;
        this.memoryUsage = memoryUsage;
        this.analysisStats = analysisStats;
        this.node = node;
        this.assignmentExplanation = assignmentExplanation;
    }

    public String getId() {
        return this.id;
    }

    public DataFrameAnalyticsState getState() {
        return this.state;
    }

    public String getFailureReason() {
        return this.failureReason;
    }

    public List<PhaseProgress> getProgress() {
        return this.progress;
    }

    @Nullable
    public DataCounts getDataCounts() {
        return this.dataCounts;
    }

    @Nullable
    public MemoryUsage getMemoryUsage() {
        return this.memoryUsage;
    }

    @Nullable
    public AnalysisStats getAnalysisStats() {
        return this.analysisStats;
    }

    public NodeAttributes getNode() {
        return this.node;
    }

    public String getAssignmentExplanation() {
        return this.assignmentExplanation;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DataFrameAnalyticsStats other = (DataFrameAnalyticsStats)o;
        return Objects.equals(this.id, other.id) && Objects.equals((Object)this.state, (Object)other.state) && Objects.equals(this.failureReason, other.failureReason) && Objects.equals(this.progress, other.progress) && Objects.equals(this.dataCounts, other.dataCounts) && Objects.equals(this.memoryUsage, other.memoryUsage) && Objects.equals(this.analysisStats, other.analysisStats) && Objects.equals(this.node, other.node) && Objects.equals(this.assignmentExplanation, other.assignmentExplanation);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.id, this.state, this.failureReason, this.progress, this.dataCounts, this.memoryUsage, this.analysisStats, this.node, this.assignmentExplanation});
    }

    public String toString() {
        return new ToStringBuilder(this.getClass()).add("id", this.id).add("state", (Object)this.state).add("failureReason", this.failureReason).add("progress", this.progress).add("dataCounts", this.dataCounts).add("memoryUsage", this.memoryUsage).add("analysisStats", this.analysisStats).add("node", this.node).add("assignmentExplanation", this.assignmentExplanation).toString();
    }

    static {
        PARSER.declareString(ConstructingObjectParser.constructorArg(), ID);
        PARSER.declareString(ConstructingObjectParser.constructorArg(), DataFrameAnalyticsState::fromString, STATE);
        PARSER.declareString(ConstructingObjectParser.optionalConstructorArg(), FAILURE_REASON);
        PARSER.declareObjectArray(ConstructingObjectParser.optionalConstructorArg(), PhaseProgress.PARSER, PROGRESS);
        PARSER.declareObject(ConstructingObjectParser.optionalConstructorArg(), DataCounts.PARSER, DATA_COUNTS);
        PARSER.declareObject(ConstructingObjectParser.optionalConstructorArg(), MemoryUsage.PARSER, MEMORY_USAGE);
        PARSER.declareObject(ConstructingObjectParser.optionalConstructorArg(), (p, c) -> DataFrameAnalyticsStats.parseAnalysisStats(p), ANALYSIS_STATS);
        PARSER.declareObject(ConstructingObjectParser.optionalConstructorArg(), NodeAttributes.PARSER, NODE);
        PARSER.declareString(ConstructingObjectParser.optionalConstructorArg(), ASSIGNMENT_EXPLANATION);
    }
}

