/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.client.ml;

import java.util.Objects;
import org.elasticsearch.common.unit.ByteSizeValue;
import org.elasticsearch.xcontent.ConstructingObjectParser;
import org.elasticsearch.xcontent.ParseField;
import org.elasticsearch.xcontent.XContentParser;

public class EstimateModelMemoryResponse {
    public static final ParseField MODEL_MEMORY_ESTIMATE = new ParseField("model_memory_estimate", new String[0]);
    static final ConstructingObjectParser<EstimateModelMemoryResponse, Void> PARSER = new ConstructingObjectParser("estimate_model_memory", true, args -> new EstimateModelMemoryResponse((String)args[0]));
    private final ByteSizeValue modelMemoryEstimate;

    public static EstimateModelMemoryResponse fromXContent(XContentParser parser) {
        return PARSER.apply(parser, null);
    }

    public EstimateModelMemoryResponse(String modelMemoryEstimate) {
        this.modelMemoryEstimate = ByteSizeValue.parseBytesSizeValue(modelMemoryEstimate, MODEL_MEMORY_ESTIMATE.getPreferredName());
    }

    public ByteSizeValue getModelMemoryEstimate() {
        return this.modelMemoryEstimate;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        EstimateModelMemoryResponse other = (EstimateModelMemoryResponse)o;
        return Objects.equals(this.modelMemoryEstimate, other.modelMemoryEstimate);
    }

    public int hashCode() {
        return Objects.hash(this.modelMemoryEstimate);
    }

    static {
        PARSER.declareString(ConstructingObjectParser.constructorArg(), MODEL_MEMORY_ESTIMATE);
    }
}

