/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.client.core;

import java.io.IOException;
import java.util.Objects;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.xcontent.ConstructingObjectParser;
import org.elasticsearch.xcontent.ParseField;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.ToXContentObject;
import org.elasticsearch.xcontent.XContentBuilder;

public class PageParams
implements ToXContentObject {
    public static final ParseField PAGE = new ParseField("page", new String[0]);
    public static final ParseField FROM = new ParseField("from", new String[0]);
    public static final ParseField SIZE = new ParseField("size", new String[0]);
    public static final ConstructingObjectParser<PageParams, Void> PARSER = new ConstructingObjectParser(PAGE.getPreferredName(), a -> new PageParams((Integer)a[0], (Integer)a[1]));
    private final Integer from;
    private final Integer size;

    public PageParams(@Nullable Integer from, @Nullable Integer size) {
        this.from = from;
        this.size = size;
    }

    public Integer getFrom() {
        return this.from;
    }

    public Integer getSize() {
        return this.size;
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        if (this.from != null) {
            builder.field(FROM.getPreferredName(), this.from);
        }
        if (this.size != null) {
            builder.field(SIZE.getPreferredName(), this.size);
        }
        builder.endObject();
        return builder;
    }

    public int hashCode() {
        return Objects.hash(this.from, this.size);
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        PageParams other = (PageParams)obj;
        return Objects.equals(this.from, other.from) && Objects.equals(this.size, other.size);
    }

    static {
        PARSER.declareInt(ConstructingObjectParser.optionalConstructorArg(), FROM);
        PARSER.declareInt(ConstructingObjectParser.optionalConstructorArg(), SIZE);
    }
}

