/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.search;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.lucene.search.TopDocs;
import org.elasticsearch.action.search.ArraySearchPhaseResults;
import org.elasticsearch.action.search.SearchPhaseController;
import org.elasticsearch.action.search.SearchProgressListener;
import org.elasticsearch.action.search.SearchRequest;
import org.elasticsearch.action.search.SearchShard;
import org.elasticsearch.common.breaker.CircuitBreaker;
import org.elasticsearch.common.io.stream.DelayableWriteable;
import org.elasticsearch.common.lucene.search.TopDocsAndMaxScore;
import org.elasticsearch.common.util.concurrent.AbstractRunnable;
import org.elasticsearch.core.Releasable;
import org.elasticsearch.core.Releasables;
import org.elasticsearch.search.SearchPhaseResult;
import org.elasticsearch.search.SearchShardTarget;
import org.elasticsearch.search.aggregations.InternalAggregation;
import org.elasticsearch.search.aggregations.InternalAggregations;
import org.elasticsearch.search.builder.SearchSourceBuilder;
import org.elasticsearch.search.query.QuerySearchResult;

public class QueryPhaseResultConsumer
extends ArraySearchPhaseResults<SearchPhaseResult>
implements Releasable {
    private static final Logger logger = LogManager.getLogger(QueryPhaseResultConsumer.class);
    private final Executor executor;
    private final CircuitBreaker circuitBreaker;
    private final SearchPhaseController controller;
    private final SearchProgressListener progressListener;
    private final InternalAggregation.ReduceContextBuilder aggReduceContextBuilder;
    private final int topNSize;
    private final boolean hasTopDocs;
    private final boolean hasAggs;
    private final boolean performFinalReduce;
    private final PendingMerges pendingMerges;
    private final Consumer<Exception> onPartialMergeFailure;

    public QueryPhaseResultConsumer(SearchRequest request, Executor executor, CircuitBreaker circuitBreaker, SearchPhaseController controller, Supplier<Boolean> isCanceled, SearchProgressListener progressListener, int expectedResultSize, Consumer<Exception> onPartialMergeFailure) {
        super(expectedResultSize);
        this.executor = executor;
        this.circuitBreaker = circuitBreaker;
        this.controller = controller;
        this.progressListener = progressListener;
        this.aggReduceContextBuilder = controller.getReduceContext(isCanceled, request);
        this.topNSize = SearchPhaseController.getTopDocsSize(request);
        this.performFinalReduce = request.isFinalReduce();
        this.onPartialMergeFailure = onPartialMergeFailure;
        SearchSourceBuilder source = request.source();
        this.hasTopDocs = source == null || source.size() != 0;
        this.hasAggs = source != null && source.aggregations() != null;
        int batchReduceSize = this.hasAggs || this.hasTopDocs ? Math.min(request.getBatchedReduceSize(), expectedResultSize) : expectedResultSize;
        this.pendingMerges = new PendingMerges(batchReduceSize, request.resolveTrackTotalHitsUpTo());
    }

    @Override
    public void close() {
        Releasables.close((Releasable)this.pendingMerges);
    }

    @Override
    public void consumeResult(SearchPhaseResult result, Runnable next) {
        super.consumeResult(result, () -> {});
        QuerySearchResult querySearchResult = result.queryResult();
        this.progressListener.notifyQueryResult(querySearchResult.getShardIndex());
        this.pendingMerges.consume(querySearchResult, next);
    }

    @Override
    public SearchPhaseController.ReducedQueryPhase reduce() throws Exception {
        if (this.pendingMerges.hasPendingMerges()) {
            throw new AssertionError((Object)"partial reduce in-flight");
        }
        if (this.pendingMerges.hasFailure()) {
            throw this.pendingMerges.getFailure();
        }
        this.pendingMerges.sortBuffer();
        SearchPhaseController.TopDocsStats topDocsStats = this.pendingMerges.consumeTopDocsStats();
        List<TopDocs> topDocsList = this.pendingMerges.consumeTopDocs();
        List<InternalAggregations> aggsList = this.pendingMerges.consumeAggs();
        long breakerSize = this.pendingMerges.circuitBreakerBytes;
        if (this.hasAggs) {
            breakerSize = this.pendingMerges.addEstimateAndMaybeBreak(this.pendingMerges.estimateRamBytesUsedForReduce(breakerSize));
        }
        SearchPhaseController.ReducedQueryPhase reducePhase = this.controller.reducedQueryPhase(this.results.asList(), aggsList, topDocsList, topDocsStats, this.pendingMerges.numReducePhases, false, this.aggReduceContextBuilder, this.performFinalReduce);
        if (this.hasAggs && reducePhase.aggregations != null) {
            long finalSize = DelayableWriteable.getSerializedSize(reducePhase.aggregations) - breakerSize;
            this.pendingMerges.addWithoutBreaking(finalSize);
            logger.trace("aggs final reduction [{}] max [{}]", (Object)this.pendingMerges.aggsCurrentBufferSize, (Object)this.pendingMerges.maxAggsCurrentBufferSize);
        }
        this.progressListener.notifyFinalReduce(SearchProgressListener.buildSearchShards(this.results.asList()), reducePhase.totalHits, reducePhase.aggregations, reducePhase.numReducePhases);
        return reducePhase;
    }

    private MergeResult partialReduce(QuerySearchResult[] toConsume, List<SearchShard> emptyResults, SearchPhaseController.TopDocsStats topDocsStats, MergeResult lastMerge, int numReducePhases) {
        InternalAggregations newAggs;
        TopDocs newTopDocs;
        Arrays.sort(toConsume, Comparator.comparingInt(SearchPhaseResult::getShardIndex));
        for (QuerySearchResult result : toConsume) {
            topDocsStats.add(result.topDocs(), result.searchTimedOut(), result.terminatedEarly());
        }
        if (this.hasTopDocs) {
            ArrayList<TopDocs> topDocsList = new ArrayList<TopDocs>();
            if (lastMerge != null) {
                topDocsList.add(lastMerge.reducedTopDocs);
            }
            for (QuerySearchResult result : toConsume) {
                TopDocsAndMaxScore topDocs = result.consumeTopDocs();
                SearchPhaseController.setShardIndex(topDocs.topDocs, result.getShardIndex());
                topDocsList.add(topDocs.topDocs);
            }
            newTopDocs = SearchPhaseController.mergeTopDocs(topDocsList, this.topNSize, 0);
        } else {
            newTopDocs = null;
        }
        if (this.hasAggs) {
            ArrayList<InternalAggregations> aggsList = new ArrayList<InternalAggregations>();
            if (lastMerge != null) {
                aggsList.add(lastMerge.reducedAggs);
            }
            for (QuerySearchResult result : toConsume) {
                aggsList.add(result.consumeAggs());
            }
            newAggs = InternalAggregations.topLevelReduce(aggsList, this.aggReduceContextBuilder.forPartialReduction());
        } else {
            newAggs = null;
        }
        ArrayList<SearchShard> processedShards = new ArrayList<SearchShard>(emptyResults);
        if (lastMerge != null) {
            processedShards.addAll(lastMerge.processedShards);
        }
        for (QuerySearchResult result : toConsume) {
            SearchShardTarget target = result.getSearchShardTarget();
            processedShards.add(new SearchShard(target.getClusterAlias(), target.getShardId()));
        }
        this.progressListener.notifyPartialReduce(processedShards, topDocsStats.getTotalHits(), newAggs, numReducePhases);
        long serializedSize = this.hasAggs ? DelayableWriteable.getSerializedSize(newAggs) : 0L;
        return new MergeResult(processedShards, newTopDocs, newAggs, this.hasAggs ? serializedSize : 0L);
    }

    public int getNumReducePhases() {
        return this.pendingMerges.numReducePhases;
    }

    private static class MergeResult {
        private final List<SearchShard> processedShards;
        private final TopDocs reducedTopDocs;
        private final InternalAggregations reducedAggs;
        private final long estimatedSize;

        private MergeResult(List<SearchShard> processedShards, TopDocs reducedTopDocs, InternalAggregations reducedAggs, long estimatedSize) {
            this.processedShards = processedShards;
            this.reducedTopDocs = reducedTopDocs;
            this.reducedAggs = reducedAggs;
            this.estimatedSize = estimatedSize;
        }
    }

    private class PendingMerges
    implements Releasable {
        private final int batchReduceSize;
        private final List<QuerySearchResult> buffer = new ArrayList<QuerySearchResult>();
        private final List<SearchShard> emptyResults = new ArrayList<SearchShard>();
        private volatile long circuitBreakerBytes;
        private volatile long aggsCurrentBufferSize;
        private volatile long maxAggsCurrentBufferSize = 0L;
        private final ArrayDeque<MergeTask> queue = new ArrayDeque();
        private final AtomicReference<MergeTask> runningTask = new AtomicReference();
        private final AtomicReference<Exception> failure = new AtomicReference();
        private final SearchPhaseController.TopDocsStats topDocsStats;
        private volatile MergeResult mergeResult;
        private volatile boolean hasPartialReduce;
        private volatile int numReducePhases;

        PendingMerges(int batchReduceSize, int trackTotalHitsUpTo) {
            this.batchReduceSize = batchReduceSize;
            this.topDocsStats = new SearchPhaseController.TopDocsStats(trackTotalHitsUpTo);
        }

        @Override
        public synchronized void close() {
            if (this.hasFailure() ? !$assertionsDisabled && this.circuitBreakerBytes != 0L : !$assertionsDisabled && this.circuitBreakerBytes < 0L) {
                throw new AssertionError();
            }
            ArrayList<Releasable> toRelease = new ArrayList<Releasable>(this.buffer.stream().map(b -> b::releaseAggs).collect(Collectors.toList()));
            toRelease.add(() -> {
                QueryPhaseResultConsumer.this.circuitBreaker.addWithoutBreaking(-this.circuitBreakerBytes);
                this.circuitBreakerBytes = 0L;
            });
            Releasables.close(toRelease);
            if (this.hasPendingMerges()) {
                throw new IllegalStateException("Attempted to close with partial reduce in-flight");
            }
        }

        synchronized Exception getFailure() {
            return this.failure.get();
        }

        boolean hasFailure() {
            return this.failure.get() != null;
        }

        boolean hasPendingMerges() {
            return !this.queue.isEmpty() || this.runningTask.get() != null;
        }

        void sortBuffer() {
            if (this.buffer.size() > 0) {
                Collections.sort(this.buffer, Comparator.comparingInt(SearchPhaseResult::getShardIndex));
            }
        }

        synchronized long addWithoutBreaking(long size) {
            QueryPhaseResultConsumer.this.circuitBreaker.addWithoutBreaking(size);
            this.circuitBreakerBytes += size;
            this.maxAggsCurrentBufferSize = Math.max(this.maxAggsCurrentBufferSize, this.circuitBreakerBytes);
            return this.circuitBreakerBytes;
        }

        synchronized long addEstimateAndMaybeBreak(long estimatedSize) {
            QueryPhaseResultConsumer.this.circuitBreaker.addEstimateBytesAndMaybeBreak(estimatedSize, "<reduce_aggs>");
            this.circuitBreakerBytes += estimatedSize;
            this.maxAggsCurrentBufferSize = Math.max(this.maxAggsCurrentBufferSize, this.circuitBreakerBytes);
            return this.circuitBreakerBytes;
        }

        long ramBytesUsedQueryResult(QuerySearchResult result) {
            return QueryPhaseResultConsumer.this.hasAggs ? result.aggregations().getSerializedSize() : 0L;
        }

        long estimateRamBytesUsedForReduce(long size) {
            return Math.round(1.5 * (double)size - (double)size);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void consume(QuerySearchResult result, Runnable next) {
            boolean executeNextImmediately = true;
            PendingMerges pendingMerges = this;
            synchronized (pendingMerges) {
                if (this.hasFailure() || result.isNull()) {
                    result.consumeAll();
                    if (result.isNull()) {
                        SearchShardTarget target = result.getSearchShardTarget();
                        this.emptyResults.add(new SearchShard(target.getClusterAlias(), target.getShardId()));
                    }
                } else {
                    int size;
                    if (QueryPhaseResultConsumer.this.hasAggs) {
                        long aggsSize = this.ramBytesUsedQueryResult(result);
                        try {
                            this.addEstimateAndMaybeBreak(aggsSize);
                        }
                        catch (Exception exc) {
                            result.releaseAggs();
                            this.buffer.forEach(QuerySearchResult::releaseAggs);
                            this.buffer.clear();
                            this.onMergeFailure(exc);
                            next.run();
                            return;
                        }
                        this.aggsCurrentBufferSize += aggsSize;
                    }
                    if ((size = this.buffer.size() + (this.hasPartialReduce ? 1 : 0)) >= this.batchReduceSize) {
                        this.hasPartialReduce = true;
                        executeNextImmediately = false;
                        QuerySearchResult[] clone = (QuerySearchResult[])this.buffer.stream().toArray(QuerySearchResult[]::new);
                        MergeTask task = new MergeTask(clone, this.aggsCurrentBufferSize, new ArrayList<SearchShard>(this.emptyResults), next);
                        this.aggsCurrentBufferSize = 0L;
                        this.buffer.clear();
                        this.emptyResults.clear();
                        this.queue.add(task);
                        this.tryExecuteNext();
                    }
                    this.buffer.add(result);
                }
            }
            if (executeNextImmediately) {
                next.run();
            }
        }

        private synchronized void onMergeFailure(Exception exc) {
            MergeTask mergeTask;
            if (this.hasFailure()) {
                assert (this.circuitBreakerBytes == 0L);
                return;
            }
            assert (this.circuitBreakerBytes >= 0L);
            if (this.circuitBreakerBytes > 0L) {
                QueryPhaseResultConsumer.this.circuitBreaker.addWithoutBreaking(-this.circuitBreakerBytes);
                this.circuitBreakerBytes = 0L;
            }
            this.failure.compareAndSet(null, exc);
            ArrayList<Releasable> toCancels = new ArrayList<Releasable>();
            toCancels.add(() -> QueryPhaseResultConsumer.this.onPartialMergeFailure.accept(exc));
            MergeTask task = this.runningTask.getAndSet(null);
            if (task != null) {
                toCancels.add(task::cancel);
            }
            while ((mergeTask = this.queue.pollFirst()) != null) {
                toCancels.add(mergeTask::cancel);
            }
            this.mergeResult = null;
            Releasables.close(toCancels);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void onAfterMerge(MergeTask task, MergeResult newResult, long estimatedSize) {
            PendingMerges pendingMerges = this;
            synchronized (pendingMerges) {
                if (this.hasFailure()) {
                    return;
                }
                this.runningTask.compareAndSet(task, null);
                this.mergeResult = newResult;
                if (QueryPhaseResultConsumer.this.hasAggs) {
                    long newSize = this.mergeResult.estimatedSize - estimatedSize;
                    this.addWithoutBreaking(newSize);
                    logger.trace("aggs partial reduction [{}->{}] max [{}]", (Object)estimatedSize, (Object)this.mergeResult.estimatedSize, (Object)this.maxAggsCurrentBufferSize);
                }
                task.consumeListener();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void tryExecuteNext() {
            MergeTask task;
            PendingMerges pendingMerges = this;
            synchronized (pendingMerges) {
                if (this.queue.isEmpty() || this.hasFailure() || this.runningTask.get() != null) {
                    return;
                }
                task = this.queue.poll();
                this.runningTask.compareAndSet(null, task);
            }
            QueryPhaseResultConsumer.this.executor.execute(new AbstractRunnable(){

                @Override
                protected void doRun() {
                    MergeResult newMerge;
                    long estimatedMergeSize;
                    MergeResult thisMergeResult = PendingMerges.this.mergeResult;
                    long estimatedTotalSize = (thisMergeResult != null ? thisMergeResult.estimatedSize : 0L) + task.aggsBufferSize;
                    QuerySearchResult[] toConsume = task.consumeBuffer();
                    if (toConsume == null) {
                        return;
                    }
                    try {
                        estimatedMergeSize = PendingMerges.this.estimateRamBytesUsedForReduce(estimatedTotalSize);
                        PendingMerges.this.addEstimateAndMaybeBreak(estimatedMergeSize);
                        ++PendingMerges.this.numReducePhases;
                        newMerge = QueryPhaseResultConsumer.this.partialReduce(toConsume, task.emptyResults, PendingMerges.this.topDocsStats, thisMergeResult, PendingMerges.this.numReducePhases);
                    }
                    catch (Exception t) {
                        for (QuerySearchResult result : toConsume) {
                            result.releaseAggs();
                        }
                        PendingMerges.this.onMergeFailure(t);
                        return;
                    }
                    PendingMerges.this.onAfterMerge(task, newMerge, estimatedTotalSize += estimatedMergeSize);
                    PendingMerges.this.tryExecuteNext();
                }

                @Override
                public void onFailure(Exception exc) {
                    PendingMerges.this.onMergeFailure(exc);
                }
            });
        }

        public synchronized SearchPhaseController.TopDocsStats consumeTopDocsStats() {
            for (QuerySearchResult result : this.buffer) {
                this.topDocsStats.add(result.topDocs(), result.searchTimedOut(), result.terminatedEarly());
            }
            return this.topDocsStats;
        }

        public synchronized List<TopDocs> consumeTopDocs() {
            if (!QueryPhaseResultConsumer.this.hasTopDocs) {
                return Collections.emptyList();
            }
            ArrayList<TopDocs> topDocsList = new ArrayList<TopDocs>();
            if (this.mergeResult != null) {
                topDocsList.add(this.mergeResult.reducedTopDocs);
            }
            for (QuerySearchResult result : this.buffer) {
                TopDocsAndMaxScore topDocs = result.consumeTopDocs();
                SearchPhaseController.setShardIndex(topDocs.topDocs, result.getShardIndex());
                topDocsList.add(topDocs.topDocs);
            }
            return topDocsList;
        }

        public synchronized List<InternalAggregations> consumeAggs() {
            if (!QueryPhaseResultConsumer.this.hasAggs) {
                return Collections.emptyList();
            }
            ArrayList<InternalAggregations> aggsList = new ArrayList<InternalAggregations>();
            if (this.mergeResult != null) {
                aggsList.add(this.mergeResult.reducedAggs);
            }
            for (QuerySearchResult result : this.buffer) {
                aggsList.add(result.consumeAggs());
            }
            return aggsList;
        }
    }

    private static class MergeTask {
        private final List<SearchShard> emptyResults;
        private QuerySearchResult[] buffer;
        private long aggsBufferSize;
        private Runnable next;

        private MergeTask(QuerySearchResult[] buffer, long aggsBufferSize, List<SearchShard> emptyResults, Runnable next) {
            this.buffer = buffer;
            this.aggsBufferSize = aggsBufferSize;
            this.emptyResults = emptyResults;
            this.next = next;
        }

        public synchronized QuerySearchResult[] consumeBuffer() {
            QuerySearchResult[] toRet = this.buffer;
            this.buffer = null;
            return toRet;
        }

        public void consumeListener() {
            if (this.next != null) {
                this.next.run();
                this.next = null;
            }
        }

        public synchronized void cancel() {
            QuerySearchResult[] buffer = this.consumeBuffer();
            if (buffer != null) {
                for (QuerySearchResult result : buffer) {
                    result.releaseAggs();
                }
            }
            this.consumeListener();
        }
    }
}

