/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.admin.indices.upgrade.post;

import java.io.IOException;
import java.util.Map;
import org.elasticsearch.Version;
import org.elasticsearch.action.ActionRequestValidationException;
import org.elasticsearch.action.ValidateActions;
import org.elasticsearch.action.support.master.AcknowledgedRequest;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.core.Tuple;

public class UpgradeSettingsRequest
extends AcknowledgedRequest<UpgradeSettingsRequest> {
    private Map<String, Tuple<Version, String>> versions;

    public UpgradeSettingsRequest(StreamInput in) throws IOException {
        super(in);
        this.versions = in.readMap(StreamInput::readString, i -> new Tuple<Version, String>(Version.readVersion(i), i.readString()));
    }

    public UpgradeSettingsRequest() {
    }

    public UpgradeSettingsRequest(Map<String, Tuple<Version, String>> versions) {
        this.versions = versions;
    }

    @Override
    public ActionRequestValidationException validate() {
        ActionRequestValidationException validationException = null;
        if (this.versions.isEmpty()) {
            validationException = ValidateActions.addValidationError("no indices to update", validationException);
        }
        return validationException;
    }

    Map<String, Tuple<Version, String>> versions() {
        return this.versions;
    }

    public UpgradeSettingsRequest versions(Map<String, Tuple<Version, String>> versions) {
        this.versions = versions;
        return this;
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        out.writeMap(this.versions, StreamOutput::writeString, (o, v) -> {
            Version.writeVersion((Version)v.v1(), out);
            out.writeString((String)v.v2());
        });
    }
}

