/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.admin.indices.mapping.get;

import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.elasticsearch.action.ActionResponse;
import org.elasticsearch.common.bytes.BytesArray;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.xcontent.XContentHelper;
import org.elasticsearch.common.xcontent.XContentParserUtils;
import org.elasticsearch.xcontent.ConstructingObjectParser;
import org.elasticsearch.xcontent.ObjectParser;
import org.elasticsearch.xcontent.ParseField;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.ToXContentFragment;
import org.elasticsearch.xcontent.ToXContentObject;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xcontent.XContentFactory;
import org.elasticsearch.xcontent.XContentParser;
import org.elasticsearch.xcontent.XContentType;

public class GetFieldMappingsResponse
extends ActionResponse
implements ToXContentObject {
    private static final ParseField MAPPINGS = new ParseField("mappings", new String[0]);
    private static final ObjectParser<Map<String, Map<String, FieldMappingMetadata>>, String> PARSER = new ObjectParser(MAPPINGS.getPreferredName(), true, HashMap::new);
    private final Map<String, Map<String, Map<String, FieldMappingMetadata>>> mappings;

    public GetFieldMappingsResponse(Map<String, Map<String, Map<String, FieldMappingMetadata>>> mappings) {
        this.mappings = mappings;
    }

    GetFieldMappingsResponse(StreamInput in) throws IOException {
        super(in);
        int size = in.readVInt();
        HashMap indexMapBuilder = new HashMap(size);
        for (int i = 0; i < size; ++i) {
            String index = in.readString();
            int typesSize = in.readVInt();
            HashMap typeMapBuilder = new HashMap(typesSize);
            for (int j = 0; j < typesSize; ++j) {
                String type = in.readString();
                int fieldSize = in.readVInt();
                HashMap<String, FieldMappingMetadata> fieldMapBuilder = new HashMap<String, FieldMappingMetadata>(fieldSize);
                for (int k = 0; k < fieldSize; ++k) {
                    fieldMapBuilder.put(in.readString(), new FieldMappingMetadata(in.readString(), in.readBytesReference()));
                }
                typeMapBuilder.put(type, Collections.unmodifiableMap(fieldMapBuilder));
            }
            indexMapBuilder.put(index, Collections.unmodifiableMap(typeMapBuilder));
        }
        this.mappings = Collections.unmodifiableMap(indexMapBuilder);
    }

    public Map<String, Map<String, Map<String, FieldMappingMetadata>>> mappings() {
        return this.mappings;
    }

    public FieldMappingMetadata fieldMappings(String index, String type, String field) {
        Map<String, Map<String, FieldMappingMetadata>> indexMapping = this.mappings.get(index);
        if (indexMapping == null) {
            return null;
        }
        Map<String, FieldMappingMetadata> typeMapping = indexMapping.get(type);
        if (typeMapping == null) {
            return null;
        }
        return typeMapping.get(field);
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        boolean includeTypeName = params.paramAsBoolean("include_type_name", false);
        builder.startObject();
        for (Map.Entry<String, Map<String, Map<String, FieldMappingMetadata>>> indexEntry : this.mappings.entrySet()) {
            builder.startObject(indexEntry.getKey());
            builder.startObject(MAPPINGS.getPreferredName());
            if (!includeTypeName) {
                Map<String, FieldMappingMetadata> mappings = null;
                for (Map.Entry<String, Map<String, FieldMappingMetadata>> typeEntry : indexEntry.getValue().entrySet()) {
                    if (typeEntry.getKey().equals("_default_")) continue;
                    assert (mappings == null);
                    mappings = typeEntry.getValue();
                }
                if (mappings != null) {
                    this.addFieldMappingsToBuilder(builder, params, mappings);
                }
            } else {
                for (Map.Entry<String, Map<String, FieldMappingMetadata>> typeEntry : indexEntry.getValue().entrySet()) {
                    builder.startObject(typeEntry.getKey());
                    this.addFieldMappingsToBuilder(builder, params, typeEntry.getValue());
                    builder.endObject();
                }
            }
            builder.endObject();
            builder.endObject();
        }
        builder.endObject();
        return builder;
    }

    private void addFieldMappingsToBuilder(XContentBuilder builder, ToXContent.Params params, Map<String, FieldMappingMetadata> mappings) throws IOException {
        for (Map.Entry<String, FieldMappingMetadata> fieldEntry : mappings.entrySet()) {
            builder.startObject(fieldEntry.getKey());
            fieldEntry.getValue().toXContent(builder, params);
            builder.endObject();
        }
    }

    public static GetFieldMappingsResponse fromXContent(XContentParser parser) throws IOException {
        XContentParserUtils.ensureExpectedToken(XContentParser.Token.START_OBJECT, parser.nextToken(), parser);
        HashMap<String, Map<String, Map<String, FieldMappingMetadata>>> mappings = new HashMap<String, Map<String, Map<String, FieldMappingMetadata>>>();
        if (parser.nextToken() == XContentParser.Token.FIELD_NAME) {
            while (parser.currentToken() == XContentParser.Token.FIELD_NAME) {
                String index = parser.currentName();
                Map<String, Map<String, FieldMappingMetadata>> typeMappings = PARSER.parse(parser, index);
                mappings.put(index, typeMappings);
                parser.nextToken();
            }
        }
        return new GetFieldMappingsResponse(mappings);
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeVInt(this.mappings.size());
        for (Map.Entry<String, Map<String, Map<String, FieldMappingMetadata>>> indexEntry : this.mappings.entrySet()) {
            out.writeString(indexEntry.getKey());
            out.writeVInt(indexEntry.getValue().size());
            for (Map.Entry<String, Map<String, FieldMappingMetadata>> typeEntry : indexEntry.getValue().entrySet()) {
                out.writeString(typeEntry.getKey());
                out.writeVInt(typeEntry.getValue().size());
                for (Map.Entry<String, FieldMappingMetadata> fieldEntry : typeEntry.getValue().entrySet()) {
                    out.writeString(fieldEntry.getKey());
                    FieldMappingMetadata fieldMapping = fieldEntry.getValue();
                    out.writeString(fieldMapping.fullName());
                    out.writeBytesReference(fieldMapping.source);
                }
            }
        }
    }

    public String toString() {
        return "GetFieldMappingsResponse{mappings=" + this.mappings + '}';
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof GetFieldMappingsResponse)) {
            return false;
        }
        GetFieldMappingsResponse that = (GetFieldMappingsResponse)o;
        return Objects.equals(this.mappings, that.mappings);
    }

    public int hashCode() {
        return Objects.hash(this.mappings);
    }

    static {
        PARSER.declareField((p, typeMappings, index) -> {
            p.nextToken();
            while (p.currentToken() == XContentParser.Token.FIELD_NAME) {
                String typeName = p.currentName();
                if (p.nextToken() == XContentParser.Token.START_OBJECT) {
                    HashMap<String, FieldMappingMetadata> typeMapping = new HashMap<String, FieldMappingMetadata>();
                    typeMappings.put(typeName, typeMapping);
                    while (p.nextToken() == XContentParser.Token.FIELD_NAME) {
                        String fieldName = p.currentName();
                        FieldMappingMetadata fieldMappingMetadata = FieldMappingMetadata.fromXContent(p);
                        typeMapping.put(fieldName, fieldMappingMetadata);
                    }
                } else {
                    p.skipChildren();
                }
                p.nextToken();
            }
        }, MAPPINGS, ObjectParser.ValueType.OBJECT);
    }

    public static class FieldMappingMetadata
    implements ToXContentFragment {
        public static final FieldMappingMetadata NULL = new FieldMappingMetadata("", BytesArray.EMPTY);
        private static final ParseField FULL_NAME = new ParseField("full_name", new String[0]);
        private static final ParseField MAPPING = new ParseField("mapping", new String[0]);
        private static final ConstructingObjectParser<FieldMappingMetadata, String> PARSER = new ConstructingObjectParser("field_mapping_meta_data", true, a -> new FieldMappingMetadata((String)a[0], (BytesReference)a[1]));
        private final String fullName;
        private final BytesReference source;

        public FieldMappingMetadata(String fullName, BytesReference source) {
            this.fullName = fullName;
            this.source = source;
        }

        public String fullName() {
            return this.fullName;
        }

        public Map<String, Object> sourceAsMap() {
            return XContentHelper.convertToMap(this.source, true, XContentType.JSON).v2();
        }

        public boolean isNull() {
            return NULL.fullName().equals(this.fullName) && FieldMappingMetadata.NULL.source.length() == this.source.length();
        }

        BytesReference getSource() {
            return this.source;
        }

        public static FieldMappingMetadata fromXContent(XContentParser parser) throws IOException {
            return PARSER.parse(parser, null);
        }

        @Override
        public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            builder.field(FULL_NAME.getPreferredName(), this.fullName);
            if (params.paramAsBoolean("pretty", false)) {
                builder.field("mapping", this.sourceAsMap());
            } else {
                try (StreamInput stream = this.source.streamInput();){
                    builder.rawField(MAPPING.getPreferredName(), stream, XContentType.JSON);
                }
            }
            return builder;
        }

        public String toString() {
            return "FieldMappingMetadata{fullName='" + this.fullName + '\'' + ", source=" + this.source + '}';
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof FieldMappingMetadata)) {
                return false;
            }
            FieldMappingMetadata that = (FieldMappingMetadata)o;
            return Objects.equals(this.fullName, that.fullName) && Objects.equals(this.source, that.source);
        }

        public int hashCode() {
            return Objects.hash(this.fullName, this.source);
        }

        static {
            PARSER.declareField(ConstructingObjectParser.optionalConstructorArg(), (p, c) -> p.text(), FULL_NAME, ObjectParser.ValueType.STRING);
            PARSER.declareField(ConstructingObjectParser.optionalConstructorArg(), (p, c) -> {
                XContentBuilder jsonBuilder = XContentFactory.jsonBuilder().copyCurrentStructure(p);
                BytesReference bytes = BytesReference.bytes(jsonBuilder);
                return bytes;
            }, MAPPING, ObjectParser.ValueType.OBJECT);
        }
    }
}

