/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.admin.cluster.snapshots.features;

import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.elasticsearch.action.ActionResponse;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.ToXContentObject;
import org.elasticsearch.xcontent.XContentBuilder;

public class GetSnapshottableFeaturesResponse
extends ActionResponse
implements ToXContentObject {
    private final List<SnapshottableFeature> snapshottableFeatures;

    public GetSnapshottableFeaturesResponse(List<SnapshottableFeature> features) {
        this.snapshottableFeatures = Collections.unmodifiableList(features);
    }

    public GetSnapshottableFeaturesResponse(StreamInput in) throws IOException {
        super(in);
        this.snapshottableFeatures = in.readList(SnapshottableFeature::new);
    }

    public List<SnapshottableFeature> getSnapshottableFeatures() {
        return this.snapshottableFeatures;
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeList(this.snapshottableFeatures);
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        builder.startArray("features");
        for (SnapshottableFeature feature : this.snapshottableFeatures) {
            builder.value((Object)feature);
        }
        builder.endArray();
        builder.endObject();
        return builder;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof GetSnapshottableFeaturesResponse)) {
            return false;
        }
        GetSnapshottableFeaturesResponse that = (GetSnapshottableFeaturesResponse)o;
        return this.snapshottableFeatures.equals(that.snapshottableFeatures);
    }

    public int hashCode() {
        return Objects.hash(this.snapshottableFeatures);
    }

    public static class SnapshottableFeature
    implements Writeable,
    ToXContentObject {
        private final String featureName;
        private final String description;

        public SnapshottableFeature(String featureName, String description) {
            this.featureName = featureName;
            this.description = description;
        }

        public SnapshottableFeature(StreamInput in) throws IOException {
            this.featureName = in.readString();
            this.description = in.readString();
        }

        public String getFeatureName() {
            return this.featureName;
        }

        public String getDescription() {
            return this.description;
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            out.writeString(this.featureName);
            out.writeString(this.description);
        }

        @Override
        public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            builder.startObject();
            builder.field("name", this.featureName);
            builder.field("description", this.description);
            builder.endObject();
            return builder;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof SnapshottableFeature)) {
                return false;
            }
            SnapshottableFeature feature = (SnapshottableFeature)o;
            return Objects.equals(this.getFeatureName(), feature.getFeatureName());
        }

        public int hashCode() {
            return Objects.hash(this.getFeatureName());
        }
    }
}

