/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.document;

import java.util.ArrayList;
import java.util.List;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.ShapeField;
import org.apache.lucene.geo.Polygon;
import org.apache.lucene.geo.XTessellator;
import org.apache.lucene.util.BytesRef;

public class XLatLonShape {
    private XLatLonShape() {
    }

    public static Field[] createIndexableFields(String fieldName, Polygon polygon) {
        List<XTessellator.Triangle> tessellation = XTessellator.tessellate(polygon);
        ArrayList<Triangle> fields = new ArrayList<Triangle>();
        for (XTessellator.Triangle t : tessellation) {
            fields.add(new Triangle(fieldName, t));
        }
        return fields.toArray(new Field[fields.size()]);
    }

    public static class Triangle
    extends Field {
        Triangle(String name, XTessellator.Triangle t) {
            super(name, ShapeField.TYPE);
            this.setTriangleValue(t.getEncodedX(0), t.getEncodedY(0), t.isEdgefromPolygon(0), t.getEncodedX(1), t.getEncodedY(1), t.isEdgefromPolygon(1), t.getEncodedX(2), t.getEncodedY(2), t.isEdgefromPolygon(2));
        }

        protected void setTriangleValue(int aX, int aY, boolean abFromShape, int bX, int bY, boolean bcFromShape, int cX, int cY, boolean caFromShape) {
            byte[] bytes;
            if (this.fieldsData == null) {
                bytes = new byte[28];
                this.fieldsData = new BytesRef(bytes);
            } else {
                bytes = ((BytesRef)this.fieldsData).bytes;
            }
            ShapeField.encodeTriangle(bytes, aY, aX, abFromShape, bY, bX, bcFromShape, cY, cX, caFromShape);
        }
    }
}

