/*
 * Decompiled with CFR 0.152.
 */
package net.bluemind.webmodules.vue;

import com.google.common.io.ByteStreams;
import io.netty.util.AsciiString;
import io.vertx.core.Handler;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.http.HttpHeaders;
import io.vertx.core.http.HttpServerRequest;
import io.vertx.core.http.HttpServerResponse;
import java.io.File;
import java.io.InputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VueHandler
implements Handler<HttpServerRequest> {
    private static final Logger logger = LoggerFactory.getLogger(VueHandler.class);
    private static final CharSequence JS = new AsciiString((CharSequence)"application/javascript");
    private static boolean vueDevFileExists = new File("/root/dev-vue").exists();
    private static Buffer vueFileContent = Buffer.buffer((byte[])VueHandler.loadVueFile());

    public void handle(HttpServerRequest httpServerRequest) {
        logger.debug("VueHandler {}", (Object)httpServerRequest.path());
        HttpServerResponse httpServerResponse = httpServerRequest.response();
        httpServerResponse.putHeader(HttpHeaders.CONTENT_TYPE, JS).end(vueFileContent);
    }

    private static byte[] loadVueFile() {
        String string = "vue.min.js";
        if (vueDevFileExists) {
            string = "vue.js";
        }
        try {
            Throwable throwable = null;
            Object var2_4 = null;
            try (InputStream inputStream = VueHandler.class.getClassLoader().getResourceAsStream("web-resources/js/" + string);){
                logger.debug("Found file " + string);
                return ByteStreams.toByteArray((InputStream)inputStream);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (Exception exception) {
            logger.error(exception.getMessage(), (Throwable)exception);
            return new byte[0];
        }
    }
}

