/*
 * Decompiled with CFR 0.152.
 */
package net.bluemind.webmodules.webapp.webfilters.legacy;

import io.vertx.core.Vertx;
import io.vertx.core.http.HttpServerRequest;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import net.bluemind.core.rest.http.HttpClientProvider;
import net.bluemind.core.rest.http.ILocator;
import net.bluemind.network.topology.Topology;
import net.bluemind.server.api.Server;
import net.bluemind.webmodule.server.IWebFilter;
import net.bluemind.webmodule.server.NeedVertx;
import net.bluemind.webmodules.webapp.webfilters.legacy.FilterOnPref;
import net.bluemind.webmodules.webapp.webfilters.legacy.FilterOnRole;
import net.bluemind.webmodules.webapp.webfilters.legacy.LegacyAppRedirectionLoader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LegacyAppRedirectFilter
implements IWebFilter,
NeedVertx {
    private static final Map<String, String> redirect = new LegacyAppRedirectionLoader().load();
    private HttpClientProvider clientProvider;
    private static final Logger logger = LoggerFactory.getLogger(LegacyAppRedirectFilter.class);
    private static final ILocator locator = (string, asyncHandler) -> {
        String string2 = ((Server)Topology.get().core().value).address();
        String[] stringArray = new String[]{string2};
        asyncHandler.success((Object)stringArray);
    };

    public void setVertx(Vertx vertx) {
        this.clientProvider = new HttpClientProvider(vertx);
    }

    public CompletableFuture<HttpServerRequest> filter(HttpServerRequest httpServerRequest) {
        CompletableFuture<HttpServerRequest> completableFuture = new CompletableFuture<HttpServerRequest>();
        if (this.match(httpServerRequest)) {
            String string = redirect.get(httpServerRequest.path());
            logger.info("Redirect for {} is {} ", (Object)httpServerRequest.path(), (Object)string);
            new FilterOnRole(string, httpServerRequest).setNext(new FilterOnPref(string, locator, this.clientProvider)).handle(httpServerRequest, completableFuture);
        } else {
            completableFuture.complete(httpServerRequest);
        }
        return completableFuture;
    }

    protected boolean match(HttpServerRequest httpServerRequest) {
        return redirect.containsKey(httpServerRequest.path());
    }
}

