/*
 * Decompiled with CFR 0.152.
 */
package net.bluemind.webmodules.webapp.webfilters;

import io.vertx.core.Vertx;
import io.vertx.core.http.HttpServerRequest;
import java.io.File;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.concurrent.CompletableFuture;
import net.bluemind.core.api.AsyncHandler;
import net.bluemind.core.rest.http.HttpClientProvider;
import net.bluemind.core.rest.http.ILocator;
import net.bluemind.core.rest.http.VertxServiceProvider;
import net.bluemind.network.topology.Topology;
import net.bluemind.server.api.Server;
import net.bluemind.user.api.IUserSettingsAsync;
import net.bluemind.webmodule.server.IWebFilter;
import net.bluemind.webmodule.server.NeedVertx;
import net.bluemind.webmodule.server.handlers.TemporaryRedirectHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TryMailAppFilter
implements IWebFilter,
NeedVertx {
    private static final Logger logger = LoggerFactory.getLogger(TryMailAppFilter.class);
    public static final String ROLE_MAIL_WEBAPP = "hasMailWebapp";
    public static final String ROLE_WEBMAIL = "hasWebmail";
    private HttpClientProvider clientProvider;
    private static final ILocator locator = (string, asyncHandler) -> {
        String string2 = ((Server)Topology.get().core().value).address();
        String[] stringArray = new String[]{string2};
        asyncHandler.success((Object)stringArray);
    };

    public CompletableFuture<HttpServerRequest> filter(final HttpServerRequest httpServerRequest) {
        final CompletableFuture<HttpServerRequest> completableFuture = new CompletableFuture<HttpServerRequest>();
        if (this.matchFilter(httpServerRequest)) {
            HashSet<String> hashSet;
            HashSet<String> hashSet2 = hashSet = httpServerRequest.headers().get("BMRoles") != null ? new HashSet<String>(Arrays.asList(httpServerRequest.headers().get("BMRoles").split(","))) : Collections.emptySet();
            if (!hashSet.contains(ROLE_WEBMAIL)) {
                completableFuture.complete(httpServerRequest);
            } else if (!hashSet.contains(ROLE_MAIL_WEBAPP)) {
                this.redirectToWebmail(httpServerRequest);
                completableFuture.complete(null);
            } else {
                String string = httpServerRequest.headers().get("BMUserId");
                String string2 = httpServerRequest.headers().get("BMUserDomainId");
                String string3 = httpServerRequest.headers().get("BMSessionId");
                VertxServiceProvider vertxServiceProvider = new VertxServiceProvider(this.clientProvider, locator, string3).from(httpServerRequest);
                ((IUserSettingsAsync)vertxServiceProvider.instance("bm/core", IUserSettingsAsync.class, new String[]{string2})).getOne(string, "mail-application", (AsyncHandler)new AsyncHandler<String>(){

                    public void success(String string) {
                        if (!string.equals("mail-webapp")) {
                            TryMailAppFilter.this.redirectToWebmail(httpServerRequest);
                            completableFuture.complete(null);
                        } else {
                            completableFuture.complete(httpServerRequest);
                        }
                    }

                    public void failure(Throwable throwable) {
                        completableFuture.complete(httpServerRequest);
                    }
                });
            }
        } else {
            completableFuture.complete(httpServerRequest);
        }
        return completableFuture;
    }

    private boolean matchFilter(HttpServerRequest httpServerRequest) {
        return !new File("/etc/bm/bm-php.disabled").exists() && (httpServerRequest.path().equals("/webapp/index.html") || httpServerRequest.path().startsWith("/webapp/mail"));
    }

    public void setVertx(Vertx vertx) {
        this.clientProvider = new HttpClientProvider(vertx);
    }

    private void redirectToWebmail(HttpServerRequest httpServerRequest) {
        String string = httpServerRequest.headers().get("BMUserId");
        String string2 = httpServerRequest.headers().get("BMUserDomainId");
        logger.info("Redirecting /webapp/index.html to /webmail/ for user {} on domain {}", (Object)string, (Object)string2);
        new TemporaryRedirectHandler("/webmail/").handle(httpServerRequest);
    }
}

