/*
 * Decompiled with CFR 0.152.
 */
package net.bluemind.webmodules.webapp.handlers;

import com.github.benmanes.caffeine.cache.Cache;
import com.github.benmanes.caffeine.cache.Caffeine;
import io.vertx.core.Handler;
import io.vertx.core.Vertx;
import io.vertx.core.http.HttpServerRequest;
import io.vertx.core.http.HttpServerResponse;
import io.vertx.core.streams.ReadStream;
import io.vertx.core.streams.WriteStream;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import net.bluemind.backend.mail.api.IMailboxItemsPromise;
import net.bluemind.core.api.Stream;
import net.bluemind.core.rest.http.HttpClientProvider;
import net.bluemind.core.rest.http.ILocator;
import net.bluemind.core.rest.http.VertxPromiseServiceProvider;
import net.bluemind.core.rest.vertx.VertxStream;
import net.bluemind.network.topology.Topology;
import net.bluemind.server.api.Server;
import net.bluemind.webmodule.server.NeedVertx;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PartContentUrlHandler
implements Handler<HttpServerRequest>,
NeedVertx {
    private static Cache<String, Semaphore> lockBySession = Caffeine.newBuilder().expireAfterAccess(20L, TimeUnit.MINUTES).build();
    private static final Logger logger = LoggerFactory.getLogger(PartContentUrlHandler.class);
    private HttpClientProvider prov;
    private Vertx vertx;
    private static final ILocator locator = (string, asyncHandler) -> {
        String string2 = ((Server)Topology.get().core().value).address();
        String[] stringArray = new String[]{string2};
        asyncHandler.success((Object)stringArray);
    };

    public void setVertx(Vertx vertx) {
        this.vertx = vertx;
        this.prov = new HttpClientProvider(vertx);
    }

    public void handle(HttpServerRequest httpServerRequest) {
        String string = httpServerRequest.headers().get("BMSessionId");
        httpServerRequest.pause();
        this.withSessionLock(string, httpServerRequest, this::fetchFromCore);
    }

    private void withSessionLock(String string2, HttpServerRequest httpServerRequest, SerializedOperation serializedOperation) {
        Semaphore semaphore = (Semaphore)lockBySession.get((Object)string2, string -> new Semaphore(1, true));
        try {
            boolean bl = semaphore.tryAcquire(25L, TimeUnit.MILLISECONDS);
            if (!bl) {
                this.vertx.setTimer(5L, l -> this.withSessionLock(string2, httpServerRequest, serializedOperation));
            } else {
                httpServerRequest.resume();
                serializedOperation.runWithLock(httpServerRequest, string2).whenComplete((void_, throwable) -> {
                    semaphore.release();
                    if (throwable != null) {
                        logger.error("[{}] {}", new Object[]{string2, throwable.getMessage(), throwable});
                        HttpServerResponse httpServerResponse = httpServerRequest.response();
                        if (!httpServerResponse.headWritten()) {
                            httpServerRequest.response().setStatusCode(500).setStatusMessage(throwable.getMessage());
                        }
                        if (!httpServerResponse.ended()) {
                            httpServerResponse.end();
                        }
                    }
                });
            }
        }
        catch (InterruptedException interruptedException) {
            Thread.currentThread().interrupt();
        }
    }

    private CompletableFuture<Void> fetchFromCore(HttpServerRequest httpServerRequest, String string) {
        VertxPromiseServiceProvider vertxPromiseServiceProvider = new VertxPromiseServiceProvider(this.prov, locator, string);
        String string2 = httpServerRequest.params().get("folderUid");
        IMailboxItemsPromise iMailboxItemsPromise = (IMailboxItemsPromise)vertxPromiseServiceProvider.instance(IMailboxItemsPromise.class, new String[]{string2});
        String string3 = httpServerRequest.params().get("imapUid");
        String string4 = httpServerRequest.params().get("address");
        String string5 = httpServerRequest.params().get("encoding");
        String string6 = httpServerRequest.params().get("mime");
        String string7 = httpServerRequest.params().get("charset");
        String string8 = httpServerRequest.params().get("filename");
        return iMailboxItemsPromise.fetch(Long.parseLong(string3), string4, string5, string6, string7, string8).thenCompose(stream -> {
            HttpServerResponse httpServerResponse = httpServerRequest.response();
            httpServerResponse.setChunked(true);
            httpServerResponse.headers().set("Content-Type", String.valueOf(string6) + ";charset=" + string7);
            httpServerResponse.headers().set("Content-Disposition", "inline; filename=\"" + string8 + "\"");
            httpServerResponse.headers().set("Cache-Control", "max-age=15768000, private");
            ReadStream readStream = VertxStream.read((Stream)stream);
            return readStream.pipeTo((WriteStream)httpServerResponse).toCompletionStage();
        });
    }

    @FunctionalInterface
    public static interface SerializedOperation {
        public CompletableFuture<Void> runWithLock(HttpServerRequest var1, String var2);
    }
}

