/*
 * Decompiled with CFR 0.152.
 */
package org.shredzone.acme4j;

import java.net.URL;
import java.security.KeyPair;
import java.util.Objects;
import org.shredzone.acme4j.Account;
import org.shredzone.acme4j.Authorization;
import org.shredzone.acme4j.Certificate;
import org.shredzone.acme4j.Order;
import org.shredzone.acme4j.Session;
import org.shredzone.acme4j.challenge.Challenge;
import org.shredzone.acme4j.connector.Connection;
import org.shredzone.acme4j.exception.AcmeException;
import org.shredzone.acme4j.exception.AcmeLazyLoadingException;
import org.shredzone.acme4j.exception.AcmeProtocolException;
import org.shredzone.acme4j.toolbox.JSON;

public class Login {
    private final Session session;
    private final URL accountLocation;
    private final Account account;
    private KeyPair keyPair;

    public Login(URL accountLocation, KeyPair keyPair, Session session) {
        this.accountLocation = Objects.requireNonNull(accountLocation, "accountLocation");
        this.keyPair = Objects.requireNonNull(keyPair, "keyPair");
        this.session = Objects.requireNonNull(session, "session");
        this.account = new Account(this);
    }

    public Session getSession() {
        return this.session;
    }

    public KeyPair getKeyPair() {
        return this.keyPair;
    }

    public URL getAccountLocation() {
        return this.accountLocation;
    }

    public Account getAccount() {
        return this.account;
    }

    public Authorization bindAuthorization(URL location) {
        return new Authorization(this, Objects.requireNonNull(location, "location"));
    }

    public Certificate bindCertificate(URL location) {
        return new Certificate(this, Objects.requireNonNull(location, "location"));
    }

    public Order bindOrder(URL location) {
        return new Order(this, Objects.requireNonNull(location, "location"));
    }

    public Challenge bindChallenge(URL location) {
        try {
            Connection connect = this.session.connect();
            connect.sendSignedPostAsGetRequest(location, this);
            return this.createChallenge(connect.readJsonResponse());
        }
        catch (AcmeException ex) {
            throw new AcmeLazyLoadingException(Challenge.class, location, ex);
        }
    }

    public <C extends Challenge> C bindChallenge(URL location, Class<C> type) {
        Challenge challenge = this.bindChallenge(location);
        if (!type.isInstance(challenge)) {
            throw new AcmeProtocolException("Challenge type " + challenge.getType() + " does not match requested class " + type);
        }
        return (C)((Challenge)type.cast(challenge));
    }

    public Challenge createChallenge(JSON data) {
        Challenge challenge = this.session.provider().createChallenge(this, data);
        if (challenge == null) {
            throw new AcmeProtocolException("Could not create challenge for: " + data);
        }
        return challenge;
    }

    protected void setKeyPair(KeyPair keyPair) {
        this.keyPair = Objects.requireNonNull(keyPair, "keyPair");
    }
}

