/*
 * Decompiled with CFR 0.152.
 */
package net.bluemind.ui.settings.client;

import com.google.gwt.core.client.GWT;
import com.google.gwt.core.client.JavaScriptObject;
import com.google.gwt.core.client.JsArrayString;
import com.google.gwt.dom.client.Element;
import com.google.gwt.dom.client.Node;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.event.logical.shared.ValueChangeEvent;
import com.google.gwt.event.logical.shared.ValueChangeHandler;
import com.google.gwt.i18n.client.Constants;
import com.google.gwt.uibinder.client.UiBinder;
import com.google.gwt.uibinder.client.UiField;
import com.google.gwt.user.client.DOM;
import com.google.gwt.user.client.Event;
import com.google.gwt.user.client.EventListener;
import com.google.gwt.user.client.History;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.DockLayoutPanel;
import com.google.gwt.user.client.ui.FlexTable;
import com.google.gwt.user.client.ui.FlowPanel;
import com.google.gwt.user.client.ui.Label;
import com.google.gwt.user.client.ui.SimplePanel;
import com.google.gwt.user.client.ui.Widget;
import java.util.HashMap;
import java.util.Map;
import net.bluemind.core.api.AsyncHandler;
import net.bluemind.gwtconsoleapp.base.editor.ScreenRoot;
import net.bluemind.gwtconsoleapp.base.editor.gwt.GwtScreenRoot;
import net.bluemind.gwtconsoleapp.base.editor.gwt.IGwtCompositeScreenRoot;
import net.bluemind.gwtconsoleapp.base.editor.gwt.IGwtDelegateFactory;
import net.bluemind.gwtconsoleapp.base.menus.Menus;
import net.bluemind.gwtconsoleapp.base.menus.Section;
import net.bluemind.gwtconsoleapp.base.notification.Notification;
import net.bluemind.ui.settings.client.AppAnchor;
import net.bluemind.ui.settings.client.RootScreen;
import net.bluemind.ui.settings.client.forms.SettingsActionBar;

public class SettingsScreen
extends Composite
implements IGwtCompositeScreenRoot {
    private static RootScreenUiBinder uiBinder = (RootScreenUiBinder)GWT.create(RootScreenUiBinder.class);
    private final Map<String, AppAnchor> sectionAnchors = new HashMap<String, AppAnchor>();
    @UiField
    FlexTable sidebar;
    @UiField
    SimplePanel south;
    @UiField
    FlowPanel apps;
    private SettingsActionBar acitonBar = new SettingsActionBar();
    private ScreenRoot instance;
    private JavaScriptObject model;
    private SettingsConstants constants;

    public SettingsScreen(ScreenRoot screenRoot) {
        this.instance = screenRoot;
        this.constants = (SettingsConstants)GWT.create(SettingsConstants.class);
        this.initWidget((Widget)uiBinder.createAndBindUi((Object)this));
        this.sidebar.setStyleName("sidebar");
        this.sidebar.setWidget(0, 0, (Widget)new Label());
        this.sidebar.getRowFormatter().setStyleName(0, "fakeapp");
        this.initSections();
        this.south.add((Widget)this.acitonBar);
        this.south.setStyleName("actionBar");
        this.acitonBar.getSaveBtn().addClickHandler(new ClickHandler(){

            public void onClick(ClickEvent clickEvent) {
                SettingsScreen.this.save();
            }
        });
        History.addValueChangeHandler((ValueChangeHandler)new ValueChangeHandler<String>(){

            public void onValueChange(ValueChangeEvent<String> valueChangeEvent) {
                SettingsScreen.this.locationUpdated();
            }
        });
    }

    private void initSections() {
        Menus menus = new Menus("net.bluemind.ui.settings.menusContributor");
        for (Section section : menus.getRootAsList()) {
            this.registerSection(section);
        }
    }

    private void registerSection(final Section section) {
        if (!Menus.isInRoles((JsArrayString)section.getRoles())) {
            GWT.log((String)("not in roles " + section.getRoles()));
            return;
        }
        int n = this.sidebar.getRowCount();
        AppAnchor appAnchor = new AppAnchor(section.getName(), section.getId());
        this.sidebar.setWidget(n, 0, (Widget)appAnchor);
        this.sidebar.getRowFormatter().addStyleName(n, "app");
        this.sectionAnchors.put(section.getId(), appAnchor);
        appAnchor.addClickHandler(new ClickHandler(){

            public void onClick(ClickEvent clickEvent) {
                SettingsScreen.this.updateLocation(section.getId());
            }
        });
    }

    private void showApp(String string) {
        GWT.log((String)("show app " + string));
        for (String string2 : this.sectionAnchors.keySet()) {
            boolean bl = string2.equals(string);
            this.sectionAnchors.get(string2).setSelected(bl);
        }
        RootScreen.show(this.instance.getContent(), string);
    }

    protected void save() {
        this.instance.save((AsyncHandler)new AsyncHandler<Void>(){

            public void success(Void void_) {
                Notification.get().reportInfo(SettingsScreen.this.constants.settingsUpdated());
                SettingsScreen.this.load();
            }

            public void failure(Throwable throwable) {
                Notification.get().reportError(throwable);
            }
        });
    }

    public void load() {
        this.instance.load((AsyncHandler)new AsyncHandler<Void>(){

            public void success(Void void_) {
                SettingsScreen.this.instance.loadModel(SettingsScreen.this.instance.getModel());
                SettingsScreen.this.locationUpdated();
            }

            public void failure(Throwable throwable) {
                Notification.get().reportError(throwable);
            }
        });
    }

    public Element getCenter() {
        return this.apps.getElement();
    }

    public void attach(Element element) {
        element.appendChild((Node)this.getElement());
        this.onAttach();
        Event.setEventListener((Element)this.getElement(), (EventListener)new EventListener(){

            public void onBrowserEvent(Event event) {
                SettingsScreen.this.instance.saveModel(SettingsScreen.this.instance.getModel());
                SettingsScreen.this.instance.loadModel(SettingsScreen.this.instance.getModel());
            }
        });
        DOM.sinkBitlessEvent((Element)this.getElement(), (String)"refresh");
    }

    public void loadModel(JavaScriptObject javaScriptObject) {
    }

    public void saveModel(JavaScriptObject javaScriptObject) {
    }

    public void doLoad(ScreenRoot screenRoot) {
        this.load();
    }

    public static native ScreenRoot create(String var0);

    public static void registerType() {
        GwtScreenRoot.registerComposite((String)"bm.settings.SettingsScreen", (IGwtDelegateFactory)new IGwtDelegateFactory<IGwtCompositeScreenRoot, ScreenRoot>(){

            public IGwtCompositeScreenRoot create(ScreenRoot screenRoot) {
                return new SettingsScreen(screenRoot);
            }
        });
    }

    private void locationUpdated() {
        String string = History.getToken();
        GWT.log((String)("token " + string));
        if (string == null || string.isEmpty()) {
            this.showApp("myAccount");
        } else {
            String string2 = "myAccount";
            for (String string3 : this.sectionAnchors.keySet()) {
                if (!string3.equals(string)) continue;
                string2 = string3;
                break;
            }
            this.showApp(string2);
        }
    }

    private void updateLocation(String string) {
        History.newItem((String)string);
    }

    static interface RootScreenUiBinder
    extends UiBinder<DockLayoutPanel, SettingsScreen> {
    }

    public static interface SettingsConstants
    extends Constants {
        public String settingsUpdated();
    }
}

