/*
 * Decompiled with CFR 0.152.
 */
package net.bluemind.ui.settings.downloads.tbird;

import freemarker.template.Configuration;
import freemarker.template.Template;
import io.vertx.core.Handler;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.http.HttpHeaders;
import io.vertx.core.http.HttpServerRequest;
import io.vertx.core.http.HttpServerResponse;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.HashMap;
import net.bluemind.ui.settings.downloads.tbird.Activator;
import net.bluemind.ui.settings.downloads.tbird.TBirdDownloadHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TBirdUpdateJson
implements Handler<HttpServerRequest> {
    private static final Logger logger = LoggerFactory.getLogger(TBirdUpdateJson.class);
    private Template template;

    public TBirdUpdateJson() throws IOException {
        Configuration configuration = new Configuration();
        configuration.setClassForTemplateLoading(this.getClass(), "/templates");
        configuration.setTagSyntax(0);
        this.template = configuration.getTemplate("updateJson.tpl");
    }

    public void handle(HttpServerRequest httpServerRequest) {
        String string = httpServerRequest.getHeader(HttpHeaders.USER_AGENT);
        String string2 = "https://%s/settings/settings/download/";
        String string3 = Activator.bundle.getVersion().toString();
        if (string.contains("Thunderbird/78")) {
            string2 = String.valueOf(string2) + "tbird-webext.xpi";
            string3 = String.valueOf(string3) + ".1";
        } else {
            string2 = String.valueOf(string2) + "tbird.xpi";
            string3 = String.valueOf(string3) + ".0";
        }
        StringWriter stringWriter = new StringWriter();
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("version", string3);
        hashMap.put("url", String.format(string2, TBirdDownloadHandler.getExternalUrl()));
        try {
            this.template.process(hashMap, (Writer)stringWriter);
        }
        catch (Exception exception) {
            logger.error(exception.getMessage(), (Throwable)exception);
        }
        HttpServerResponse httpServerResponse = httpServerRequest.response();
        String string4 = stringWriter.toString();
        byte[] byArray = string4.getBytes();
        httpServerResponse.setStatusCode(200);
        httpServerResponse.end(Buffer.buffer((byte[])byArray));
    }
}

