/*
 * Decompiled with CFR 0.152.
 */
package org.mapdb.volume;

import java.io.File;
import java.nio.ByteBuffer;
import java.nio.MappedByteBuffer;
import org.mapdb.volume.ByteBufferVol;
import org.mapdb.volume.ByteBufferVolSingle;

public final class ByteBufferMemoryVolSingle
extends ByteBufferVolSingle {
    protected final boolean useDirectBuffer;

    public String toString() {
        return super.toString() + ",direct=" + this.useDirectBuffer;
    }

    public ByteBufferMemoryVolSingle(boolean useDirectBuffer, long maxSize, boolean cleanerHackEnabled) {
        super(false, maxSize, cleanerHackEnabled);
        this.useDirectBuffer = useDirectBuffer;
        this.buffer = useDirectBuffer ? ByteBuffer.allocateDirect((int)maxSize) : ByteBuffer.allocate((int)maxSize);
    }

    @Override
    public void truncate(long size2) {
    }

    @Override
    public synchronized void close() {
        if (!this.closed.compareAndSet(false, true)) {
            return;
        }
        if (this.cleanerHackEnabled && this.buffer instanceof MappedByteBuffer) {
            ByteBufferVol.unmap((MappedByteBuffer)this.buffer);
        }
        this.buffer = null;
    }

    @Override
    public void sync() {
    }

    @Override
    public long length() {
        return this.maxSize;
    }

    @Override
    public boolean isReadOnly() {
        return false;
    }

    @Override
    public File getFile() {
        return null;
    }

    @Override
    public boolean getFileLocked() {
        return false;
    }
}

