/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.collections.impl.set.immutable.primitive;

import org.eclipse.collections.api.ByteIterable;
import org.eclipse.collections.api.RichIterable;
import org.eclipse.collections.api.factory.Lists;
import org.eclipse.collections.api.factory.primitive.ByteSets;
import org.eclipse.collections.api.iterator.ByteIterator;
import org.eclipse.collections.api.list.MutableList;
import org.eclipse.collections.api.set.primitive.ByteSet;
import org.eclipse.collections.api.set.primitive.ImmutableByteSet;
import org.eclipse.collections.api.set.primitive.MutableByteSet;
import org.eclipse.collections.impl.set.mutable.primitive.ByteHashSet;
import org.eclipse.collections.impl.set.primitive.AbstractByteSet;

public abstract class AbstractImmutableByteSet
extends AbstractByteSet
implements ImmutableByteSet {
    @Override
    public ImmutableByteSet newWith(byte element) {
        return ByteHashSet.newSet(this).with(element).toImmutable();
    }

    @Override
    public ImmutableByteSet newWithout(byte element) {
        return ByteHashSet.newSet(this).without(element).toImmutable();
    }

    @Override
    public ImmutableByteSet newWithAll(ByteIterable elements) {
        return ByteHashSet.newSet(this).withAll(elements).toImmutable();
    }

    @Override
    public ImmutableByteSet newWithoutAll(ByteIterable elements) {
        return ByteHashSet.newSet(this).withoutAll(elements).toImmutable();
    }

    @Override
    public ByteSet freeze() {
        return this;
    }

    @Override
    public ImmutableByteSet toImmutable() {
        return this;
    }

    @Override
    public RichIterable<ByteIterable> chunk(int size2) {
        if (size2 <= 0) {
            throw new IllegalArgumentException("Size for groups must be positive but was: " + size2);
        }
        MutableList result = Lists.mutable.empty();
        if (this.notEmpty()) {
            if (this.size() <= size2) {
                result.add(this);
            } else {
                ByteIterator iterator2 = this.byteIterator();
                while (iterator2.hasNext()) {
                    MutableByteSet batch = ByteSets.mutable.empty();
                    for (int i = 0; i < size2 && iterator2.hasNext(); ++i) {
                        batch.add(iterator2.next());
                    }
                    result.add(batch.toImmutable());
                }
            }
        }
        return result.toImmutable();
    }
}

