/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.collections.impl.map.mutable.primitive;

import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.Optional;
import org.eclipse.collections.api.LazyIterable;
import org.eclipse.collections.api.LazyLongIterable;
import org.eclipse.collections.api.LongIterable;
import org.eclipse.collections.api.RichIterable;
import org.eclipse.collections.api.bag.MutableBag;
import org.eclipse.collections.api.bag.primitive.MutableBooleanBag;
import org.eclipse.collections.api.bag.primitive.MutableByteBag;
import org.eclipse.collections.api.bag.primitive.MutableCharBag;
import org.eclipse.collections.api.bag.primitive.MutableDoubleBag;
import org.eclipse.collections.api.bag.primitive.MutableFloatBag;
import org.eclipse.collections.api.bag.primitive.MutableIntBag;
import org.eclipse.collections.api.bag.primitive.MutableLongBag;
import org.eclipse.collections.api.bag.primitive.MutableShortBag;
import org.eclipse.collections.api.bag.sorted.MutableSortedBag;
import org.eclipse.collections.api.bimap.MutableBiMap;
import org.eclipse.collections.api.block.function.Function;
import org.eclipse.collections.api.block.function.Function0;
import org.eclipse.collections.api.block.function.Function2;
import org.eclipse.collections.api.block.function.primitive.BooleanFunction;
import org.eclipse.collections.api.block.function.primitive.ByteFunction;
import org.eclipse.collections.api.block.function.primitive.CharFunction;
import org.eclipse.collections.api.block.function.primitive.DoubleFunction;
import org.eclipse.collections.api.block.function.primitive.DoubleObjectToDoubleFunction;
import org.eclipse.collections.api.block.function.primitive.FloatFunction;
import org.eclipse.collections.api.block.function.primitive.FloatObjectToFloatFunction;
import org.eclipse.collections.api.block.function.primitive.IntFunction;
import org.eclipse.collections.api.block.function.primitive.IntObjectToIntFunction;
import org.eclipse.collections.api.block.function.primitive.LongFunction;
import org.eclipse.collections.api.block.function.primitive.LongObjectToLongFunction;
import org.eclipse.collections.api.block.function.primitive.LongToObjectFunction;
import org.eclipse.collections.api.block.function.primitive.ShortFunction;
import org.eclipse.collections.api.block.predicate.Predicate;
import org.eclipse.collections.api.block.predicate.Predicate2;
import org.eclipse.collections.api.block.predicate.primitive.LongObjectPredicate;
import org.eclipse.collections.api.block.procedure.Procedure;
import org.eclipse.collections.api.block.procedure.Procedure2;
import org.eclipse.collections.api.block.procedure.primitive.LongObjectProcedure;
import org.eclipse.collections.api.block.procedure.primitive.LongProcedure;
import org.eclipse.collections.api.block.procedure.primitive.ObjectIntProcedure;
import org.eclipse.collections.api.collection.primitive.MutableBooleanCollection;
import org.eclipse.collections.api.collection.primitive.MutableByteCollection;
import org.eclipse.collections.api.collection.primitive.MutableCharCollection;
import org.eclipse.collections.api.collection.primitive.MutableDoubleCollection;
import org.eclipse.collections.api.collection.primitive.MutableFloatCollection;
import org.eclipse.collections.api.collection.primitive.MutableIntCollection;
import org.eclipse.collections.api.collection.primitive.MutableLongCollection;
import org.eclipse.collections.api.collection.primitive.MutableShortCollection;
import org.eclipse.collections.api.list.MutableList;
import org.eclipse.collections.api.map.MutableMap;
import org.eclipse.collections.api.map.MutableMapIterable;
import org.eclipse.collections.api.map.primitive.ImmutableLongObjectMap;
import org.eclipse.collections.api.map.primitive.LongObjectMap;
import org.eclipse.collections.api.map.primitive.MutableLongObjectMap;
import org.eclipse.collections.api.map.primitive.MutableObjectDoubleMap;
import org.eclipse.collections.api.map.primitive.MutableObjectLongMap;
import org.eclipse.collections.api.map.sorted.MutableSortedMap;
import org.eclipse.collections.api.multimap.MutableMultimap;
import org.eclipse.collections.api.multimap.bag.MutableBagMultimap;
import org.eclipse.collections.api.partition.bag.PartitionMutableBag;
import org.eclipse.collections.api.set.MutableSet;
import org.eclipse.collections.api.set.primitive.MutableLongSet;
import org.eclipse.collections.api.set.sorted.MutableSortedSet;
import org.eclipse.collections.api.tuple.Pair;
import org.eclipse.collections.api.tuple.primitive.LongObjectPair;
import org.eclipse.collections.impl.UnmodifiableIteratorAdapter;
import org.eclipse.collections.impl.factory.primitive.LongObjectMaps;
import org.eclipse.collections.impl.map.mutable.primitive.SynchronizedLongObjectMap;
import org.eclipse.collections.impl.set.mutable.primitive.UnmodifiableLongSet;

public class UnmodifiableLongObjectMap<V>
implements MutableLongObjectMap<V>,
Serializable {
    private static final long serialVersionUID = 1L;
    private final MutableLongObjectMap<V> map;

    public UnmodifiableLongObjectMap(MutableLongObjectMap<V> map2) {
        if (map2 == null) {
            throw new IllegalArgumentException("Cannot create a UnmodifiableLongObjectMap on a null map");
        }
        this.map = map2;
    }

    private boolean isAbsent(V result, long key) {
        return result == null && !this.containsKey(key);
    }

    private V getIfAbsentThrow(long key) {
        Object result = this.map.get(key);
        if (this.isAbsent(result, key)) {
            throw new UnsupportedOperationException("Cannot add to an " + this.getClass().getSimpleName());
        }
        return result;
    }

    @Override
    public V put(long key, V value) {
        throw new UnsupportedOperationException("Cannot call put() on " + this.getClass().getSimpleName());
    }

    @Override
    public V putPair(LongObjectPair<V> keyValuePair) {
        throw new UnsupportedOperationException("Cannot call putPair() on " + this.getClass().getSimpleName());
    }

    @Override
    public void putAll(LongObjectMap<? extends V> map2) {
        throw new UnsupportedOperationException("Cannot call putAll() on " + this.getClass().getSimpleName());
    }

    @Override
    public V removeKey(long key) {
        throw new UnsupportedOperationException("Cannot call removeKey() on " + this.getClass().getSimpleName());
    }

    @Override
    public V remove(long key) {
        throw new UnsupportedOperationException("Cannot call remove() on " + this.getClass().getSimpleName());
    }

    @Override
    public V getIfAbsentPut(long key, Function0<? extends V> function) {
        return this.getIfAbsentThrow(key);
    }

    @Override
    public V getIfAbsentPut(long key, V value) {
        return this.getIfAbsentThrow(key);
    }

    @Override
    public V getIfAbsentPutWithKey(long key, LongToObjectFunction<? extends V> function) {
        return this.getIfAbsentThrow(key);
    }

    @Override
    public <P> V getIfAbsentPutWith(long key, Function<? super P, ? extends V> function, P parameter) {
        return this.getIfAbsentThrow(key);
    }

    @Override
    public V updateValue(long key, Function0<? extends V> factory, Function<? super V, ? extends V> function) {
        throw new UnsupportedOperationException("Cannot call updateValue() on " + this.getClass().getSimpleName());
    }

    @Override
    public <P> V updateValueWith(long key, Function0<? extends V> factory, Function2<? super V, ? super P, ? extends V> function, P parameter) {
        throw new UnsupportedOperationException("Cannot call updateValueWith() on " + this.getClass().getSimpleName());
    }

    @Override
    public V get(long key) {
        return this.map.get(key);
    }

    @Override
    public V getIfAbsent(long key, Function0<? extends V> ifAbsent) {
        return this.map.getIfAbsent(key, ifAbsent);
    }

    @Override
    public boolean containsKey(long key) {
        return this.map.containsKey(key);
    }

    @Override
    public boolean containsValue(Object value) {
        return this.map.containsValue(value);
    }

    @Override
    public MutableLongObjectMap<V> tap(Procedure<? super V> procedure) {
        this.map.forEach(procedure);
        return this;
    }

    @Override
    public void forEachValue(Procedure<? super V> procedure) {
        this.map.forEachValue(procedure);
    }

    @Override
    public void forEachKey(LongProcedure procedure) {
        this.map.forEachKey(procedure);
    }

    @Override
    public void forEachKeyValue(LongObjectProcedure<? super V> procedure) {
        this.map.forEachKeyValue(procedure);
    }

    @Override
    public MutableLongObjectMap<V> select(LongObjectPredicate<? super V> predicate) {
        return this.map.select(predicate);
    }

    @Override
    public MutableLongObjectMap<V> reject(LongObjectPredicate<? super V> predicate) {
        return this.map.reject(predicate);
    }

    @Override
    public int size() {
        return this.map.size();
    }

    @Override
    public boolean isEmpty() {
        return this.map.isEmpty();
    }

    @Override
    public boolean notEmpty() {
        return this.map.notEmpty();
    }

    @Override
    public V getFirst() {
        return (V)this.map.getFirst();
    }

    @Override
    public V getLast() {
        return (V)this.map.getLast();
    }

    @Override
    public V getOnly() {
        return (V)this.map.getOnly();
    }

    @Override
    public boolean contains(Object object) {
        return this.map.contains(object);
    }

    @Override
    public boolean containsAllIterable(Iterable<?> source) {
        return this.map.containsAllIterable(source);
    }

    @Override
    public boolean containsAll(Collection<?> source) {
        return this.map.containsAll(source);
    }

    @Override
    public boolean containsAllArguments(Object ... elements) {
        return this.map.containsAllArguments(elements);
    }

    @Override
    public MutableBag<V> select(Predicate<? super V> predicate) {
        return this.map.select((Predicate)predicate);
    }

    @Override
    public <R extends Collection<V>> R select(Predicate<? super V> predicate, R target) {
        return this.map.select(predicate, target);
    }

    @Override
    public <P> MutableBag<V> selectWith(Predicate2<? super V, ? super P> predicate, P parameter) {
        return this.map.selectWith(predicate, (Object)parameter);
    }

    @Override
    public <P, R extends Collection<V>> R selectWith(Predicate2<? super V, ? super P> predicate, P parameter, R targetCollection) {
        return this.map.selectWith(predicate, parameter, targetCollection);
    }

    @Override
    public PartitionMutableBag<V> partition(Predicate<? super V> predicate) {
        return this.map.partition((Predicate)predicate);
    }

    @Override
    public <P> PartitionMutableBag<V> partitionWith(Predicate2<? super V, ? super P> predicate, P parameter) {
        return this.map.partitionWith(predicate, (Object)parameter);
    }

    @Override
    public <S> MutableBag<S> selectInstancesOf(Class<S> clazz) {
        return this.map.selectInstancesOf((Class)clazz);
    }

    @Override
    @Deprecated
    public MutableSet<Pair<V, Integer>> zipWithIndex() {
        return this.map.zipWithIndex();
    }

    @Override
    public <R extends Collection<Pair<V, Integer>>> R zipWithIndex(R target) {
        return this.map.zipWithIndex(target);
    }

    @Override
    public RichIterable<RichIterable<V>> chunk(int size2) {
        return this.map.chunk(size2);
    }

    @Override
    public <K, VV> MutableMap<K, VV> aggregateInPlaceBy(Function<? super V, ? extends K> groupBy, Function0<? extends VV> zeroValueFactory, Procedure2<? super VV, ? super V> mutatingAggregator) {
        return this.map.aggregateInPlaceBy(groupBy, zeroValueFactory, mutatingAggregator);
    }

    @Override
    public <K, VV> MutableMap<K, VV> aggregateBy(Function<? super V, ? extends K> groupBy, Function0<? extends VV> zeroValueFactory, Function2<? super VV, ? super V, ? extends VV> nonMutatingAggregator) {
        return this.map.aggregateBy(groupBy, zeroValueFactory, nonMutatingAggregator);
    }

    @Override
    public MutableBag<V> reject(Predicate<? super V> predicate) {
        return this.map.reject((Predicate)predicate);
    }

    @Override
    public <R extends Collection<V>> R reject(Predicate<? super V> predicate, R target) {
        return this.map.reject(predicate, target);
    }

    @Override
    public <P> MutableBag<V> rejectWith(Predicate2<? super V, ? super P> predicate, P parameter) {
        return this.map.rejectWith(predicate, (Object)parameter);
    }

    @Override
    public <P, R extends Collection<V>> R rejectWith(Predicate2<? super V, ? super P> predicate, P parameter, R targetCollection) {
        return this.map.rejectWith(predicate, parameter, targetCollection);
    }

    @Override
    public void clear() {
        throw new UnsupportedOperationException("Cannot call clear() on " + this.getClass().getSimpleName());
    }

    @Override
    public <VV> MutableBag<VV> collect(Function<? super V, ? extends VV> function) {
        return this.map.collect((Function)function);
    }

    @Override
    public MutableBooleanBag collectBoolean(BooleanFunction<? super V> booleanFunction) {
        return this.map.collectBoolean((BooleanFunction)booleanFunction);
    }

    @Override
    public <R extends MutableBooleanCollection> R collectBoolean(BooleanFunction<? super V> booleanFunction, R target) {
        return this.map.collectBoolean(booleanFunction, target);
    }

    @Override
    public MutableByteBag collectByte(ByteFunction<? super V> byteFunction) {
        return this.map.collectByte((ByteFunction)byteFunction);
    }

    @Override
    public <R extends MutableByteCollection> R collectByte(ByteFunction<? super V> byteFunction, R target) {
        return this.map.collectByte(byteFunction, target);
    }

    @Override
    public MutableCharBag collectChar(CharFunction<? super V> charFunction) {
        return this.map.collectChar((CharFunction)charFunction);
    }

    @Override
    public <R extends MutableCharCollection> R collectChar(CharFunction<? super V> charFunction, R target) {
        return this.map.collectChar(charFunction, target);
    }

    @Override
    public MutableDoubleBag collectDouble(DoubleFunction<? super V> doubleFunction) {
        return this.map.collectDouble((DoubleFunction)doubleFunction);
    }

    @Override
    public <R extends MutableDoubleCollection> R collectDouble(DoubleFunction<? super V> doubleFunction, R target) {
        return this.map.collectDouble(doubleFunction, target);
    }

    @Override
    public MutableFloatBag collectFloat(FloatFunction<? super V> floatFunction) {
        return this.map.collectFloat((FloatFunction)floatFunction);
    }

    @Override
    public <R extends MutableFloatCollection> R collectFloat(FloatFunction<? super V> floatFunction, R target) {
        return this.map.collectFloat(floatFunction, target);
    }

    @Override
    public MutableIntBag collectInt(IntFunction<? super V> intFunction) {
        return this.map.collectInt((IntFunction)intFunction);
    }

    @Override
    public <R extends MutableIntCollection> R collectInt(IntFunction<? super V> intFunction, R target) {
        return this.map.collectInt(intFunction, target);
    }

    @Override
    public MutableLongBag collectLong(LongFunction<? super V> longFunction) {
        return this.map.collectLong((LongFunction)longFunction);
    }

    @Override
    public <R extends MutableLongCollection> R collectLong(LongFunction<? super V> longFunction, R target) {
        return this.map.collectLong(longFunction, target);
    }

    @Override
    public MutableShortBag collectShort(ShortFunction<? super V> shortFunction) {
        return this.map.collectShort((ShortFunction)shortFunction);
    }

    @Override
    public <R extends MutableShortCollection> R collectShort(ShortFunction<? super V> shortFunction, R target) {
        return this.map.collectShort(shortFunction, target);
    }

    @Override
    public <P, VV> MutableBag<VV> collectWith(Function2<? super V, ? super P, ? extends VV> function, P parameter) {
        return this.map.collectWith(function, (Object)parameter);
    }

    @Override
    public <P, VV, R extends Collection<VV>> R collectWith(Function2<? super V, ? super P, ? extends VV> function, P parameter, R targetCollection) {
        return this.map.collectWith(function, parameter, targetCollection);
    }

    @Override
    public <VV, R extends Collection<VV>> R collect(Function<? super V, ? extends VV> function, R target) {
        return this.map.collect(function, target);
    }

    @Override
    public <VV> MutableBag<VV> collectIf(Predicate<? super V> predicate, Function<? super V, ? extends VV> function) {
        return this.map.collectIf((Predicate)predicate, (Function)function);
    }

    @Override
    public <VV, R extends Collection<VV>> R collectIf(Predicate<? super V> predicate, Function<? super V, ? extends VV> function, R target) {
        return this.map.collectIf(predicate, function, target);
    }

    @Override
    public <VV> MutableBag<VV> flatCollect(Function<? super V, ? extends Iterable<VV>> function) {
        return this.map.flatCollect(function);
    }

    @Override
    public <VV, R extends Collection<VV>> R flatCollect(Function<? super V, ? extends Iterable<VV>> function, R target) {
        return this.map.flatCollect(function, target);
    }

    @Override
    public V detect(Predicate<? super V> predicate) {
        return this.map.detect(predicate);
    }

    @Override
    public <P> V detectWith(Predicate2<? super V, ? super P> predicate, P parameter) {
        return this.map.detectWith(predicate, parameter);
    }

    @Override
    public Optional<V> detectOptional(Predicate<? super V> predicate) {
        return this.map.detectOptional(predicate);
    }

    @Override
    public <P> Optional<V> detectWithOptional(Predicate2<? super V, ? super P> predicate, P parameter) {
        return this.map.detectWithOptional(predicate, parameter);
    }

    @Override
    public V detectIfNone(Predicate<? super V> predicate, Function0<? extends V> function) {
        return this.map.detectIfNone(predicate, function);
    }

    @Override
    public <P> V detectWithIfNone(Predicate2<? super V, ? super P> predicate, P parameter, Function0<? extends V> function) {
        return this.map.detectWithIfNone(predicate, parameter, function);
    }

    @Override
    public int count(Predicate<? super V> predicate) {
        return this.map.count(predicate);
    }

    @Override
    public <P> int countWith(Predicate2<? super V, ? super P> predicate, P parameter) {
        return this.map.countWith(predicate, parameter);
    }

    @Override
    public boolean anySatisfy(Predicate<? super V> predicate) {
        return this.map.anySatisfy(predicate);
    }

    @Override
    public <P> boolean anySatisfyWith(Predicate2<? super V, ? super P> predicate, P parameter) {
        return this.map.anySatisfyWith(predicate, parameter);
    }

    @Override
    public boolean allSatisfy(Predicate<? super V> predicate) {
        return this.map.allSatisfy(predicate);
    }

    @Override
    public <P> boolean allSatisfyWith(Predicate2<? super V, ? super P> predicate, P parameter) {
        return this.map.allSatisfyWith(predicate, parameter);
    }

    @Override
    public boolean noneSatisfy(Predicate<? super V> predicate) {
        return this.map.noneSatisfy(predicate);
    }

    @Override
    public <P> boolean noneSatisfyWith(Predicate2<? super V, ? super P> predicate, P parameter) {
        return this.map.noneSatisfyWith(predicate, parameter);
    }

    @Override
    public <IV> IV injectInto(IV injectedValue, Function2<? super IV, ? super V, ? extends IV> function) {
        return this.map.injectInto(injectedValue, function);
    }

    @Override
    public int injectInto(int injectedValue, IntObjectToIntFunction<? super V> function) {
        return this.map.injectInto(injectedValue, function);
    }

    @Override
    public long injectInto(long injectedValue, LongObjectToLongFunction<? super V> function) {
        return this.map.injectInto(injectedValue, function);
    }

    @Override
    public float injectInto(float injectedValue, FloatObjectToFloatFunction<? super V> function) {
        return this.map.injectInto(injectedValue, function);
    }

    @Override
    public double injectInto(double injectedValue, DoubleObjectToDoubleFunction<? super V> function) {
        return this.map.injectInto(injectedValue, function);
    }

    @Override
    public <R extends Collection<V>> R into(R target) {
        return this.map.into(target);
    }

    @Override
    public MutableList<V> toList() {
        return this.map.toList();
    }

    @Override
    public MutableList<V> toSortedList() {
        return this.map.toSortedList();
    }

    @Override
    public MutableList<V> toSortedList(Comparator<? super V> comparator) {
        return this.map.toSortedList(comparator);
    }

    @Override
    public <VV extends Comparable<? super VV>> MutableList<V> toSortedListBy(Function<? super V, ? extends VV> function) {
        return this.map.toSortedListBy(function);
    }

    @Override
    public MutableSet<V> toSet() {
        return this.map.toSet();
    }

    @Override
    public MutableSortedSet<V> toSortedSet() {
        return this.map.toSortedSet();
    }

    @Override
    public MutableSortedSet<V> toSortedSet(Comparator<? super V> comparator) {
        return this.map.toSortedSet(comparator);
    }

    @Override
    public <VV extends Comparable<? super VV>> MutableSortedSet<V> toSortedSetBy(Function<? super V, ? extends VV> function) {
        return this.map.toSortedSetBy(function);
    }

    @Override
    public MutableBag<V> toBag() {
        return this.map.toBag();
    }

    @Override
    public MutableSortedBag<V> toSortedBag() {
        return this.map.toSortedBag();
    }

    @Override
    public MutableSortedBag<V> toSortedBag(Comparator<? super V> comparator) {
        return this.map.toSortedBag(comparator);
    }

    @Override
    public <VV extends Comparable<? super VV>> MutableSortedBag<V> toSortedBagBy(Function<? super V, ? extends VV> function) {
        return this.map.toSortedBagBy(function);
    }

    @Override
    public <NK, NV> MutableMap<NK, NV> toMap(Function<? super V, ? extends NK> keyFunction, Function<? super V, ? extends NV> valueFunction) {
        return this.map.toMap(keyFunction, valueFunction);
    }

    @Override
    public <NK, NV> MutableSortedMap<NK, NV> toSortedMap(Function<? super V, ? extends NK> keyFunction, Function<? super V, ? extends NV> valueFunction) {
        return this.map.toSortedMap(keyFunction, valueFunction);
    }

    @Override
    public <NK, NV> MutableSortedMap<NK, NV> toSortedMap(Comparator<? super NK> comparator, Function<? super V, ? extends NK> keyFunction, Function<? super V, ? extends NV> valueFunction) {
        return this.map.toSortedMap(comparator, keyFunction, valueFunction);
    }

    @Override
    public <KK extends Comparable<? super KK>, NK, NV> MutableSortedMap<NK, NV> toSortedMapBy(Function<? super NK, KK> sortBy, Function<? super V, ? extends NK> keyFunction, Function<? super V, ? extends NV> valueFunction) {
        return this.map.toSortedMapBy(sortBy, keyFunction, valueFunction);
    }

    @Override
    public <NK, NV> MutableBiMap<NK, NV> toBiMap(Function<? super V, ? extends NK> keyFunction, Function<? super V, ? extends NV> valueFunction) {
        return this.map.toBiMap(keyFunction, valueFunction);
    }

    @Override
    public LazyIterable<V> asLazy() {
        return this.map.asLazy();
    }

    @Override
    public Object[] toArray() {
        return this.map.toArray();
    }

    @Override
    public <T> T[] toArray(T[] a) {
        return this.map.toArray(a);
    }

    @Override
    public V min(Comparator<? super V> comparator) {
        return this.map.min(comparator);
    }

    @Override
    public V max(Comparator<? super V> comparator) {
        return this.map.max(comparator);
    }

    @Override
    public V min() {
        return (V)this.map.min();
    }

    @Override
    public V max() {
        return (V)this.map.max();
    }

    @Override
    public <VV extends Comparable<? super VV>> V maxBy(Function<? super V, ? extends VV> function) {
        return this.map.maxBy(function);
    }

    @Override
    public <VV extends Comparable<? super VV>> V minBy(Function<? super V, ? extends VV> function) {
        return this.map.minBy(function);
    }

    @Override
    public long sumOfInt(IntFunction<? super V> function) {
        return this.map.sumOfInt(function);
    }

    @Override
    public double sumOfFloat(FloatFunction<? super V> function) {
        return this.map.sumOfFloat(function);
    }

    @Override
    public long sumOfLong(LongFunction<? super V> function) {
        return this.map.sumOfLong(function);
    }

    @Override
    public double sumOfDouble(DoubleFunction<? super V> function) {
        return this.map.sumOfDouble(function);
    }

    @Override
    public <V1> MutableObjectLongMap<V1> sumByInt(Function<? super V, ? extends V1> groupBy, IntFunction<? super V> function) {
        return this.map.sumByInt((Function)groupBy, (IntFunction)function);
    }

    @Override
    public <V1> MutableObjectDoubleMap<V1> sumByFloat(Function<? super V, ? extends V1> groupBy, FloatFunction<? super V> function) {
        return this.map.sumByFloat((Function)groupBy, (FloatFunction)function);
    }

    @Override
    public <V1> MutableObjectLongMap<V1> sumByLong(Function<? super V, ? extends V1> groupBy, LongFunction<? super V> function) {
        return this.map.sumByLong((Function)groupBy, (LongFunction)function);
    }

    @Override
    public <V1> MutableObjectDoubleMap<V1> sumByDouble(Function<? super V, ? extends V1> groupBy, DoubleFunction<? super V> function) {
        return this.map.sumByDouble((Function)groupBy, (DoubleFunction)function);
    }

    @Override
    public MutableLongSet keySet() {
        return UnmodifiableLongSet.of(this.map.keySet());
    }

    @Override
    public Collection<V> values() {
        return Collections.unmodifiableCollection(this.map.values());
    }

    @Override
    public LazyLongIterable keysView() {
        return this.map.keysView();
    }

    @Override
    public RichIterable<LongObjectPair<V>> keyValuesView() {
        return this.map.keyValuesView();
    }

    @Override
    public MutableObjectLongMap<V> flipUniqueValues() {
        return this.map.flipUniqueValues().asUnmodifiable();
    }

    @Override
    public boolean equals(Object obj) {
        return this.map.equals(obj);
    }

    @Override
    public int hashCode() {
        return this.map.hashCode();
    }

    @Override
    public String toString() {
        return this.map.toString();
    }

    @Override
    public String makeString() {
        return this.map.makeString();
    }

    @Override
    public String makeString(String separator) {
        return this.map.makeString(separator);
    }

    @Override
    public String makeString(String start, String separator, String end) {
        return this.map.makeString(start, separator, end);
    }

    @Override
    public void appendString(Appendable appendable) {
        this.map.appendString(appendable);
    }

    @Override
    public void appendString(Appendable appendable, String separator) {
        this.map.appendString(appendable, separator);
    }

    @Override
    public void appendString(Appendable appendable, String start, String separator, String end) {
        this.map.appendString(appendable, start, separator, end);
    }

    @Override
    public <VV> MutableBagMultimap<VV, V> groupBy(Function<? super V, ? extends VV> function) {
        return this.map.groupBy((Function)function);
    }

    @Override
    public <VV, R extends MutableMultimap<VV, V>> R groupBy(Function<? super V, ? extends VV> function, R target) {
        return this.map.groupBy(function, target);
    }

    @Override
    public <VV> MutableBagMultimap<VV, V> groupByEach(Function<? super V, ? extends Iterable<VV>> function) {
        return this.map.groupByEach(function);
    }

    @Override
    public <VV, R extends MutableMultimap<VV, V>> R groupByEach(Function<? super V, ? extends Iterable<VV>> function, R target) {
        return this.map.groupByEach(function, target);
    }

    @Override
    public <V1> MutableMap<V1, V> groupByUniqueKey(Function<? super V, ? extends V1> function) {
        return this.map.groupByUniqueKey((Function)function);
    }

    @Override
    public <V1, R extends MutableMapIterable<V1, V>> R groupByUniqueKey(Function<? super V, ? extends V1> function, R target) {
        return this.map.groupByUniqueKey(function, target);
    }

    @Override
    @Deprecated
    public <S> MutableBag<Pair<V, S>> zip(Iterable<S> that) {
        return this.map.zip((Iterable)that);
    }

    @Override
    public <S, R extends Collection<Pair<V, S>>> R zip(Iterable<S> that, R target) {
        return this.map.zip(that, target);
    }

    @Override
    public MutableLongObjectMap<V> withKeyValue(long key, V value) {
        throw new UnsupportedOperationException("Cannot call withKeyValue() on " + this.getClass().getSimpleName());
    }

    @Override
    public MutableLongObjectMap<V> withoutKey(long key) {
        throw new UnsupportedOperationException("Cannot call withoutKey() on " + this.getClass().getSimpleName());
    }

    @Override
    public MutableLongObjectMap<V> withoutAllKeys(LongIterable keys) {
        throw new UnsupportedOperationException("Cannot call withoutAllKeys() on " + this.getClass().getSimpleName());
    }

    @Override
    public MutableLongObjectMap<V> asUnmodifiable() {
        return this;
    }

    @Override
    public MutableLongObjectMap<V> asSynchronized() {
        return new SynchronizedLongObjectMap(this);
    }

    @Override
    public ImmutableLongObjectMap<V> toImmutable() {
        return LongObjectMaps.immutable.withAll(this);
    }

    @Override
    public void forEach(Procedure<? super V> procedure) {
        this.each(procedure);
    }

    @Override
    public void each(Procedure<? super V> procedure) {
        this.map.forEach(procedure);
    }

    @Override
    public void forEachWithIndex(ObjectIntProcedure<? super V> objectIntProcedure) {
        this.map.forEachWithIndex(objectIntProcedure);
    }

    @Override
    public <P> void forEachWith(Procedure2<? super V, ? super P> procedure, P parameter) {
        this.map.forEachWith(procedure, parameter);
    }

    @Override
    public Iterator<V> iterator() {
        return new UnmodifiableIteratorAdapter(this.map.iterator());
    }
}

