/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.collections.impl.map.mutable.primitive;

import java.io.Serializable;
import org.eclipse.collections.api.ByteIterable;
import org.eclipse.collections.api.LazyByteIterable;
import org.eclipse.collections.api.LazyShortIterable;
import org.eclipse.collections.api.RichIterable;
import org.eclipse.collections.api.ShortIterable;
import org.eclipse.collections.api.bag.MutableBag;
import org.eclipse.collections.api.bag.primitive.MutableShortBag;
import org.eclipse.collections.api.block.function.primitive.ByteShortToShortFunction;
import org.eclipse.collections.api.block.function.primitive.ByteToShortFunction;
import org.eclipse.collections.api.block.function.primitive.ObjectShortToObjectFunction;
import org.eclipse.collections.api.block.function.primitive.ShortFunction;
import org.eclipse.collections.api.block.function.primitive.ShortFunction0;
import org.eclipse.collections.api.block.function.primitive.ShortToObjectFunction;
import org.eclipse.collections.api.block.function.primitive.ShortToShortFunction;
import org.eclipse.collections.api.block.predicate.primitive.ByteShortPredicate;
import org.eclipse.collections.api.block.predicate.primitive.ShortPredicate;
import org.eclipse.collections.api.block.procedure.primitive.ByteProcedure;
import org.eclipse.collections.api.block.procedure.primitive.ByteShortProcedure;
import org.eclipse.collections.api.block.procedure.primitive.ShortProcedure;
import org.eclipse.collections.api.collection.primitive.MutableShortCollection;
import org.eclipse.collections.api.iterator.MutableShortIterator;
import org.eclipse.collections.api.list.primitive.MutableShortList;
import org.eclipse.collections.api.map.primitive.ByteShortMap;
import org.eclipse.collections.api.map.primitive.ImmutableByteShortMap;
import org.eclipse.collections.api.map.primitive.MutableByteShortMap;
import org.eclipse.collections.api.map.primitive.MutableShortByteMap;
import org.eclipse.collections.api.set.primitive.MutableByteSet;
import org.eclipse.collections.api.set.primitive.MutableShortSet;
import org.eclipse.collections.api.tuple.primitive.ByteShortPair;
import org.eclipse.collections.impl.collection.mutable.primitive.UnmodifiableShortCollection;
import org.eclipse.collections.impl.factory.primitive.ByteShortMaps;
import org.eclipse.collections.impl.iterator.UnmodifiableShortIterator;
import org.eclipse.collections.impl.map.mutable.primitive.SynchronizedByteShortMap;
import org.eclipse.collections.impl.set.mutable.primitive.UnmodifiableByteSet;

public class UnmodifiableByteShortMap
implements MutableByteShortMap,
Serializable {
    private static final long serialVersionUID = 1L;
    private final MutableByteShortMap map;

    public UnmodifiableByteShortMap(MutableByteShortMap map2) {
        if (map2 == null) {
            throw new IllegalArgumentException("Cannot create a UnmodifiableByteShortMap on a null map");
        }
        this.map = map2;
    }

    @Override
    public void clear() {
        throw new UnsupportedOperationException("Cannot call clear() on " + this.getClass().getSimpleName());
    }

    @Override
    public void put(byte key, short value) {
        throw new UnsupportedOperationException("Cannot call put() on " + this.getClass().getSimpleName());
    }

    @Override
    public void putPair(ByteShortPair keyValuePair) {
        throw new UnsupportedOperationException("Cannot call putPair() on " + this.getClass().getSimpleName());
    }

    @Override
    public void putAll(ByteShortMap map2) {
        throw new UnsupportedOperationException("Cannot call putAll() on " + this.getClass().getSimpleName());
    }

    @Override
    public void updateValues(ByteShortToShortFunction function) {
        throw new UnsupportedOperationException("Cannot call updateValues() on " + this.getClass().getSimpleName());
    }

    @Override
    public void removeKey(byte key) {
        throw new UnsupportedOperationException("Cannot call removeKey() on " + this.getClass().getSimpleName());
    }

    @Override
    public void remove(byte key) {
        throw new UnsupportedOperationException("Cannot call remove() on " + this.getClass().getSimpleName());
    }

    @Override
    public short removeKeyIfAbsent(byte key, short value) {
        if (this.map.containsKey(key)) {
            throw new UnsupportedOperationException("Cannot call removeKey() on " + this.getClass().getSimpleName());
        }
        return value;
    }

    @Override
    public short getIfAbsentPut(byte key, short value) {
        return this.map.getIfAbsentPut(key, () -> {
            throw new UnsupportedOperationException();
        });
    }

    @Override
    public short getAndPut(byte key, short putValue, short defaultValue) {
        throw new UnsupportedOperationException("Cannot call remove() on " + this.getClass().getSimpleName());
    }

    @Override
    public short getIfAbsentPut(byte key, ShortFunction0 function) {
        return this.map.getIfAbsentPut(key, () -> {
            throw new UnsupportedOperationException();
        });
    }

    @Override
    public short getIfAbsentPutWithKey(byte key, ByteToShortFunction function) {
        return this.map.getIfAbsentPut(key, () -> {
            throw new UnsupportedOperationException();
        });
    }

    @Override
    public <P> short getIfAbsentPutWith(byte key, ShortFunction<? super P> function, P parameter) {
        return this.map.getIfAbsentPut(key, () -> {
            throw new UnsupportedOperationException();
        });
    }

    @Override
    public short updateValue(byte key, short initialValueIfAbsent, ShortToShortFunction function) {
        throw new UnsupportedOperationException("Cannot call updateValue() on " + this.getClass().getSimpleName());
    }

    @Override
    public short get(byte key) {
        return this.map.get(key);
    }

    @Override
    public short getIfAbsent(byte key, short ifAbsent) {
        return this.map.getIfAbsent(key, ifAbsent);
    }

    @Override
    public short getOrThrow(byte key) {
        return this.map.getOrThrow(key);
    }

    @Override
    public boolean containsKey(byte key) {
        return this.map.containsKey(key);
    }

    @Override
    public boolean containsValue(short value) {
        return this.map.containsValue(value);
    }

    @Override
    public void forEachValue(ShortProcedure procedure) {
        this.map.forEachValue(procedure);
    }

    @Override
    public void forEachKey(ByteProcedure procedure) {
        this.map.forEachKey(procedure);
    }

    @Override
    public void forEachKeyValue(ByteShortProcedure procedure) {
        this.map.forEachKeyValue(procedure);
    }

    @Override
    public LazyByteIterable keysView() {
        return this.map.keysView();
    }

    @Override
    public RichIterable<ByteShortPair> keyValuesView() {
        return this.map.keyValuesView();
    }

    @Override
    public MutableShortByteMap flipUniqueValues() {
        return this.map.flipUniqueValues().asUnmodifiable();
    }

    @Override
    public MutableByteShortMap select(ByteShortPredicate predicate) {
        return this.map.select(predicate);
    }

    @Override
    public MutableByteShortMap reject(ByteShortPredicate predicate) {
        return this.map.reject(predicate);
    }

    @Override
    public MutableShortIterator shortIterator() {
        return new UnmodifiableShortIterator(this.map.shortIterator());
    }

    @Override
    public void each(ShortProcedure procedure) {
        this.map.forEach(procedure);
    }

    @Override
    public int count(ShortPredicate predicate) {
        return this.map.count(predicate);
    }

    @Override
    public boolean anySatisfy(ShortPredicate predicate) {
        return this.map.anySatisfy(predicate);
    }

    @Override
    public boolean allSatisfy(ShortPredicate predicate) {
        return this.map.allSatisfy(predicate);
    }

    @Override
    public boolean noneSatisfy(ShortPredicate predicate) {
        return this.map.noneSatisfy(predicate);
    }

    @Override
    public MutableShortBag select(ShortPredicate predicate) {
        return this.map.select(predicate);
    }

    @Override
    public MutableShortBag reject(ShortPredicate predicate) {
        return this.map.reject(predicate);
    }

    @Override
    public <V> MutableBag<V> collect(ShortToObjectFunction<? extends V> function) {
        return this.map.collect((ShortToObjectFunction)function);
    }

    @Override
    public short detectIfNone(ShortPredicate predicate, short ifNone) {
        return this.map.detectIfNone(predicate, ifNone);
    }

    @Override
    public long sum() {
        return this.map.sum();
    }

    @Override
    public short max() {
        return this.map.max();
    }

    @Override
    public short maxIfEmpty(short defaultValue) {
        return this.map.maxIfEmpty(defaultValue);
    }

    @Override
    public short min() {
        return this.map.min();
    }

    @Override
    public short minIfEmpty(short defaultValue) {
        return this.map.minIfEmpty(defaultValue);
    }

    @Override
    public double average() {
        return this.map.average();
    }

    @Override
    public double median() {
        return this.map.median();
    }

    @Override
    public short addToValue(byte key, short toBeAdded) {
        throw new UnsupportedOperationException("Cannot call addToValue() on " + this.getClass().getSimpleName());
    }

    @Override
    public short[] toSortedArray() {
        return this.map.toSortedArray();
    }

    @Override
    public MutableShortList toSortedList() {
        return this.map.toSortedList();
    }

    @Override
    public short[] toArray() {
        return this.map.toArray();
    }

    @Override
    public short[] toArray(short[] target) {
        return this.map.toArray(target);
    }

    @Override
    public boolean contains(short value) {
        return this.map.contains(value);
    }

    @Override
    public boolean containsAll(short ... source) {
        return this.map.containsAll(source);
    }

    @Override
    public boolean containsAll(ShortIterable source) {
        return this.map.containsAll(source);
    }

    @Override
    public MutableShortList toList() {
        return this.map.toList();
    }

    @Override
    public MutableShortSet toSet() {
        return this.map.toSet();
    }

    @Override
    public MutableShortBag toBag() {
        return this.map.toBag();
    }

    @Override
    public LazyShortIterable asLazy() {
        return this.map.asLazy();
    }

    @Override
    public MutableByteShortMap withKeyValue(byte key, short value) {
        throw new UnsupportedOperationException("Cannot call withKeyValue() on " + this.getClass().getSimpleName());
    }

    @Override
    public MutableByteShortMap withoutKey(byte key) {
        throw new UnsupportedOperationException("Cannot call withoutKey() on " + this.getClass().getSimpleName());
    }

    @Override
    public MutableByteShortMap withoutAllKeys(ByteIterable keys) {
        throw new UnsupportedOperationException("Cannot call withoutAllKeys() on " + this.getClass().getSimpleName());
    }

    @Override
    public MutableByteShortMap asUnmodifiable() {
        return this;
    }

    @Override
    public MutableByteShortMap asSynchronized() {
        return new SynchronizedByteShortMap(this);
    }

    @Override
    public ImmutableByteShortMap toImmutable() {
        return ByteShortMaps.immutable.withAll(this);
    }

    @Override
    public int size() {
        return this.map.size();
    }

    @Override
    public boolean isEmpty() {
        return this.map.isEmpty();
    }

    @Override
    public boolean notEmpty() {
        return this.map.notEmpty();
    }

    @Override
    public MutableByteSet keySet() {
        return UnmodifiableByteSet.of(this.map.keySet());
    }

    @Override
    public MutableShortCollection values() {
        return UnmodifiableShortCollection.of(this.map.values());
    }

    @Override
    public boolean equals(Object otherMap) {
        return this.map.equals(otherMap);
    }

    @Override
    public int hashCode() {
        return this.map.hashCode();
    }

    @Override
    public String toString() {
        return this.map.toString();
    }

    @Override
    public String makeString() {
        return this.map.makeString();
    }

    @Override
    public String makeString(String separator) {
        return this.map.makeString(separator);
    }

    @Override
    public String makeString(String start, String separator, String end) {
        return this.map.makeString(start, separator, end);
    }

    @Override
    public void appendString(Appendable appendable) {
        this.map.appendString(appendable);
    }

    @Override
    public void appendString(Appendable appendable, String separator) {
        this.map.appendString(appendable, separator);
    }

    @Override
    public void appendString(Appendable appendable, String start, String separator, String end) {
        this.map.appendString(appendable, start, separator, end);
    }

    @Override
    public <T> T injectInto(T injectedValue, ObjectShortToObjectFunction<? super T, ? extends T> function) {
        return this.map.injectInto(injectedValue, function);
    }

    @Override
    public RichIterable<ShortIterable> chunk(int size2) {
        return this.map.chunk(size2);
    }
}

