/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.collections.impl.map.mutable.primitive;

import java.io.Serializable;
import org.eclipse.collections.api.FloatIterable;
import org.eclipse.collections.api.IntIterable;
import org.eclipse.collections.api.LazyFloatIterable;
import org.eclipse.collections.api.LazyIntIterable;
import org.eclipse.collections.api.RichIterable;
import org.eclipse.collections.api.bag.MutableBag;
import org.eclipse.collections.api.bag.primitive.MutableIntBag;
import org.eclipse.collections.api.block.function.primitive.FloatIntToIntFunction;
import org.eclipse.collections.api.block.function.primitive.FloatToIntFunction;
import org.eclipse.collections.api.block.function.primitive.IntFunction;
import org.eclipse.collections.api.block.function.primitive.IntFunction0;
import org.eclipse.collections.api.block.function.primitive.IntToIntFunction;
import org.eclipse.collections.api.block.function.primitive.IntToObjectFunction;
import org.eclipse.collections.api.block.function.primitive.ObjectIntToObjectFunction;
import org.eclipse.collections.api.block.predicate.primitive.FloatIntPredicate;
import org.eclipse.collections.api.block.predicate.primitive.IntPredicate;
import org.eclipse.collections.api.block.procedure.primitive.FloatIntProcedure;
import org.eclipse.collections.api.block.procedure.primitive.FloatProcedure;
import org.eclipse.collections.api.block.procedure.primitive.IntProcedure;
import org.eclipse.collections.api.collection.primitive.MutableIntCollection;
import org.eclipse.collections.api.iterator.MutableIntIterator;
import org.eclipse.collections.api.list.primitive.MutableIntList;
import org.eclipse.collections.api.map.primitive.FloatIntMap;
import org.eclipse.collections.api.map.primitive.ImmutableFloatIntMap;
import org.eclipse.collections.api.map.primitive.MutableFloatIntMap;
import org.eclipse.collections.api.map.primitive.MutableIntFloatMap;
import org.eclipse.collections.api.set.primitive.MutableFloatSet;
import org.eclipse.collections.api.set.primitive.MutableIntSet;
import org.eclipse.collections.api.tuple.primitive.FloatIntPair;
import org.eclipse.collections.impl.SynchronizedRichIterable;
import org.eclipse.collections.impl.collection.mutable.primitive.SynchronizedIntCollection;
import org.eclipse.collections.impl.factory.primitive.FloatIntMaps;
import org.eclipse.collections.impl.map.mutable.primitive.UnmodifiableFloatIntMap;
import org.eclipse.collections.impl.set.mutable.primitive.SynchronizedFloatSet;

public class SynchronizedFloatIntMap
implements MutableFloatIntMap,
Serializable {
    private static final long serialVersionUID = 1L;
    private final Object lock;
    private final MutableFloatIntMap map;

    public SynchronizedFloatIntMap(MutableFloatIntMap map2) {
        this(map2, null);
    }

    public SynchronizedFloatIntMap(MutableFloatIntMap map2, Object newLock) {
        if (map2 == null) {
            throw new IllegalArgumentException("Cannot create a SynchronizedFloatIntMap on a null map");
        }
        this.map = map2;
        this.lock = newLock == null ? this : newLock;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clear() {
        Object object = this.lock;
        synchronized (object) {
            this.map.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void put(float key, int value) {
        Object object = this.lock;
        synchronized (object) {
            this.map.put(key, value);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void putPair(FloatIntPair keyValuePair) {
        Object object = this.lock;
        synchronized (object) {
            this.map.put(keyValuePair.getOne(), keyValuePair.getTwo());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void putAll(FloatIntMap map2) {
        Object object = this.lock;
        synchronized (object) {
            this.map.putAll(map2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateValues(FloatIntToIntFunction function) {
        Object object = this.lock;
        synchronized (object) {
            this.map.updateValues(function);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeKey(float key) {
        Object object = this.lock;
        synchronized (object) {
            this.map.removeKey(key);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void remove(float key) {
        Object object = this.lock;
        synchronized (object) {
            this.map.remove(key);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int removeKeyIfAbsent(float key, int value) {
        Object object = this.lock;
        synchronized (object) {
            return this.map.removeKeyIfAbsent(key, value);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getIfAbsentPut(float key, int value) {
        Object object = this.lock;
        synchronized (object) {
            return this.map.getIfAbsentPut(key, value);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getAndPut(float key, int putValue, int defaultValue) {
        Object object = this.lock;
        synchronized (object) {
            return this.map.getAndPut(key, putValue, defaultValue);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getIfAbsentPut(float key, IntFunction0 function) {
        Object object = this.lock;
        synchronized (object) {
            return this.map.getIfAbsentPut(key, function);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getIfAbsentPutWithKey(float key, FloatToIntFunction function) {
        Object object = this.lock;
        synchronized (object) {
            return this.map.getIfAbsentPutWithKey(key, function);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <P> int getIfAbsentPutWith(float key, IntFunction<? super P> function, P parameter) {
        Object object = this.lock;
        synchronized (object) {
            return this.map.getIfAbsentPutWith(key, function, parameter);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int updateValue(float key, int initialValueIfAbsent, IntToIntFunction function) {
        Object object = this.lock;
        synchronized (object) {
            return this.map.updateValue(key, initialValueIfAbsent, function);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int get(float key) {
        Object object = this.lock;
        synchronized (object) {
            return this.map.get(key);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getIfAbsent(float key, int ifAbsent) {
        Object object = this.lock;
        synchronized (object) {
            return this.map.getIfAbsent(key, ifAbsent);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getOrThrow(float key) {
        Object object = this.lock;
        synchronized (object) {
            return this.map.getOrThrow(key);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean containsKey(float key) {
        Object object = this.lock;
        synchronized (object) {
            return this.map.containsKey(key);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean containsValue(int value) {
        Object object = this.lock;
        synchronized (object) {
            return this.map.containsValue(value);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void forEachValue(IntProcedure procedure) {
        Object object = this.lock;
        synchronized (object) {
            this.map.forEachValue(procedure);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void forEachKey(FloatProcedure procedure) {
        Object object = this.lock;
        synchronized (object) {
            this.map.forEachKey(procedure);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void forEachKeyValue(FloatIntProcedure procedure) {
        Object object = this.lock;
        synchronized (object) {
            this.map.forEachKeyValue(procedure);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public LazyFloatIterable keysView() {
        Object object = this.lock;
        synchronized (object) {
            return this.map.keysView();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public RichIterable<FloatIntPair> keyValuesView() {
        Object object = this.lock;
        synchronized (object) {
            return SynchronizedRichIterable.of(this.map.keyValuesView(), this.lock).asLazy();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public MutableIntFloatMap flipUniqueValues() {
        Object object = this.lock;
        synchronized (object) {
            return this.map.flipUniqueValues();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public MutableFloatIntMap select(FloatIntPredicate predicate) {
        Object object = this.lock;
        synchronized (object) {
            return this.map.select(predicate);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public MutableFloatIntMap reject(FloatIntPredicate predicate) {
        Object object = this.lock;
        synchronized (object) {
            return this.map.reject(predicate);
        }
    }

    @Override
    public MutableIntIterator intIterator() {
        return this.map.intIterator();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void each(IntProcedure procedure) {
        Object object = this.lock;
        synchronized (object) {
            this.map.forEach(procedure);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int count(IntPredicate predicate) {
        Object object = this.lock;
        synchronized (object) {
            return this.map.count(predicate);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean anySatisfy(IntPredicate predicate) {
        Object object = this.lock;
        synchronized (object) {
            return this.map.anySatisfy(predicate);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean allSatisfy(IntPredicate predicate) {
        Object object = this.lock;
        synchronized (object) {
            return this.map.allSatisfy(predicate);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean noneSatisfy(IntPredicate predicate) {
        Object object = this.lock;
        synchronized (object) {
            return this.map.noneSatisfy(predicate);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public MutableIntBag select(IntPredicate predicate) {
        Object object = this.lock;
        synchronized (object) {
            return this.map.select(predicate);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public MutableIntBag reject(IntPredicate predicate) {
        Object object = this.lock;
        synchronized (object) {
            return this.map.reject(predicate);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <V> MutableBag<V> collect(IntToObjectFunction<? extends V> function) {
        Object object = this.lock;
        synchronized (object) {
            return this.map.collect((IntToObjectFunction)function);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int detectIfNone(IntPredicate predicate, int ifNone) {
        Object object = this.lock;
        synchronized (object) {
            return this.map.detectIfNone(predicate, ifNone);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long sum() {
        Object object = this.lock;
        synchronized (object) {
            return this.map.sum();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int max() {
        Object object = this.lock;
        synchronized (object) {
            return this.map.max();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int maxIfEmpty(int defaultValue) {
        Object object = this.lock;
        synchronized (object) {
            return this.map.maxIfEmpty(defaultValue);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int min() {
        Object object = this.lock;
        synchronized (object) {
            return this.map.min();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int minIfEmpty(int defaultValue) {
        Object object = this.lock;
        synchronized (object) {
            return this.map.minIfEmpty(defaultValue);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public double average() {
        Object object = this.lock;
        synchronized (object) {
            return this.map.average();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public double median() {
        Object object = this.lock;
        synchronized (object) {
            return this.map.median();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int addToValue(float key, int toBeAdded) {
        Object object = this.lock;
        synchronized (object) {
            return this.map.addToValue(key, toBeAdded);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int[] toSortedArray() {
        Object object = this.lock;
        synchronized (object) {
            return this.map.toSortedArray();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public MutableIntList toSortedList() {
        Object object = this.lock;
        synchronized (object) {
            return this.map.toSortedList();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int[] toArray() {
        Object object = this.lock;
        synchronized (object) {
            return this.map.toArray();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int[] toArray(int[] target) {
        Object object = this.lock;
        synchronized (object) {
            return this.map.toArray(target);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean contains(int value) {
        Object object = this.lock;
        synchronized (object) {
            return this.map.contains(value);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean containsAll(int ... source) {
        Object object = this.lock;
        synchronized (object) {
            return this.map.containsAll(source);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean containsAll(IntIterable source) {
        Object object = this.lock;
        synchronized (object) {
            return this.map.containsAll(source);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public MutableIntList toList() {
        Object object = this.lock;
        synchronized (object) {
            return this.map.toList();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public MutableIntSet toSet() {
        Object object = this.lock;
        synchronized (object) {
            return this.map.toSet();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public MutableIntBag toBag() {
        Object object = this.lock;
        synchronized (object) {
            return this.map.toBag();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public LazyIntIterable asLazy() {
        Object object = this.lock;
        synchronized (object) {
            return this.map.asLazy();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public MutableFloatIntMap withKeyValue(float key, int value) {
        Object object = this.lock;
        synchronized (object) {
            this.map.withKeyValue(key, value);
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public MutableFloatIntMap withoutKey(float key) {
        Object object = this.lock;
        synchronized (object) {
            this.map.withoutKey(key);
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public MutableFloatIntMap withoutAllKeys(FloatIterable keys) {
        Object object = this.lock;
        synchronized (object) {
            this.map.withoutAllKeys(keys);
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public MutableFloatIntMap asUnmodifiable() {
        Object object = this.lock;
        synchronized (object) {
            return new UnmodifiableFloatIntMap(this);
        }
    }

    @Override
    public MutableFloatIntMap asSynchronized() {
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ImmutableFloatIntMap toImmutable() {
        Object object = this.lock;
        synchronized (object) {
            return FloatIntMaps.immutable.withAll(this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int size() {
        Object object = this.lock;
        synchronized (object) {
            return this.map.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isEmpty() {
        Object object = this.lock;
        synchronized (object) {
            return this.map.isEmpty();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean notEmpty() {
        Object object = this.lock;
        synchronized (object) {
            return this.map.notEmpty();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public MutableFloatSet keySet() {
        Object object = this.lock;
        synchronized (object) {
            return SynchronizedFloatSet.of(this.map.keySet(), this.lock);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public MutableIntCollection values() {
        Object object = this.lock;
        synchronized (object) {
            return SynchronizedIntCollection.of(this.map.values(), this.lock);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean equals(Object otherMap) {
        Object object = this.lock;
        synchronized (object) {
            return this.map.equals(otherMap);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int hashCode() {
        Object object = this.lock;
        synchronized (object) {
            return this.map.hashCode();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String toString() {
        Object object = this.lock;
        synchronized (object) {
            return this.map.toString();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String makeString() {
        Object object = this.lock;
        synchronized (object) {
            return this.map.makeString();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String makeString(String separator) {
        Object object = this.lock;
        synchronized (object) {
            return this.map.makeString(separator);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String makeString(String start, String separator, String end) {
        Object object = this.lock;
        synchronized (object) {
            return this.map.makeString(start, separator, end);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void appendString(Appendable appendable) {
        Object object = this.lock;
        synchronized (object) {
            this.map.appendString(appendable);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void appendString(Appendable appendable, String separator) {
        Object object = this.lock;
        synchronized (object) {
            this.map.appendString(appendable, separator);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void appendString(Appendable appendable, String start, String separator, String end) {
        Object object = this.lock;
        synchronized (object) {
            this.map.appendString(appendable, start, separator, end);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> T injectInto(T injectedValue, ObjectIntToObjectFunction<? super T, ? extends T> function) {
        Object object = this.lock;
        synchronized (object) {
            return this.map.injectInto(injectedValue, function);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public RichIterable<IntIterable> chunk(int size2) {
        Object object = this.lock;
        synchronized (object) {
            return this.map.chunk(size2);
        }
    }
}

