/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.collections.impl.map.mutable.primitive;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.lang.reflect.Array;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Set;
import org.eclipse.collections.api.ByteIterable;
import org.eclipse.collections.api.LazyByteIterable;
import org.eclipse.collections.api.LazyIterable;
import org.eclipse.collections.api.RichIterable;
import org.eclipse.collections.api.bag.primitive.MutableByteBag;
import org.eclipse.collections.api.block.function.primitive.ByteFunction;
import org.eclipse.collections.api.block.function.primitive.ByteFunction0;
import org.eclipse.collections.api.block.function.primitive.ByteToByteFunction;
import org.eclipse.collections.api.block.function.primitive.ByteToObjectFunction;
import org.eclipse.collections.api.block.function.primitive.ObjectByteToByteFunction;
import org.eclipse.collections.api.block.function.primitive.ObjectByteToObjectFunction;
import org.eclipse.collections.api.block.predicate.primitive.BytePredicate;
import org.eclipse.collections.api.block.predicate.primitive.ObjectBytePredicate;
import org.eclipse.collections.api.block.procedure.Procedure;
import org.eclipse.collections.api.block.procedure.Procedure2;
import org.eclipse.collections.api.block.procedure.primitive.ByteProcedure;
import org.eclipse.collections.api.block.procedure.primitive.ObjectByteProcedure;
import org.eclipse.collections.api.block.procedure.primitive.ObjectIntProcedure;
import org.eclipse.collections.api.collection.MutableCollection;
import org.eclipse.collections.api.collection.primitive.ImmutableByteCollection;
import org.eclipse.collections.api.collection.primitive.MutableByteCollection;
import org.eclipse.collections.api.factory.Lists;
import org.eclipse.collections.api.factory.primitive.ByteBags;
import org.eclipse.collections.api.factory.primitive.ByteLists;
import org.eclipse.collections.api.factory.primitive.ByteObjectMaps;
import org.eclipse.collections.api.factory.primitive.ByteSets;
import org.eclipse.collections.api.factory.primitive.ObjectByteMaps;
import org.eclipse.collections.api.iterator.ByteIterator;
import org.eclipse.collections.api.iterator.MutableByteIterator;
import org.eclipse.collections.api.list.MutableList;
import org.eclipse.collections.api.list.primitive.MutableByteList;
import org.eclipse.collections.api.map.primitive.ImmutableObjectByteMap;
import org.eclipse.collections.api.map.primitive.MutableByteObjectMap;
import org.eclipse.collections.api.map.primitive.MutableObjectByteMap;
import org.eclipse.collections.api.map.primitive.ObjectByteMap;
import org.eclipse.collections.api.set.primitive.ByteSet;
import org.eclipse.collections.api.set.primitive.MutableByteSet;
import org.eclipse.collections.api.tuple.primitive.ObjectBytePair;
import org.eclipse.collections.impl.collection.mutable.primitive.SynchronizedByteCollection;
import org.eclipse.collections.impl.collection.mutable.primitive.UnmodifiableByteCollection;
import org.eclipse.collections.impl.lazy.AbstractLazyIterable;
import org.eclipse.collections.impl.lazy.primitive.LazyByteIterableAdapter;
import org.eclipse.collections.impl.map.mutable.primitive.SynchronizedObjectByteMap;
import org.eclipse.collections.impl.map.mutable.primitive.UnmodifiableObjectByteMap;
import org.eclipse.collections.impl.tuple.primitive.PrimitiveTuples;

public class ObjectByteHashMap<K>
implements MutableObjectByteMap<K>,
Externalizable {
    public static final byte EMPTY_VALUE = 0;
    private static final long serialVersionUID = 1L;
    private static final int DEFAULT_INITIAL_CAPACITY = 8;
    private static final Object NULL_KEY = new Object(){

        public boolean equals(Object obj) {
            throw new RuntimeException("Possible corruption through unsynchronized concurrent modification.");
        }

        public int hashCode() {
            throw new RuntimeException("Possible corruption through unsynchronized concurrent modification.");
        }

        public String toString() {
            return "ObjectByteHashMap.NULL_KEY";
        }
    };
    private static final Object REMOVED_KEY = new Object(){

        public boolean equals(Object obj) {
            throw new RuntimeException("Possible corruption through unsynchronized concurrent modification.");
        }

        public int hashCode() {
            throw new RuntimeException("Possible corruption through unsynchronized concurrent modification.");
        }

        public String toString() {
            return "ObjectByteHashMap.REMOVED_KEY";
        }
    };
    private Object[] keys;
    private byte[] values;
    private int occupiedWithData;
    private int occupiedWithSentinels;

    public ObjectByteHashMap() {
        this.allocateTable(16);
    }

    public ObjectByteHashMap(int initialCapacity) {
        if (initialCapacity < 0) {
            throw new IllegalArgumentException("initial capacity cannot be less than 0");
        }
        int capacity = this.smallestPowerOfTwoGreaterThan(this.fastCeil(initialCapacity << 1));
        this.allocateTable(capacity);
    }

    public ObjectByteHashMap(ObjectByteMap<? extends K> map2) {
        this(Math.max(map2.size(), 8));
        this.putAll(map2);
    }

    public static <K> ObjectByteHashMap<K> newMap() {
        return new ObjectByteHashMap<K>();
    }

    public static <K> ObjectByteHashMap<K> newWithKeysValues(K key1, byte value1) {
        return new ObjectByteHashMap<K>(1).withKeyValue((Object)key1, value1);
    }

    public static <K> ObjectByteHashMap<K> newWithKeysValues(K key1, byte value1, K key2, byte value2) {
        return new ObjectByteHashMap<K>(2).withKeysValues(key1, value1, key2, value2);
    }

    public static <K> ObjectByteHashMap<K> newWithKeysValues(K key1, byte value1, K key2, byte value2, K key3, byte value3) {
        return new ObjectByteHashMap<K>(3).withKeysValues(key1, value1, key2, value2, key3, value3);
    }

    public static <K> ObjectByteHashMap<K> newWithKeysValues(K key1, byte value1, K key2, byte value2, K key3, byte value3, K key4, byte value4) {
        return new ObjectByteHashMap<K>(4).withKeysValues(key1, value1, key2, value2, key3, value3, key4, value4);
    }

    private int smallestPowerOfTwoGreaterThan(int n) {
        return n > 1 ? Integer.highestOneBit(n - 1) << 1 : 1;
    }

    private int fastCeil(float v) {
        int possibleResult = (int)v;
        if (v - (float)possibleResult > 0.0f) {
            ++possibleResult;
        }
        return possibleResult;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof ObjectByteMap)) {
            return false;
        }
        ObjectByteMap other = (ObjectByteMap)obj;
        if (this.size() != other.size()) {
            return false;
        }
        for (int i = 0; i < this.keys.length; ++i) {
            if (!ObjectByteHashMap.isNonSentinel(this.keys[i]) || other.containsKey(this.toNonSentinel(this.keys[i])) && this.values[i] == other.getOrThrow(this.toNonSentinel(this.keys[i]))) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        int result = 0;
        for (int i = 0; i < this.keys.length; ++i) {
            if (!ObjectByteHashMap.isNonSentinel(this.keys[i])) continue;
            result += (this.toNonSentinel(this.keys[i]) == null ? 0 : this.keys[i].hashCode()) ^ this.values[i];
        }
        return result;
    }

    @Override
    public String toString() {
        StringBuilder appendable = new StringBuilder();
        appendable.append("{");
        boolean first = true;
        for (int i = 0; i < this.keys.length; ++i) {
            Object key = this.keys[i];
            if (!ObjectByteHashMap.isNonSentinel(key)) continue;
            if (!first) {
                appendable.append(", ");
            }
            appendable.append(this.toNonSentinel(key)).append("=").append(this.values[i]);
            first = false;
        }
        appendable.append("}");
        return appendable.toString();
    }

    @Override
    public int size() {
        return this.occupiedWithData;
    }

    @Override
    public boolean isEmpty() {
        return this.size() == 0;
    }

    @Override
    public boolean notEmpty() {
        return this.size() != 0;
    }

    @Override
    public String makeString() {
        return this.makeString(", ");
    }

    @Override
    public String makeString(String separator) {
        return this.makeString("", separator, "");
    }

    @Override
    public String makeString(String start, String separator, String end) {
        StringBuilder stringBuilder = new StringBuilder();
        this.appendString(stringBuilder, start, separator, end);
        return ((Object)stringBuilder).toString();
    }

    @Override
    public void appendString(Appendable appendable) {
        this.appendString(appendable, ", ");
    }

    @Override
    public void appendString(Appendable appendable, String separator) {
        this.appendString(appendable, "", separator, "");
    }

    @Override
    public void appendString(Appendable appendable, String start, String separator, String end) {
        try {
            appendable.append(start);
            boolean first = true;
            for (int i = 0; i < this.keys.length; ++i) {
                Object key = this.keys[i];
                if (!ObjectByteHashMap.isNonSentinel(key)) continue;
                if (!first) {
                    appendable.append(separator);
                }
                appendable.append(String.valueOf(String.valueOf(this.values[i])));
                first = false;
            }
            appendable.append(end);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public MutableByteIterator byteIterator() {
        return new InternalByteIterator();
    }

    @Override
    public byte[] toArray() {
        byte[] result = new byte[this.size()];
        int index = 0;
        for (int i = 0; i < this.keys.length; ++i) {
            if (!ObjectByteHashMap.isNonSentinel(this.keys[i])) continue;
            result[index] = this.values[i];
            ++index;
        }
        return result;
    }

    @Override
    public byte[] toArray(byte[] target) {
        if (target.length < this.size()) {
            target = new byte[this.size()];
        }
        int index = 0;
        for (int i = 0; i < this.keys.length; ++i) {
            if (!ObjectByteHashMap.isNonSentinel(this.keys[i])) continue;
            target[index] = this.values[i];
            ++index;
        }
        return target;
    }

    @Override
    public boolean contains(byte value) {
        return this.containsValue(value);
    }

    @Override
    public boolean containsAll(byte ... source) {
        for (byte item : source) {
            if (this.containsValue(item)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean containsAll(ByteIterable source) {
        return this.containsAll(source.toArray());
    }

    @Override
    public void clear() {
        this.occupiedWithData = 0;
        this.occupiedWithSentinels = 0;
        Arrays.fill(this.keys, null);
        Arrays.fill(this.values, (byte)0);
    }

    @Override
    public void put(K key, byte value) {
        int index = this.probe(key);
        if (ObjectByteHashMap.isNonSentinel(this.keys[index]) && ObjectByteHashMap.nullSafeEquals(this.toNonSentinel(this.keys[index]), key)) {
            this.values[index] = value;
            return;
        }
        this.addKeyValueAtIndex(key, value, index);
    }

    @Override
    public void putAll(ObjectByteMap<? extends K> map2) {
        map2.forEachKeyValue(this::put);
    }

    @Override
    public void updateValues(ObjectByteToByteFunction<? super K> function) {
        for (int i = 0; i < this.keys.length; ++i) {
            if (!ObjectByteHashMap.isNonSentinel(this.keys[i])) continue;
            this.values[i] = function.valueOf(this.toNonSentinel(this.keys[i]), this.values[i]);
        }
    }

    @Override
    public void removeKey(K key) {
        int index = this.probe(key);
        this.removeKeyAtIndex(key, index);
    }

    private void removeKeyAtIndex(K key, int index) {
        if (ObjectByteHashMap.isNonSentinel(this.keys[index]) && ObjectByteHashMap.nullSafeEquals(this.toNonSentinel(this.keys[index]), key)) {
            this.keys[index] = REMOVED_KEY;
            this.values[index] = 0;
            --this.occupiedWithData;
            ++this.occupiedWithSentinels;
        }
    }

    @Override
    public void remove(Object key) {
        this.removeKey(key);
    }

    @Override
    public byte removeKeyIfAbsent(K key, byte value) {
        int index = this.probe(key);
        if (ObjectByteHashMap.isNonSentinel(this.keys[index]) && ObjectByteHashMap.nullSafeEquals(this.toNonSentinel(this.keys[index]), key)) {
            this.keys[index] = REMOVED_KEY;
            byte oldValue = this.values[index];
            this.values[index] = 0;
            --this.occupiedWithData;
            ++this.occupiedWithSentinels;
            return oldValue;
        }
        return value;
    }

    @Override
    public byte getIfAbsentPut(K key, byte value) {
        int index = this.probe(key);
        if (ObjectByteHashMap.isNonSentinel(this.keys[index]) && ObjectByteHashMap.nullSafeEquals(this.toNonSentinel(this.keys[index]), key)) {
            return this.values[index];
        }
        this.addKeyValueAtIndex(key, value, index);
        return value;
    }

    @Override
    public byte getAndPut(K key, byte putValue, byte defaultValue) {
        int index = this.probe(key);
        if (ObjectByteHashMap.isNonSentinel(this.keys[index]) && ObjectByteHashMap.nullSafeEquals(this.toNonSentinel(this.keys[index]), key)) {
            byte existingValue = this.values[index];
            this.values[index] = putValue;
            return existingValue;
        }
        this.addKeyValueAtIndex(key, putValue, index);
        return defaultValue;
    }

    @Override
    public byte getIfAbsentPut(K key, ByteFunction0 function) {
        int index = this.probe(key);
        if (ObjectByteHashMap.isNonSentinel(this.keys[index]) && ObjectByteHashMap.nullSafeEquals(this.toNonSentinel(this.keys[index]), key)) {
            return this.values[index];
        }
        byte value = function.value();
        this.addKeyValueAtIndex(key, value, index);
        return value;
    }

    @Override
    public <P> byte getIfAbsentPutWith(K key, ByteFunction<? super P> function, P parameter) {
        int index = this.probe(key);
        if (ObjectByteHashMap.isNonSentinel(this.keys[index]) && ObjectByteHashMap.nullSafeEquals(this.toNonSentinel(this.keys[index]), key)) {
            return this.values[index];
        }
        byte value = function.byteValueOf(parameter);
        this.addKeyValueAtIndex(key, value, index);
        return value;
    }

    @Override
    public byte getIfAbsentPutWithKey(K key, ByteFunction<? super K> function) {
        int index = this.probe(key);
        if (ObjectByteHashMap.isNonSentinel(this.keys[index]) && ObjectByteHashMap.nullSafeEquals(this.toNonSentinel(this.keys[index]), key)) {
            return this.values[index];
        }
        byte value = function.byteValueOf(key);
        this.addKeyValueAtIndex(key, value, index);
        return value;
    }

    @Override
    public byte updateValue(K key, byte initialValueIfAbsent, ByteToByteFunction function) {
        int index = this.probe(key);
        if (ObjectByteHashMap.isNonSentinel(this.keys[index]) && ObjectByteHashMap.nullSafeEquals(this.toNonSentinel(this.keys[index]), key)) {
            this.values[index] = function.valueOf(this.values[index]);
            return this.values[index];
        }
        byte value = function.valueOf(initialValueIfAbsent);
        this.addKeyValueAtIndex(key, value, index);
        return value;
    }

    private void addKeyValueAtIndex(K key, byte value, int index) {
        if (this.keys[index] == REMOVED_KEY) {
            --this.occupiedWithSentinels;
        }
        this.keys[index] = ObjectByteHashMap.toSentinelIfNull(key);
        this.values[index] = value;
        ++this.occupiedWithData;
        if (this.occupiedWithData + this.occupiedWithSentinels > this.maxOccupiedWithData()) {
            this.rehashAndGrow();
        }
    }

    @Override
    public byte addToValue(K key, byte toBeAdded) {
        int index = this.probe(key);
        if (ObjectByteHashMap.isNonSentinel(this.keys[index]) && ObjectByteHashMap.nullSafeEquals(this.toNonSentinel(this.keys[index]), key)) {
            int n = index;
            this.values[n] = (byte)(this.values[n] + toBeAdded);
            return this.values[index];
        }
        this.addKeyValueAtIndex(key, toBeAdded, index);
        return toBeAdded;
    }

    @Override
    public ObjectByteHashMap<K> withKeyValue(K key1, byte value1) {
        this.put(key1, value1);
        return this;
    }

    public ObjectByteHashMap<K> withKeysValues(K key1, byte value1, K key2, byte value2) {
        this.put(key1, value1);
        this.put(key2, value2);
        return this;
    }

    public ObjectByteHashMap<K> withKeysValues(K key1, byte value1, K key2, byte value2, K key3, byte value3) {
        this.put(key1, value1);
        this.put(key2, value2);
        this.put(key3, value3);
        return this;
    }

    public ObjectByteHashMap<K> withKeysValues(K key1, byte value1, K key2, byte value2, K key3, byte value3, K key4, byte value4) {
        this.put(key1, value1);
        this.put(key2, value2);
        this.put(key3, value3);
        this.put(key4, value4);
        return this;
    }

    @Override
    public ObjectByteHashMap<K> withoutKey(K key) {
        this.removeKey(key);
        return this;
    }

    @Override
    public ObjectByteHashMap<K> withoutAllKeys(Iterable<? extends K> keys) {
        for (K key : keys) {
            this.removeKey(key);
        }
        return this;
    }

    @Override
    public MutableObjectByteMap<K> asUnmodifiable() {
        return new UnmodifiableObjectByteMap(this);
    }

    @Override
    public MutableObjectByteMap<K> asSynchronized() {
        return new SynchronizedObjectByteMap(this);
    }

    @Override
    public ImmutableObjectByteMap<K> toImmutable() {
        return ObjectByteMaps.immutable.withAll(this);
    }

    @Override
    public byte get(Object key) {
        return this.getIfAbsent(key, (byte)0);
    }

    @Override
    public byte getOrThrow(Object key) {
        int index = this.probe(key);
        if (ObjectByteHashMap.isNonSentinel(this.keys[index])) {
            return this.values[index];
        }
        throw new IllegalStateException("Key " + key + " not present.");
    }

    @Override
    public byte getIfAbsent(Object key, byte ifAbsent) {
        int index = this.probe(key);
        if (ObjectByteHashMap.isNonSentinel(this.keys[index]) && ObjectByteHashMap.nullSafeEquals(this.toNonSentinel(this.keys[index]), key)) {
            return this.values[index];
        }
        return ifAbsent;
    }

    @Override
    public boolean containsKey(Object key) {
        int index = this.probe(key);
        return ObjectByteHashMap.isNonSentinel(this.keys[index]) && ObjectByteHashMap.nullSafeEquals(this.toNonSentinel(this.keys[index]), key);
    }

    @Override
    public boolean containsValue(byte value) {
        for (int i = 0; i < this.values.length; ++i) {
            if (!ObjectByteHashMap.isNonSentinel(this.keys[i]) || this.values[i] != value) continue;
            return true;
        }
        return false;
    }

    @Override
    public void each(ByteProcedure procedure) {
        this.forEachValue(procedure);
    }

    @Override
    public void forEachValue(ByteProcedure procedure) {
        for (int i = 0; i < this.keys.length; ++i) {
            if (!ObjectByteHashMap.isNonSentinel(this.keys[i])) continue;
            procedure.value(this.values[i]);
        }
    }

    @Override
    public void forEachKey(Procedure<? super K> procedure) {
        for (int i = 0; i < this.keys.length; ++i) {
            if (!ObjectByteHashMap.isNonSentinel(this.keys[i])) continue;
            procedure.value(this.toNonSentinel(this.keys[i]));
        }
    }

    @Override
    public void forEachKeyValue(ObjectByteProcedure<? super K> procedure) {
        for (int i = 0; i < this.keys.length; ++i) {
            if (!ObjectByteHashMap.isNonSentinel(this.keys[i])) continue;
            procedure.value(this.toNonSentinel(this.keys[i]), this.values[i]);
        }
    }

    @Override
    public ObjectByteHashMap<K> select(ObjectBytePredicate<? super K> predicate) {
        ObjectByteHashMap<K> result = ObjectByteHashMap.newMap();
        for (int i = 0; i < this.keys.length; ++i) {
            if (!ObjectByteHashMap.isNonSentinel(this.keys[i]) || !predicate.accept(this.toNonSentinel(this.keys[i]), this.values[i])) continue;
            result.put(this.toNonSentinel(this.keys[i]), this.values[i]);
        }
        return result;
    }

    @Override
    public ObjectByteHashMap<K> reject(ObjectBytePredicate<? super K> predicate) {
        ObjectByteHashMap<K> result = ObjectByteHashMap.newMap();
        for (int i = 0; i < this.keys.length; ++i) {
            if (!ObjectByteHashMap.isNonSentinel(this.keys[i]) || predicate.accept(this.toNonSentinel(this.keys[i]), this.values[i])) continue;
            result.put(this.toNonSentinel(this.keys[i]), this.values[i]);
        }
        return result;
    }

    @Override
    public MutableByteCollection select(BytePredicate predicate) {
        MutableByteList result = ByteLists.mutable.empty();
        for (int i = 0; i < this.keys.length; ++i) {
            if (!ObjectByteHashMap.isNonSentinel(this.keys[i]) || !predicate.accept(this.values[i])) continue;
            result.add(this.values[i]);
        }
        return result;
    }

    @Override
    public MutableByteCollection reject(BytePredicate predicate) {
        MutableByteList result = ByteLists.mutable.empty();
        for (int i = 0; i < this.keys.length; ++i) {
            if (!ObjectByteHashMap.isNonSentinel(this.keys[i]) || predicate.accept(this.values[i])) continue;
            result.add(this.values[i]);
        }
        return result;
    }

    @Override
    public byte detectIfNone(BytePredicate predicate, byte ifNone) {
        for (int i = 0; i < this.keys.length; ++i) {
            if (!ObjectByteHashMap.isNonSentinel(this.keys[i]) || !predicate.accept(this.values[i])) continue;
            return this.values[i];
        }
        return ifNone;
    }

    @Override
    public <V> MutableCollection<V> collect(ByteToObjectFunction<? extends V> function) {
        MutableList result = Lists.mutable.withInitialCapacity(this.size());
        for (int i = 0; i < this.keys.length; ++i) {
            if (!ObjectByteHashMap.isNonSentinel(this.keys[i])) continue;
            result.add(function.valueOf(this.values[i]));
        }
        return result;
    }

    @Override
    public int count(BytePredicate predicate) {
        int count2 = 0;
        for (int i = 0; i < this.keys.length; ++i) {
            if (!ObjectByteHashMap.isNonSentinel(this.keys[i]) || !predicate.accept(this.values[i])) continue;
            ++count2;
        }
        return count2;
    }

    @Override
    public boolean anySatisfy(BytePredicate predicate) {
        for (int i = 0; i < this.keys.length; ++i) {
            if (!ObjectByteHashMap.isNonSentinel(this.keys[i]) || !predicate.accept(this.values[i])) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean allSatisfy(BytePredicate predicate) {
        for (int i = 0; i < this.keys.length; ++i) {
            if (!ObjectByteHashMap.isNonSentinel(this.keys[i]) || predicate.accept(this.values[i])) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean noneSatisfy(BytePredicate predicate) {
        for (int i = 0; i < this.keys.length; ++i) {
            if (!ObjectByteHashMap.isNonSentinel(this.keys[i]) || !predicate.accept(this.values[i])) continue;
            return false;
        }
        return true;
    }

    public <V> V injectInto(V injectedValue, ObjectByteToObjectFunction<? super V, ? extends V> function) {
        V result = injectedValue;
        for (int i = 0; i < this.keys.length; ++i) {
            if (!ObjectByteHashMap.isNonSentinel(this.keys[i])) continue;
            result = function.valueOf(result, this.values[i]);
        }
        return result;
    }

    @Override
    public RichIterable<ByteIterable> chunk(int size2) {
        if (size2 <= 0) {
            throw new IllegalArgumentException("Size for groups must be positive but was: " + size2);
        }
        MutableList<ByteIterable> result = Lists.mutable.empty();
        if (this.notEmpty()) {
            MutableByteIterator iterator2 = this.byteIterator();
            while (iterator2.hasNext()) {
                MutableByteBag batch = ByteBags.mutable.empty();
                for (int i = 0; i < size2 && iterator2.hasNext(); ++i) {
                    batch.add(iterator2.next());
                }
                result.add(batch);
            }
        }
        return result;
    }

    @Override
    public long sum() {
        long result = 0L;
        for (int i = 0; i < this.keys.length; ++i) {
            if (!ObjectByteHashMap.isNonSentinel(this.keys[i])) continue;
            result += (long)this.values[i];
        }
        return result;
    }

    @Override
    public byte max() {
        if (this.isEmpty()) {
            throw new NoSuchElementException();
        }
        byte max2 = 0;
        boolean isMaxSet = false;
        for (int i = 0; i < this.keys.length; ++i) {
            if (!ObjectByteHashMap.isNonSentinel(this.keys[i]) || isMaxSet && max2 >= this.values[i]) continue;
            max2 = this.values[i];
            isMaxSet = true;
        }
        return max2;
    }

    @Override
    public byte min() {
        if (this.isEmpty()) {
            throw new NoSuchElementException();
        }
        byte min2 = 0;
        boolean isMinSet = false;
        for (int i = 0; i < this.keys.length; ++i) {
            if (!ObjectByteHashMap.isNonSentinel(this.keys[i]) || isMinSet && this.values[i] >= min2) continue;
            min2 = this.values[i];
            isMinSet = true;
        }
        return min2;
    }

    @Override
    public byte maxIfEmpty(byte defaultValue) {
        if (this.isEmpty()) {
            return defaultValue;
        }
        byte max2 = 0;
        boolean isMaxSet = false;
        for (int i = 0; i < this.keys.length; ++i) {
            if (!ObjectByteHashMap.isNonSentinel(this.keys[i]) || isMaxSet && max2 >= this.values[i]) continue;
            max2 = this.values[i];
            isMaxSet = true;
        }
        return max2;
    }

    @Override
    public byte minIfEmpty(byte defaultValue) {
        if (this.isEmpty()) {
            return defaultValue;
        }
        byte min2 = 0;
        boolean isMinSet = false;
        for (int i = 0; i < this.keys.length; ++i) {
            if (!ObjectByteHashMap.isNonSentinel(this.keys[i]) || isMinSet && this.values[i] >= min2) continue;
            min2 = this.values[i];
            isMinSet = true;
        }
        return min2;
    }

    @Override
    public double average() {
        if (this.isEmpty()) {
            throw new ArithmeticException();
        }
        return (double)this.sum() / (double)this.size();
    }

    @Override
    public double median() {
        if (this.isEmpty()) {
            throw new ArithmeticException();
        }
        byte[] sortedArray = this.toSortedArray();
        int middleIndex = sortedArray.length >> 1;
        if (sortedArray.length > 1 && (sortedArray.length & 1) == 0) {
            byte first = sortedArray[middleIndex];
            byte second = sortedArray[middleIndex - 1];
            return ((double)first + (double)second) / 2.0;
        }
        return sortedArray[middleIndex];
    }

    @Override
    public MutableByteList toList() {
        MutableByteList result = ByteLists.mutable.withInitialCapacity(this.size());
        for (int i = 0; i < this.keys.length; ++i) {
            if (!ObjectByteHashMap.isNonSentinel(this.keys[i])) continue;
            result.add(this.values[i]);
        }
        return result;
    }

    @Override
    public MutableByteSet toSet() {
        MutableByteSet result = ByteSets.mutable.empty();
        for (int i = 0; i < this.keys.length; ++i) {
            if (!ObjectByteHashMap.isNonSentinel(this.keys[i])) continue;
            result.add(this.values[i]);
        }
        return result;
    }

    @Override
    public MutableByteBag toBag() {
        MutableByteBag result = ByteBags.mutable.empty();
        for (int i = 0; i < this.keys.length; ++i) {
            if (!ObjectByteHashMap.isNonSentinel(this.keys[i])) continue;
            result.add(this.values[i]);
        }
        return result;
    }

    @Override
    public LazyByteIterable asLazy() {
        return new LazyByteIterableAdapter(this);
    }

    @Override
    public byte[] toSortedArray() {
        byte[] array = this.toArray();
        Arrays.sort(array);
        return array;
    }

    @Override
    public MutableByteList toSortedList() {
        return this.toList().sortThis();
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeInt(this.size());
        for (int i = 0; i < this.keys.length; ++i) {
            if (!ObjectByteHashMap.isNonSentinel(this.keys[i])) continue;
            out.writeObject(this.toNonSentinel(this.keys[i]));
            out.writeByte(this.values[i]);
        }
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        int size2 = in.readInt();
        int capacity = this.smallestPowerOfTwoGreaterThan(this.fastCeil(size2 << 1));
        this.allocateTable(capacity);
        for (int i = 0; i < size2; ++i) {
            this.put(in.readObject(), in.readByte());
        }
    }

    @Override
    public LazyIterable<K> keysView() {
        return new KeysView();
    }

    @Override
    public RichIterable<ObjectBytePair<K>> keyValuesView() {
        return new KeyValuesView();
    }

    @Override
    public MutableByteObjectMap<K> flipUniqueValues() {
        MutableByteObjectMap result = ByteObjectMaps.mutable.empty();
        this.forEachKeyValue((key, value) -> {
            Object oldKey = result.put(value, key);
            if (oldKey != null) {
                throw new IllegalStateException("Duplicate value: " + value + " found at key: " + oldKey + " and key: " + key);
            }
        });
        return result;
    }

    public void compact() {
        this.rehash(this.smallestPowerOfTwoGreaterThan(this.size()));
    }

    private void rehashAndGrow() {
        int max2 = this.maxOccupiedWithData();
        int newCapacity = Math.max(max2, this.smallestPowerOfTwoGreaterThan(this.occupiedWithData + 1 << 1));
        if (this.occupiedWithSentinels > 0 && (max2 >> 1) + (max2 >> 2) < this.occupiedWithData) {
            newCapacity <<= 1;
        }
        this.rehash(newCapacity);
    }

    private void rehash(int newCapacity) {
        int oldLength = this.keys.length;
        Object[] old = this.keys;
        byte[] oldValues = this.values;
        this.allocateTable(newCapacity);
        this.occupiedWithData = 0;
        this.occupiedWithSentinels = 0;
        for (int i = 0; i < oldLength; ++i) {
            if (!ObjectByteHashMap.isNonSentinel(old[i])) continue;
            this.put(this.toNonSentinel(old[i]), oldValues[i]);
        }
    }

    int probe(Object element) {
        int index = this.spread(element);
        int removedIndex = -1;
        if (ObjectByteHashMap.isRemovedKey(this.keys[index])) {
            removedIndex = index;
        } else if (this.keys[index] == null || ObjectByteHashMap.nullSafeEquals(this.toNonSentinel(this.keys[index]), element)) {
            return index;
        }
        int nextIndex = index;
        int probe = 17;
        while (true) {
            nextIndex += probe;
            probe += 17;
            if (ObjectByteHashMap.isRemovedKey(this.keys[nextIndex &= this.keys.length - 1])) {
                if (removedIndex != -1) continue;
                removedIndex = nextIndex;
                continue;
            }
            if (ObjectByteHashMap.nullSafeEquals(this.toNonSentinel(this.keys[nextIndex]), element)) {
                return nextIndex;
            }
            if (this.keys[nextIndex] == null) break;
        }
        return removedIndex == -1 ? nextIndex : removedIndex;
    }

    int spread(Object element) {
        int h = element == null ? 0 : element.hashCode();
        h ^= h >>> 20 ^ h >>> 12;
        h ^= h >>> 7 ^ h >>> 4;
        return h & this.keys.length - 1;
    }

    private static boolean nullSafeEquals(Object value, Object other) {
        return value == null ? other == null : other == value || value.equals(other);
    }

    protected void allocateTable(int sizeToAllocate) {
        this.keys = new Object[sizeToAllocate];
        this.values = new byte[sizeToAllocate];
    }

    private static boolean isRemovedKey(Object key) {
        return key == REMOVED_KEY;
    }

    private static <K> boolean isNonSentinel(K key) {
        return key != null && !ObjectByteHashMap.isRemovedKey(key);
    }

    private K toNonSentinel(Object key) {
        return (K)(key == NULL_KEY ? null : key);
    }

    private static Object toSentinelIfNull(Object key) {
        return key == null ? NULL_KEY : key;
    }

    private int maxOccupiedWithData() {
        int capacity = this.keys.length;
        return Math.min(capacity - 1, capacity >> 1);
    }

    @Override
    public Set<K> keySet() {
        return new KeySet();
    }

    @Override
    public MutableByteCollection values() {
        return new ValuesCollection();
    }

    static /* synthetic */ Object[] access$302(ObjectByteHashMap x0, Object[] x1) {
        x0.keys = x1;
        return x1;
    }

    static /* synthetic */ byte[] access$502(ObjectByteHashMap x0, byte[] x1) {
        x0.values = x1;
        return x1;
    }

    private class KeyValuesView
    extends AbstractLazyIterable<ObjectBytePair<K>> {
        private KeyValuesView() {
        }

        @Override
        public void each(Procedure<? super ObjectBytePair<K>> procedure) {
            for (int i = 0; i < ObjectByteHashMap.this.keys.length; ++i) {
                if (!ObjectByteHashMap.isNonSentinel(ObjectByteHashMap.this.keys[i])) continue;
                procedure.value(PrimitiveTuples.pair(ObjectByteHashMap.this.toNonSentinel(ObjectByteHashMap.this.keys[i]), ObjectByteHashMap.this.values[i]));
            }
        }

        @Override
        public void forEachWithIndex(ObjectIntProcedure<? super ObjectBytePair<K>> objectIntProcedure) {
            int index = 0;
            for (int i = 0; i < ObjectByteHashMap.this.keys.length; ++i) {
                if (!ObjectByteHashMap.isNonSentinel(ObjectByteHashMap.this.keys[i])) continue;
                objectIntProcedure.value(PrimitiveTuples.pair(ObjectByteHashMap.this.toNonSentinel(ObjectByteHashMap.this.keys[i]), ObjectByteHashMap.this.values[i]), index);
                ++index;
            }
        }

        @Override
        public <P> void forEachWith(Procedure2<? super ObjectBytePair<K>, ? super P> procedure, P parameter) {
            for (int i = 0; i < ObjectByteHashMap.this.keys.length; ++i) {
                if (!ObjectByteHashMap.isNonSentinel(ObjectByteHashMap.this.keys[i])) continue;
                procedure.value(PrimitiveTuples.pair(ObjectByteHashMap.this.toNonSentinel(ObjectByteHashMap.this.keys[i]), ObjectByteHashMap.this.values[i]), parameter);
            }
        }

        @Override
        public Iterator<ObjectBytePair<K>> iterator() {
            return new InternalKeyValuesIterator();
        }

        public class InternalKeyValuesIterator
        implements Iterator<ObjectBytePair<K>> {
            private int count;
            private int position;

            @Override
            public ObjectBytePair<K> next() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                Object[] keys = ObjectByteHashMap.this.keys;
                while (!ObjectByteHashMap.isNonSentinel(keys[this.position])) {
                    ++this.position;
                }
                ObjectBytePair<Object> result = PrimitiveTuples.pair(ObjectByteHashMap.this.toNonSentinel(ObjectByteHashMap.this.keys[this.position]), ObjectByteHashMap.this.values[this.position]);
                ++this.count;
                ++this.position;
                return result;
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException("Cannot call remove() on " + this.getClass().getSimpleName());
            }

            @Override
            public boolean hasNext() {
                return this.count != ObjectByteHashMap.this.size();
            }
        }
    }

    private class KeysView
    extends AbstractLazyIterable<K> {
        private KeysView() {
        }

        @Override
        public void each(Procedure<? super K> procedure) {
            ObjectByteHashMap.this.forEachKey(procedure);
        }

        @Override
        public void forEachWithIndex(ObjectIntProcedure<? super K> objectByteProcedure) {
            int index = 0;
            for (int i = 0; i < ObjectByteHashMap.this.keys.length; ++i) {
                if (!ObjectByteHashMap.isNonSentinel(ObjectByteHashMap.this.keys[i])) continue;
                objectByteProcedure.value(ObjectByteHashMap.this.toNonSentinel(ObjectByteHashMap.this.keys[i]), index);
                ++index;
            }
        }

        @Override
        public <P> void forEachWith(Procedure2<? super K, ? super P> procedure, P parameter) {
            for (int i = 0; i < ObjectByteHashMap.this.keys.length; ++i) {
                if (!ObjectByteHashMap.isNonSentinel(ObjectByteHashMap.this.keys[i])) continue;
                procedure.value(ObjectByteHashMap.this.toNonSentinel(ObjectByteHashMap.this.keys[i]), parameter);
            }
        }

        @Override
        public Iterator<K> iterator() {
            return new InternalKeysViewIterator();
        }

        public class InternalKeysViewIterator
        implements Iterator<K> {
            private int count;
            private int position;

            @Override
            public K next() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                Object[] keys = ObjectByteHashMap.this.keys;
                while (!ObjectByteHashMap.isNonSentinel(keys[this.position])) {
                    ++this.position;
                }
                Object result = ObjectByteHashMap.this.toNonSentinel(ObjectByteHashMap.this.keys[this.position]);
                ++this.count;
                ++this.position;
                return result;
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException("Cannot call remove() on " + this.getClass().getSimpleName());
            }

            @Override
            public boolean hasNext() {
                return this.count != ObjectByteHashMap.this.size();
            }
        }
    }

    private class ValuesCollection
    implements MutableByteCollection {
        private ValuesCollection() {
        }

        @Override
        public int size() {
            return ObjectByteHashMap.this.size();
        }

        @Override
        public boolean isEmpty() {
            return ObjectByteHashMap.this.isEmpty();
        }

        @Override
        public boolean notEmpty() {
            return ObjectByteHashMap.this.notEmpty();
        }

        @Override
        public String makeString() {
            return this.makeString(", ");
        }

        @Override
        public String makeString(String separator) {
            return this.makeString("", separator, "");
        }

        @Override
        public String makeString(String start, String separator, String end) {
            StringBuilder stringBuilder = new StringBuilder();
            this.appendString(stringBuilder, start, separator, end);
            return ((Object)stringBuilder).toString();
        }

        @Override
        public void appendString(Appendable appendable) {
            this.appendString(appendable, ", ");
        }

        @Override
        public void appendString(Appendable appendable, String separator) {
            this.appendString(appendable, "", separator, "");
        }

        @Override
        public void appendString(Appendable appendable, String start, String separator, String end) {
            try {
                appendable.append(start);
                boolean first = true;
                for (int i = 0; i < ObjectByteHashMap.this.keys.length; ++i) {
                    Object key = ObjectByteHashMap.this.keys[i];
                    if (!ObjectByteHashMap.isNonSentinel(key)) continue;
                    if (!first) {
                        appendable.append(separator);
                    }
                    appendable.append(String.valueOf(ObjectByteHashMap.this.values[i]));
                    first = false;
                }
                appendable.append(end);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }

        @Override
        public boolean add(byte element) {
            throw new UnsupportedOperationException("Cannot call add() on " + this.getClass().getSimpleName());
        }

        @Override
        public boolean addAll(byte ... source) {
            throw new UnsupportedOperationException("Cannot call addAll() on " + this.getClass().getSimpleName());
        }

        @Override
        public boolean addAll(ByteIterable source) {
            throw new UnsupportedOperationException("Cannot call addAll() on " + this.getClass().getSimpleName());
        }

        @Override
        public boolean remove(byte item) {
            int oldSize = ObjectByteHashMap.this.size();
            for (int i = 0; i < ObjectByteHashMap.this.keys.length; ++i) {
                if (!ObjectByteHashMap.isNonSentinel(ObjectByteHashMap.this.keys[i]) || item != ObjectByteHashMap.this.values[i]) continue;
                ObjectByteHashMap.this.removeKey(ObjectByteHashMap.this.keys[i]);
            }
            return oldSize != ObjectByteHashMap.this.size();
        }

        @Override
        public boolean removeAll(ByteIterable source) {
            int oldSize = ObjectByteHashMap.this.size();
            ByteIterator iterator2 = source.byteIterator();
            while (iterator2.hasNext()) {
                this.remove(iterator2.next());
            }
            return oldSize != ObjectByteHashMap.this.size();
        }

        @Override
        public boolean removeAll(byte ... source) {
            int oldSize = ObjectByteHashMap.this.size();
            for (byte item : source) {
                this.remove(item);
            }
            return oldSize != ObjectByteHashMap.this.size();
        }

        @Override
        public boolean retainAll(ByteIterable source) {
            int oldSize = ObjectByteHashMap.this.size();
            ByteSet sourceSet = source instanceof ByteSet ? (ByteSet)source : source.toSet();
            MutableObjectByteMap retained = ObjectByteHashMap.this.select((T object, byte value) -> sourceSet.contains(value));
            if (((ObjectByteHashMap)retained).size() != oldSize) {
                ObjectByteHashMap.access$302(ObjectByteHashMap.this, ((ObjectByteHashMap)retained).keys);
                ObjectByteHashMap.access$502(ObjectByteHashMap.this, ((ObjectByteHashMap)retained).values);
                ObjectByteHashMap.this.occupiedWithData = ((ObjectByteHashMap)retained).occupiedWithData;
                ObjectByteHashMap.this.occupiedWithSentinels = ((ObjectByteHashMap)retained).occupiedWithSentinels;
                return true;
            }
            return false;
        }

        @Override
        public boolean retainAll(byte ... source) {
            return this.retainAll(ByteSets.mutable.with(source));
        }

        @Override
        public void clear() {
            ObjectByteHashMap.this.clear();
        }

        @Override
        public MutableByteCollection with(byte element) {
            throw new UnsupportedOperationException("Cannot call with() on " + this.getClass().getSimpleName());
        }

        @Override
        public MutableByteCollection without(byte element) {
            throw new UnsupportedOperationException("Cannot call without() on " + this.getClass().getSimpleName());
        }

        @Override
        public MutableByteCollection withAll(ByteIterable elements) {
            throw new UnsupportedOperationException("Cannot call withAll() on " + this.getClass().getSimpleName());
        }

        @Override
        public MutableByteCollection withoutAll(ByteIterable elements) {
            throw new UnsupportedOperationException("Cannot call withoutAll() on " + this.getClass().getSimpleName());
        }

        @Override
        public MutableByteCollection asUnmodifiable() {
            return UnmodifiableByteCollection.of(this);
        }

        @Override
        public MutableByteCollection asSynchronized() {
            return SynchronizedByteCollection.of(this);
        }

        @Override
        public ImmutableByteCollection toImmutable() {
            return ByteLists.immutable.withAll(this);
        }

        @Override
        public MutableByteIterator byteIterator() {
            return ObjectByteHashMap.this.byteIterator();
        }

        @Override
        public byte[] toArray() {
            return ObjectByteHashMap.this.toArray();
        }

        @Override
        public byte[] toArray(byte[] target) {
            return ObjectByteHashMap.this.toArray(target);
        }

        @Override
        public boolean contains(byte value) {
            return ObjectByteHashMap.this.containsValue(value);
        }

        @Override
        public boolean containsAll(byte ... source) {
            return ObjectByteHashMap.this.containsAll(source);
        }

        @Override
        public boolean containsAll(ByteIterable source) {
            return ObjectByteHashMap.this.containsAll(source);
        }

        @Override
        public void each(ByteProcedure procedure) {
            ObjectByteHashMap.this.forEach(procedure);
        }

        @Override
        public MutableByteCollection select(BytePredicate predicate) {
            return ObjectByteHashMap.this.select(predicate);
        }

        @Override
        public MutableByteCollection reject(BytePredicate predicate) {
            return ObjectByteHashMap.this.reject(predicate);
        }

        @Override
        public <V> MutableCollection<V> collect(ByteToObjectFunction<? extends V> function) {
            return ObjectByteHashMap.this.collect((ByteToObjectFunction)function);
        }

        @Override
        public <T> T injectInto(T injectedValue, ObjectByteToObjectFunction<? super T, ? extends T> function) {
            return ObjectByteHashMap.this.injectInto(injectedValue, function);
        }

        @Override
        public RichIterable<ByteIterable> chunk(int size2) {
            return ObjectByteHashMap.this.chunk(size2);
        }

        @Override
        public byte detectIfNone(BytePredicate predicate, byte ifNone) {
            return ObjectByteHashMap.this.detectIfNone(predicate, ifNone);
        }

        @Override
        public int count(BytePredicate predicate) {
            return ObjectByteHashMap.this.count(predicate);
        }

        @Override
        public boolean anySatisfy(BytePredicate predicate) {
            return ObjectByteHashMap.this.anySatisfy(predicate);
        }

        @Override
        public boolean allSatisfy(BytePredicate predicate) {
            return ObjectByteHashMap.this.allSatisfy(predicate);
        }

        @Override
        public boolean noneSatisfy(BytePredicate predicate) {
            return ObjectByteHashMap.this.noneSatisfy(predicate);
        }

        @Override
        public MutableByteList toList() {
            return ObjectByteHashMap.this.toList();
        }

        @Override
        public MutableByteSet toSet() {
            return ObjectByteHashMap.this.toSet();
        }

        @Override
        public MutableByteBag toBag() {
            return ObjectByteHashMap.this.toBag();
        }

        @Override
        public LazyByteIterable asLazy() {
            return new LazyByteIterableAdapter(this);
        }

        @Override
        public byte[] toSortedArray() {
            return ObjectByteHashMap.this.toSortedArray();
        }

        @Override
        public MutableByteList toSortedList() {
            return ObjectByteHashMap.this.toSortedList();
        }

        @Override
        public long sum() {
            return ObjectByteHashMap.this.sum();
        }

        @Override
        public byte max() {
            return ObjectByteHashMap.this.max();
        }

        @Override
        public byte maxIfEmpty(byte defaultValue) {
            return ObjectByteHashMap.this.maxIfEmpty(defaultValue);
        }

        @Override
        public byte min() {
            return ObjectByteHashMap.this.min();
        }

        @Override
        public byte minIfEmpty(byte defaultValue) {
            return ObjectByteHashMap.this.minIfEmpty(defaultValue);
        }

        @Override
        public double average() {
            return ObjectByteHashMap.this.average();
        }

        @Override
        public double median() {
            return ObjectByteHashMap.this.median();
        }

        @Override
        public MutableByteCollection newEmpty() {
            return ByteBags.mutable.empty();
        }
    }

    private class KeySetIterator
    implements Iterator<K> {
        private int count;
        private int position;
        private K currentKey;
        private boolean isCurrentKeySet;

        private KeySetIterator() {
        }

        @Override
        public boolean hasNext() {
            return this.count < ObjectByteHashMap.this.size();
        }

        @Override
        public K next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            ++this.count;
            Object[] keys = ObjectByteHashMap.this.keys;
            while (!ObjectByteHashMap.isNonSentinel(keys[this.position])) {
                ++this.position;
            }
            this.currentKey = ObjectByteHashMap.this.keys[this.position];
            this.isCurrentKeySet = true;
            ++this.position;
            return ObjectByteHashMap.this.toNonSentinel(this.currentKey);
        }

        @Override
        public void remove() {
            if (!this.isCurrentKeySet) {
                throw new IllegalStateException();
            }
            this.isCurrentKeySet = false;
            --this.count;
            if (ObjectByteHashMap.isNonSentinel(this.currentKey)) {
                int index = this.position - 1;
                ObjectByteHashMap.this.removeKeyAtIndex(ObjectByteHashMap.this.toNonSentinel(this.currentKey), index);
            } else {
                ObjectByteHashMap.this.removeKey(this.currentKey);
            }
        }
    }

    private class KeySet
    implements Set<K> {
        private KeySet() {
        }

        @Override
        public boolean equals(Object obj) {
            Set other;
            if (obj instanceof Set && (other = (Set)obj).size() == this.size()) {
                return this.containsAll(other);
            }
            return false;
        }

        @Override
        public int hashCode() {
            int hashCode2 = 0;
            Object[] table = ObjectByteHashMap.this.keys;
            for (int i = 0; i < table.length; ++i) {
                Object key = table[i];
                if (!ObjectByteHashMap.isNonSentinel(key)) continue;
                Object nonSentinelKey = ObjectByteHashMap.this.toNonSentinel(key);
                hashCode2 += nonSentinelKey == null ? 0 : nonSentinelKey.hashCode();
            }
            return hashCode2;
        }

        @Override
        public int size() {
            return ObjectByteHashMap.this.size();
        }

        @Override
        public boolean isEmpty() {
            return ObjectByteHashMap.this.isEmpty();
        }

        @Override
        public boolean contains(Object o) {
            return ObjectByteHashMap.this.containsKey(o);
        }

        @Override
        public Object[] toArray() {
            int size2 = ObjectByteHashMap.this.size();
            Object[] result = new Object[size2];
            this.copyKeys(result);
            return result;
        }

        @Override
        public <T> T[] toArray(T[] result) {
            int size2 = ObjectByteHashMap.this.size();
            if (result.length < size2) {
                result = (Object[])Array.newInstance(result.getClass().getComponentType(), size2);
            }
            this.copyKeys(result);
            if (size2 < result.length) {
                result[size2] = null;
            }
            return result;
        }

        @Override
        public boolean add(K key) {
            throw new UnsupportedOperationException("Cannot call add() on " + this.getClass().getSimpleName());
        }

        @Override
        public boolean remove(Object key) {
            int oldSize = ObjectByteHashMap.this.size();
            ObjectByteHashMap.this.removeKey(key);
            return oldSize != ObjectByteHashMap.this.size();
        }

        @Override
        public boolean containsAll(Collection<?> collection) {
            for (Object aCollection : collection) {
                if (ObjectByteHashMap.this.containsKey(aCollection)) continue;
                return false;
            }
            return true;
        }

        @Override
        public boolean addAll(Collection<? extends K> collection) {
            throw new UnsupportedOperationException("Cannot call addAll() on " + this.getClass().getSimpleName());
        }

        @Override
        public boolean retainAll(Collection<?> collection) {
            int oldSize = ObjectByteHashMap.this.size();
            Iterator iterator2 = this.iterator();
            while (iterator2.hasNext()) {
                Object next = iterator2.next();
                if (collection.contains(next)) continue;
                iterator2.remove();
            }
            return oldSize != ObjectByteHashMap.this.size();
        }

        @Override
        public boolean removeAll(Collection<?> collection) {
            int oldSize = ObjectByteHashMap.this.size();
            for (Object object : collection) {
                ObjectByteHashMap.this.removeKey(object);
            }
            return oldSize != ObjectByteHashMap.this.size();
        }

        @Override
        public void clear() {
            ObjectByteHashMap.this.clear();
        }

        @Override
        public Iterator<K> iterator() {
            return new KeySetIterator();
        }

        private void copyKeys(Object[] result) {
            int count2 = 0;
            for (int i = 0; i < ObjectByteHashMap.this.keys.length; ++i) {
                Object key = ObjectByteHashMap.this.keys[i];
                if (!ObjectByteHashMap.isNonSentinel(key)) continue;
                result[count2++] = ObjectByteHashMap.this.keys[i];
            }
        }
    }

    private class InternalByteIterator
    implements MutableByteIterator {
        private int count;
        private int position;

        private InternalByteIterator() {
        }

        @Override
        public boolean hasNext() {
            return this.count != ObjectByteHashMap.this.size();
        }

        @Override
        public byte next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            Object[] keys = ObjectByteHashMap.this.keys;
            while (!ObjectByteHashMap.isNonSentinel(keys[this.position])) {
                ++this.position;
            }
            byte result = ObjectByteHashMap.this.values[this.position];
            ++this.count;
            ++this.position;
            return result;
        }

        @Override
        public void remove() {
            if (this.position == 0 || !ObjectByteHashMap.isNonSentinel(ObjectByteHashMap.this.keys[this.position - 1])) {
                throw new IllegalStateException();
            }
            ObjectByteHashMap.this.remove(ObjectByteHashMap.this.keys[this.position - 1]);
            --this.count;
        }
    }
}

