/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.collections.impl.map.mutable.primitive;

import java.io.IOException;
import java.io.Serializable;
import java.util.NoSuchElementException;
import org.eclipse.collections.api.block.function.primitive.CharToObjectFunction;
import org.eclipse.collections.api.block.function.primitive.ObjectCharToObjectFunction;
import org.eclipse.collections.api.block.predicate.primitive.CharPredicate;
import org.eclipse.collections.api.block.procedure.primitive.CharProcedure;
import org.eclipse.collections.api.iterator.CharIterator;
import org.eclipse.collections.api.set.ImmutableSet;
import org.eclipse.collections.api.set.primitive.ImmutableCharSet;
import org.eclipse.collections.impl.SpreadFunctions;
import org.eclipse.collections.impl.set.immutable.primitive.AbstractImmutableCharSet;
import org.eclipse.collections.impl.set.immutable.primitive.ImmutableCharSetSerializationProxy;
import org.eclipse.collections.impl.set.mutable.UnifiedSet;
import org.eclipse.collections.impl.set.mutable.primitive.CharHashSet;

class ImmutableCharMapKeySet
extends AbstractImmutableCharSet
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final char EMPTY_KEY = '\u0000';
    private static final char REMOVED_KEY = '\u0001';
    private static final int CACHE_LINE_SIZE = 64;
    private static final int KEY_SIZE = 2;
    private static final int INITIAL_LINEAR_PROBE = 16;
    private final char[] keys;
    private final int occupiedWithData;
    private final boolean containsZeroKey;
    private final boolean containsOneKey;

    ImmutableCharMapKeySet(char[] keys, int occupiedWithData, boolean containsZeroKey, boolean containsOneKey) {
        this.keys = keys;
        this.occupiedWithData = occupiedWithData;
        this.containsZeroKey = containsZeroKey;
        this.containsOneKey = containsOneKey;
    }

    private static boolean isEmptyKey(char key) {
        return key == '\u0000';
    }

    private static boolean isRemovedKey(char key) {
        return key == '\u0001';
    }

    private static boolean isNonSentinel(char key) {
        return !ImmutableCharMapKeySet.isEmptyKey(key) && !ImmutableCharMapKeySet.isRemovedKey(key);
    }

    @Override
    public int hashCode() {
        int result = 0;
        if (this.containsZeroKey) {
            result += 0;
        }
        if (this.containsOneKey) {
            ++result;
        }
        if (this.keys != null) {
            for (int i = 0; i < this.keys.length; ++i) {
                if (!ImmutableCharMapKeySet.isNonSentinel(this.keys[i])) continue;
                result += this.keys[i];
            }
        }
        return result;
    }

    @Override
    public int size() {
        return this.occupiedWithData + (this.containsOneKey ? 1 : 0) + (this.containsZeroKey ? 1 : 0);
    }

    @Override
    public void appendString(Appendable appendable, String start, String separator, String end) {
        try {
            appendable.append(start);
            int count2 = 0;
            if (this.containsZeroKey) {
                appendable.append(String.valueOf('\u0000'));
                ++count2;
            }
            if (this.containsOneKey) {
                if (count2 > 0) {
                    appendable.append(separator);
                }
                ++count2;
                appendable.append(String.valueOf('\u0001'));
            }
            for (int i = 0; i < this.keys.length; ++i) {
                if (!ImmutableCharMapKeySet.isNonSentinel(this.keys[i])) continue;
                if (count2 > 0) {
                    appendable.append(separator);
                }
                ++count2;
                appendable.append(String.valueOf(this.keys[i]));
            }
            appendable.append(end);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public CharIterator charIterator() {
        return new InternalCharIterator();
    }

    @Override
    public char[] toArray() {
        char[] array = new char[this.size()];
        int index = 0;
        if (this.containsZeroKey) {
            array[index] = '\u0000';
            ++index;
        }
        if (this.containsOneKey) {
            array[index] = '\u0001';
            ++index;
        }
        if (this.keys != null) {
            for (int i = 0; i < this.keys.length; ++i) {
                if (!ImmutableCharMapKeySet.isNonSentinel(this.keys[i])) continue;
                array[index] = this.keys[i];
                ++index;
            }
        }
        return array;
    }

    @Override
    public char[] toArray(char[] array) {
        if (array.length < this.size()) {
            array = new char[this.size()];
        }
        int index = 0;
        if (this.containsZeroKey) {
            array[index] = '\u0000';
            ++index;
        }
        if (this.containsOneKey) {
            array[index] = '\u0001';
            ++index;
        }
        if (this.keys != null) {
            for (int i = 0; i < this.keys.length; ++i) {
                if (!ImmutableCharMapKeySet.isNonSentinel(this.keys[i])) continue;
                array[index] = this.keys[i];
                ++index;
            }
        }
        return array;
    }

    @Override
    public boolean contains(char value) {
        if (value == '\u0000') {
            return this.containsZeroKey;
        }
        if (value == '\u0001') {
            return this.containsOneKey;
        }
        return this.keys[this.probe(value)] == value;
    }

    @Override
    public void forEach(CharProcedure procedure) {
        this.each(procedure);
    }

    @Override
    public void each(CharProcedure procedure) {
        if (this.containsZeroKey) {
            procedure.value('\u0000');
        }
        if (this.containsOneKey) {
            procedure.value('\u0001');
        }
        if (this.keys != null) {
            for (int i = 0; i < this.keys.length; ++i) {
                if (!ImmutableCharMapKeySet.isNonSentinel(this.keys[i])) continue;
                procedure.value(this.keys[i]);
            }
        }
    }

    @Override
    public ImmutableCharSet select(CharPredicate predicate) {
        CharHashSet result = new CharHashSet();
        if (this.containsZeroKey && predicate.accept('\u0000')) {
            result.add('\u0000');
        }
        if (this.containsOneKey && predicate.accept('\u0001')) {
            result.add('\u0001');
        }
        for (int i = 0; i < this.keys.length; ++i) {
            if (!ImmutableCharMapKeySet.isNonSentinel(this.keys[i]) || !predicate.accept(this.keys[i])) continue;
            result.add(this.keys[i]);
        }
        return result.toImmutable();
    }

    @Override
    public ImmutableCharSet reject(CharPredicate predicate) {
        CharHashSet result = new CharHashSet();
        if (this.containsZeroKey && !predicate.accept('\u0000')) {
            result.add('\u0000');
        }
        if (this.containsOneKey && !predicate.accept('\u0001')) {
            result.add('\u0001');
        }
        for (int i = 0; i < this.keys.length; ++i) {
            if (!ImmutableCharMapKeySet.isNonSentinel(this.keys[i]) || predicate.accept(this.keys[i])) continue;
            result.add(this.keys[i]);
        }
        return result.toImmutable();
    }

    @Override
    public <V> ImmutableSet<V> collect(CharToObjectFunction<? extends V> function) {
        UnifiedSet target = UnifiedSet.newSet(this.size());
        if (this.containsZeroKey) {
            target.add(function.valueOf('\u0000'));
        }
        if (this.containsOneKey) {
            target.add(function.valueOf('\u0001'));
        }
        if (this.keys != null) {
            for (int i = 0; i < this.keys.length; ++i) {
                if (!ImmutableCharMapKeySet.isNonSentinel(this.keys[i])) continue;
                target.add(function.valueOf(this.keys[i]));
            }
        }
        return target.toImmutable();
    }

    @Override
    public char detectIfNone(CharPredicate predicate, char ifNone) {
        if (this.containsZeroKey && predicate.accept('\u0000')) {
            return '\u0000';
        }
        if (this.containsOneKey && predicate.accept('\u0001')) {
            return '\u0001';
        }
        for (int i = 0; i < this.keys.length; ++i) {
            if (!ImmutableCharMapKeySet.isNonSentinel(this.keys[i]) || !predicate.accept(this.keys[i])) continue;
            return this.keys[i];
        }
        return ifNone;
    }

    @Override
    public int count(CharPredicate predicate) {
        int count2 = 0;
        if (this.containsZeroKey && predicate.accept('\u0000')) {
            ++count2;
        }
        if (this.containsOneKey && predicate.accept('\u0001')) {
            ++count2;
        }
        for (int i = 0; i < this.keys.length; ++i) {
            if (!ImmutableCharMapKeySet.isNonSentinel(this.keys[i]) || !predicate.accept(this.keys[i])) continue;
            ++count2;
        }
        return count2;
    }

    @Override
    public boolean anySatisfy(CharPredicate predicate) {
        if (this.containsZeroKey && predicate.accept('\u0000')) {
            return true;
        }
        if (this.containsOneKey && predicate.accept('\u0001')) {
            return true;
        }
        for (int i = 0; i < this.keys.length; ++i) {
            if (!ImmutableCharMapKeySet.isNonSentinel(this.keys[i]) || !predicate.accept(this.keys[i])) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean allSatisfy(CharPredicate predicate) {
        if (this.containsZeroKey && !predicate.accept('\u0000')) {
            return false;
        }
        if (this.containsOneKey && !predicate.accept('\u0001')) {
            return false;
        }
        for (int i = 0; i < this.keys.length; ++i) {
            if (!ImmutableCharMapKeySet.isNonSentinel(this.keys[i]) || predicate.accept(this.keys[i])) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean noneSatisfy(CharPredicate predicate) {
        if (this.containsZeroKey && predicate.accept('\u0000')) {
            return false;
        }
        if (this.containsOneKey && predicate.accept('\u0001')) {
            return false;
        }
        for (int i = 0; i < this.keys.length; ++i) {
            if (!ImmutableCharMapKeySet.isNonSentinel(this.keys[i]) || !predicate.accept(this.keys[i])) continue;
            return false;
        }
        return true;
    }

    @Override
    public long sum() {
        long nextSum;
        long adjustedValue;
        long result = 0L;
        long compensation = 0L;
        if (this.containsZeroKey) {
            adjustedValue = 0L - compensation;
            nextSum = result + adjustedValue;
            compensation = nextSum - result - adjustedValue;
            result = nextSum;
        }
        if (this.containsOneKey) {
            adjustedValue = 1L - compensation;
            nextSum = result + adjustedValue;
            compensation = nextSum - result - adjustedValue;
            result = nextSum;
        }
        if (this.keys != null) {
            for (int i = 0; i < this.keys.length; ++i) {
                if (!ImmutableCharMapKeySet.isNonSentinel(this.keys[i])) continue;
                long adjustedValue2 = (long)this.keys[i] - compensation;
                long nextSum2 = result + adjustedValue2;
                compensation = nextSum2 - result - adjustedValue2;
                result = nextSum2;
            }
        }
        return result;
    }

    @Override
    public char max() {
        if (this.isEmpty()) {
            throw new NoSuchElementException();
        }
        char max2 = '\u0000';
        boolean isMaxSet = false;
        if (this.containsZeroKey) {
            max2 = '\u0000';
            isMaxSet = true;
        }
        if (this.containsOneKey && (!isMaxSet || max2 < '\u0001')) {
            max2 = '\u0001';
            isMaxSet = true;
        }
        for (int i = 0; i < this.keys.length; ++i) {
            if (!ImmutableCharMapKeySet.isNonSentinel(this.keys[i]) || isMaxSet && max2 >= this.keys[i]) continue;
            max2 = this.keys[i];
            isMaxSet = true;
        }
        return max2;
    }

    @Override
    public char min() {
        if (this.isEmpty()) {
            throw new NoSuchElementException();
        }
        char min2 = '\u0000';
        boolean isMinSet = false;
        if (this.containsZeroKey) {
            min2 = '\u0000';
            isMinSet = true;
        }
        if (this.containsOneKey && (!isMinSet || '\u0001' < min2)) {
            min2 = '\u0001';
            isMinSet = true;
        }
        for (int i = 0; i < this.keys.length; ++i) {
            if (!ImmutableCharMapKeySet.isNonSentinel(this.keys[i]) || isMinSet && this.keys[i] >= min2) continue;
            min2 = this.keys[i];
            isMinSet = true;
        }
        return min2;
    }

    @Override
    public <T> T injectInto(T injectedValue, ObjectCharToObjectFunction<? super T, ? extends T> function) {
        T result = injectedValue;
        if (this.containsZeroKey) {
            result = function.valueOf(result, '\u0000');
        }
        if (this.containsOneKey) {
            result = function.valueOf(result, '\u0001');
        }
        if (this.keys != null) {
            for (int i = 0; i < this.keys.length; ++i) {
                if (!ImmutableCharMapKeySet.isNonSentinel(this.keys[i])) continue;
                result = function.valueOf(result, this.keys[i]);
            }
        }
        return result;
    }

    private Object writeReplace() {
        return new ImmutableCharSetSerializationProxy(this);
    }

    int probe(char element) {
        int index = this.mask(element);
        char keyAtIndex = this.keys[index];
        if (keyAtIndex == element || keyAtIndex == '\u0000') {
            return index;
        }
        int removedIndex = keyAtIndex == '\u0001' ? index : -1;
        for (int i = 1; i < 16; ++i) {
            int nextIndex = index + i & this.keys.length - 1;
            keyAtIndex = this.keys[nextIndex];
            if (keyAtIndex == element) {
                return nextIndex;
            }
            if (keyAtIndex == '\u0000') {
                return removedIndex == -1 ? nextIndex : removedIndex;
            }
            if (keyAtIndex != '\u0001' || removedIndex != -1) continue;
            removedIndex = nextIndex;
        }
        return this.probeTwo(element, removedIndex);
    }

    int probeTwo(char element, int removedIndex) {
        int index = this.spreadTwoAndMask(element);
        for (int i = 0; i < 16; ++i) {
            int nextIndex = index + i & this.keys.length - 1;
            char keyAtIndex = this.keys[nextIndex];
            if (keyAtIndex == element) {
                return nextIndex;
            }
            if (keyAtIndex == '\u0000') {
                return removedIndex == -1 ? nextIndex : removedIndex;
            }
            if (keyAtIndex != '\u0001' || removedIndex != -1) continue;
            removedIndex = nextIndex;
        }
        return this.probeThree(element, removedIndex);
    }

    int probeThree(char element, int removedIndex) {
        int nextIndex = SpreadFunctions.charSpreadOne(element);
        int spreadTwo = Integer.reverse(SpreadFunctions.charSpreadTwo(element)) | 1;
        char keyAtIndex;
        while ((keyAtIndex = this.keys[nextIndex = this.mask(nextIndex + spreadTwo)]) != element) {
            if (keyAtIndex == '\u0000') {
                return removedIndex == -1 ? nextIndex : removedIndex;
            }
            if (keyAtIndex != '\u0001' || removedIndex != -1) continue;
            removedIndex = nextIndex;
        }
        return nextIndex;
    }

    int spreadAndMask(char element) {
        int code = SpreadFunctions.charSpreadOne(element);
        return this.mask(code);
    }

    int spreadTwoAndMask(char element) {
        int code = SpreadFunctions.charSpreadTwo(element);
        return this.mask(code);
    }

    private int mask(int spread) {
        return spread & this.keys.length - 1;
    }

    private class InternalCharIterator
    implements CharIterator {
        private int count;
        private int position;
        private boolean handledZero;
        private boolean handledOne;

        private InternalCharIterator() {
        }

        @Override
        public boolean hasNext() {
            return this.count < ImmutableCharMapKeySet.this.size();
        }

        @Override
        public char next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException("next() called, but the iterator is exhausted");
            }
            ++this.count;
            if (!this.handledZero) {
                this.handledZero = true;
                if (ImmutableCharMapKeySet.this.containsZeroKey) {
                    return '\u0000';
                }
            }
            if (!this.handledOne) {
                this.handledOne = true;
                if (ImmutableCharMapKeySet.this.containsOneKey) {
                    return '\u0001';
                }
            }
            char[] keys = ImmutableCharMapKeySet.this.keys;
            while (!ImmutableCharMapKeySet.isNonSentinel(keys[this.position])) {
                ++this.position;
            }
            char result = ImmutableCharMapKeySet.this.keys[this.position];
            ++this.position;
            return result;
        }
    }
}

