/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.collections.impl.map.mutable.primitive;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Arrays;
import java.util.Iterator;
import java.util.NoSuchElementException;
import org.eclipse.collections.api.DoubleIterable;
import org.eclipse.collections.api.LazyDoubleIterable;
import org.eclipse.collections.api.RichIterable;
import org.eclipse.collections.api.block.function.primitive.DoubleDoubleToDoubleFunction;
import org.eclipse.collections.api.block.function.primitive.DoubleFunction;
import org.eclipse.collections.api.block.function.primitive.DoubleFunction0;
import org.eclipse.collections.api.block.function.primitive.DoubleToDoubleFunction;
import org.eclipse.collections.api.block.function.primitive.ObjectDoubleToObjectFunction;
import org.eclipse.collections.api.block.predicate.primitive.DoubleDoublePredicate;
import org.eclipse.collections.api.block.procedure.Procedure;
import org.eclipse.collections.api.block.procedure.Procedure2;
import org.eclipse.collections.api.block.procedure.primitive.DoubleDoubleProcedure;
import org.eclipse.collections.api.block.procedure.primitive.DoubleProcedure;
import org.eclipse.collections.api.block.procedure.primitive.ObjectIntProcedure;
import org.eclipse.collections.api.collection.primitive.MutableDoubleCollection;
import org.eclipse.collections.api.factory.primitive.DoubleDoubleMaps;
import org.eclipse.collections.api.iterator.DoubleIterator;
import org.eclipse.collections.api.iterator.MutableDoubleIterator;
import org.eclipse.collections.api.map.primitive.DoubleDoubleMap;
import org.eclipse.collections.api.map.primitive.ImmutableDoubleDoubleMap;
import org.eclipse.collections.api.map.primitive.MutableDoubleDoubleMap;
import org.eclipse.collections.api.set.primitive.DoubleSet;
import org.eclipse.collections.api.set.primitive.MutableDoubleSet;
import org.eclipse.collections.api.tuple.primitive.DoubleDoublePair;
import org.eclipse.collections.impl.SpreadFunctions;
import org.eclipse.collections.impl.bag.mutable.primitive.DoubleHashBag;
import org.eclipse.collections.impl.iterator.UnmodifiableDoubleIterator;
import org.eclipse.collections.impl.lazy.AbstractLazyIterable;
import org.eclipse.collections.impl.lazy.primitive.AbstractLazyDoubleIterable;
import org.eclipse.collections.impl.map.mutable.primitive.AbstractMutableDoubleKeySet;
import org.eclipse.collections.impl.map.mutable.primitive.AbstractMutableDoubleValuesMap;
import org.eclipse.collections.impl.map.mutable.primitive.ImmutableDoubleDoubleMapKeySet;
import org.eclipse.collections.impl.map.mutable.primitive.MutableDoubleKeysMap;
import org.eclipse.collections.impl.map.mutable.primitive.SynchronizedDoubleDoubleMap;
import org.eclipse.collections.impl.map.mutable.primitive.UnmodifiableDoubleDoubleMap;
import org.eclipse.collections.impl.set.mutable.primitive.DoubleHashSet;
import org.eclipse.collections.impl.tuple.primitive.PrimitiveTuples;

public class DoubleDoubleHashMap
extends AbstractMutableDoubleValuesMap
implements MutableDoubleDoubleMap,
Externalizable,
MutableDoubleKeysMap {
    private static final double EMPTY_VALUE = 0.0;
    private static final long serialVersionUID = 1L;
    private static final double EMPTY_KEY = 0.0;
    private static final double REMOVED_KEY = 1.0;
    private static final int CACHE_LINE_SIZE = 64;
    private static final int KEY_SIZE = 8;
    private static final int INITIAL_LINEAR_PROBE = 4;
    private static final int DEFAULT_INITIAL_CAPACITY = 8;
    private double[] keysValues;
    private int occupiedWithData;
    private int occupiedWithSentinels;
    private AbstractMutableDoubleValuesMap.SentinelValues sentinelValues;
    private boolean copyKeysOnWrite;

    public DoubleDoubleHashMap() {
        this.allocateTable(16);
    }

    public DoubleDoubleHashMap(int initialCapacity) {
        if (initialCapacity < 0) {
            throw new IllegalArgumentException("initial capacity cannot be less than 0");
        }
        int capacity = this.smallestPowerOfTwoGreaterThan(initialCapacity << 1);
        this.allocateTable(capacity);
    }

    public DoubleDoubleHashMap(DoubleDoubleMap map2) {
        if (map2 instanceof DoubleDoubleHashMap && ((DoubleDoubleHashMap)map2).occupiedWithSentinels == 0) {
            DoubleDoubleHashMap hashMap = (DoubleDoubleHashMap)map2;
            this.occupiedWithData = hashMap.occupiedWithData;
            if (hashMap.sentinelValues != null) {
                this.sentinelValues = hashMap.sentinelValues.copy();
            }
            this.keysValues = Arrays.copyOf(hashMap.keysValues, hashMap.keysValues.length);
        } else {
            int capacity = this.smallestPowerOfTwoGreaterThan(Math.max(map2.size(), 8) << 1);
            this.allocateTable(capacity);
            this.putAll(map2);
        }
    }

    public static DoubleDoubleHashMap newWithKeysValues(double key1, double value1) {
        return new DoubleDoubleHashMap(1).withKeyValue(key1, value1);
    }

    public static DoubleDoubleHashMap newWithKeysValues(double key1, double value1, double key2, double value2) {
        return new DoubleDoubleHashMap(2).withKeysValues(key1, value1, key2, value2);
    }

    public static DoubleDoubleHashMap newWithKeysValues(double key1, double value1, double key2, double value2, double key3, double value3) {
        return new DoubleDoubleHashMap(3).withKeysValues(key1, value1, key2, value2, key3, value3);
    }

    public static DoubleDoubleHashMap newWithKeysValues(double key1, double value1, double key2, double value2, double key3, double value3, double key4, double value4) {
        return new DoubleDoubleHashMap(4).withKeysValues(key1, value1, key2, value2, key3, value3, key4, value4);
    }

    private int smallestPowerOfTwoGreaterThan(int n) {
        return n > 1 ? Integer.highestOneBit(n - 1) << 1 : 1;
    }

    @Override
    protected int getOccupiedWithData() {
        return this.occupiedWithData;
    }

    @Override
    protected AbstractMutableDoubleValuesMap.SentinelValues getSentinelValues() {
        return this.sentinelValues;
    }

    @Override
    protected void setSentinelValuesNull() {
        this.sentinelValues = null;
    }

    @Override
    protected double getEmptyValue() {
        return 0.0;
    }

    @Override
    protected int getTableSize() {
        return this.keysValues.length / 2;
    }

    @Override
    protected double getValueAtIndex(int index) {
        return this.keysValues[index * 2 + 1];
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof DoubleDoubleMap)) {
            return false;
        }
        DoubleDoubleMap other = (DoubleDoubleMap)obj;
        if (this.size() != other.size()) {
            return false;
        }
        if (this.sentinelValues == null) {
            if (other.containsKey(0.0) || other.containsKey(1.0)) {
                return false;
            }
        } else {
            if (this.sentinelValues.containsZeroKey && (!other.containsKey(0.0) || Double.compare(this.sentinelValues.zeroValue, other.getOrThrow(0.0)) != 0)) {
                return false;
            }
            if (this.sentinelValues.containsOneKey && (!other.containsKey(1.0) || Double.compare(this.sentinelValues.oneValue, other.getOrThrow(1.0)) != 0)) {
                return false;
            }
        }
        for (int i = 0; i < this.keysValues.length; i += 2) {
            double key = this.keysValues[i];
            if (!DoubleDoubleHashMap.isNonSentinel(key) || other.containsKey(key) && Double.compare(this.keysValues[i + 1], other.getOrThrow(key)) == 0) continue;
            return false;
        }
        return true;
    }

    @Override
    public int hashCode() {
        int result = 0;
        if (this.sentinelValues != null) {
            if (this.sentinelValues.containsZeroKey) {
                result += (int)(Double.doubleToLongBits(0.0) ^ Double.doubleToLongBits(0.0) >>> 32) ^ (int)(Double.doubleToLongBits(this.sentinelValues.zeroValue) ^ Double.doubleToLongBits(this.sentinelValues.zeroValue) >>> 32);
            }
            if (this.sentinelValues.containsOneKey) {
                result += (int)(Double.doubleToLongBits(1.0) ^ Double.doubleToLongBits(1.0) >>> 32) ^ (int)(Double.doubleToLongBits(this.sentinelValues.oneValue) ^ Double.doubleToLongBits(this.sentinelValues.oneValue) >>> 32);
            }
        }
        for (int i = 0; i < this.keysValues.length; i += 2) {
            if (!DoubleDoubleHashMap.isNonSentinel(this.keysValues[i])) continue;
            result += (int)(Double.doubleToLongBits(this.keysValues[i]) ^ Double.doubleToLongBits(this.keysValues[i]) >>> 32) ^ (int)(Double.doubleToLongBits(this.keysValues[i + 1]) ^ Double.doubleToLongBits(this.keysValues[i + 1]) >>> 32);
        }
        return result;
    }

    @Override
    public String toString() {
        StringBuilder appendable = new StringBuilder();
        appendable.append("{");
        boolean first = true;
        if (this.sentinelValues != null) {
            if (this.sentinelValues.containsZeroKey) {
                appendable.append(0.0).append("=").append(this.sentinelValues.zeroValue);
                first = false;
            }
            if (this.sentinelValues.containsOneKey) {
                if (!first) {
                    appendable.append(", ");
                }
                appendable.append(1.0).append("=").append(this.sentinelValues.oneValue);
                first = false;
            }
        }
        for (int i = 0; i < this.keysValues.length; i += 2) {
            double key = this.keysValues[i];
            if (!DoubleDoubleHashMap.isNonSentinel(key)) continue;
            if (!first) {
                appendable.append(", ");
            }
            appendable.append(key).append("=").append(this.keysValues[i + 1]);
            first = false;
        }
        appendable.append("}");
        return appendable.toString();
    }

    @Override
    public MutableDoubleIterator doubleIterator() {
        return new InternalDoubleIterator();
    }

    public <V> V injectInto(V injectedValue, ObjectDoubleToObjectFunction<? super V, ? extends V> function) {
        V result = injectedValue;
        if (this.sentinelValues != null) {
            if (this.sentinelValues.containsZeroKey) {
                result = function.valueOf(result, this.sentinelValues.zeroValue);
            }
            if (this.sentinelValues.containsOneKey) {
                result = function.valueOf(result, this.sentinelValues.oneValue);
            }
        }
        for (int i = 0; i < this.keysValues.length; i += 2) {
            if (!DoubleDoubleHashMap.isNonSentinel(this.keysValues[i])) continue;
            result = function.valueOf(result, this.keysValues[i + 1]);
        }
        return result;
    }

    @Override
    public void clear() {
        this.sentinelValues = null;
        this.occupiedWithData = 0;
        this.occupiedWithSentinels = 0;
        if (this.copyKeysOnWrite) {
            this.copyKeys();
        }
        Arrays.fill(this.keysValues, 0.0);
    }

    @Override
    public void put(double key, double value) {
        if (DoubleDoubleHashMap.isEmptyKey(key)) {
            this.putForEmptySentinel(value);
            return;
        }
        if (DoubleDoubleHashMap.isRemovedKey(key)) {
            this.putForRemovedSentinel(value);
            return;
        }
        int index = this.probe(key);
        double keyAtIndex = this.keysValues[index];
        if (Double.compare(keyAtIndex, key) == 0) {
            this.keysValues[index + 1] = value;
        } else {
            this.addKeyValueAtIndex(key, value, index);
        }
    }

    private void putForRemovedSentinel(double value) {
        if (this.sentinelValues == null) {
            this.sentinelValues = new AbstractMutableDoubleValuesMap.SentinelValues();
        }
        this.addRemovedKeyValue(value);
    }

    private void putForEmptySentinel(double value) {
        if (this.sentinelValues == null) {
            this.sentinelValues = new AbstractMutableDoubleValuesMap.SentinelValues();
        }
        this.addEmptyKeyValue(value);
    }

    @Override
    public void putAll(DoubleDoubleMap map2) {
        map2.forEachKeyValue(this::put);
    }

    @Override
    public void updateValues(DoubleDoubleToDoubleFunction function) {
        if (this.sentinelValues != null) {
            if (this.sentinelValues.containsZeroKey) {
                this.sentinelValues.zeroValue = function.valueOf(0.0, this.sentinelValues.zeroValue);
            }
            if (this.sentinelValues.containsOneKey) {
                this.sentinelValues.oneValue = function.valueOf(1.0, this.sentinelValues.oneValue);
            }
        }
        for (int i = 0; i < this.keysValues.length; i += 2) {
            if (!DoubleDoubleHashMap.isNonSentinel(this.keysValues[i])) continue;
            this.keysValues[i + 1] = function.valueOf(this.keysValues[i], this.keysValues[i + 1]);
        }
    }

    @Override
    public void removeKey(double key) {
        if (DoubleDoubleHashMap.isEmptyKey(key)) {
            if (this.sentinelValues == null || !this.sentinelValues.containsZeroKey) {
                return;
            }
            this.removeEmptyKey();
            return;
        }
        if (DoubleDoubleHashMap.isRemovedKey(key)) {
            if (this.sentinelValues == null || !this.sentinelValues.containsOneKey) {
                return;
            }
            this.removeRemovedKey();
            return;
        }
        int index = this.probe(key);
        if (Double.compare(this.keysValues[index], key) == 0) {
            this.removeKeyAtIndex(index);
        }
    }

    @Override
    public void remove(double key) {
        this.removeKey(key);
    }

    @Override
    public double removeKeyIfAbsent(double key, double value) {
        if (DoubleDoubleHashMap.isEmptyKey(key)) {
            if (this.sentinelValues == null || !this.sentinelValues.containsZeroKey) {
                return value;
            }
            double oldValue = this.sentinelValues.zeroValue;
            this.removeEmptyKey();
            return oldValue;
        }
        if (DoubleDoubleHashMap.isRemovedKey(key)) {
            if (this.sentinelValues == null || !this.sentinelValues.containsOneKey) {
                return value;
            }
            double oldValue = this.sentinelValues.oneValue;
            this.removeRemovedKey();
            return oldValue;
        }
        int index = this.probe(key);
        if (Double.compare(this.keysValues[index], key) == 0) {
            double oldValue = this.keysValues[index + 1];
            this.removeKeyAtIndex(index);
            return oldValue;
        }
        return value;
    }

    @Override
    public double getIfAbsentPut(double key, double value) {
        if (DoubleDoubleHashMap.isEmptyKey(key)) {
            if (this.sentinelValues == null) {
                this.sentinelValues = new AbstractMutableDoubleValuesMap.SentinelValues();
                this.addEmptyKeyValue(value);
                return value;
            }
            if (this.sentinelValues.containsZeroKey) {
                return this.sentinelValues.zeroValue;
            }
            this.addEmptyKeyValue(value);
            return value;
        }
        if (DoubleDoubleHashMap.isRemovedKey(key)) {
            if (this.sentinelValues == null) {
                this.sentinelValues = new AbstractMutableDoubleValuesMap.SentinelValues();
                this.addRemovedKeyValue(value);
                return value;
            }
            if (this.sentinelValues.containsOneKey) {
                return this.sentinelValues.oneValue;
            }
            this.addRemovedKeyValue(value);
            return value;
        }
        int index = this.probe(key);
        if (Double.compare(this.keysValues[index], key) == 0) {
            return this.keysValues[index + 1];
        }
        this.addKeyValueAtIndex(key, value, index);
        return value;
    }

    @Override
    public double getAndPut(double key, double putValue, double defaultValue) {
        if (DoubleDoubleHashMap.isEmptyKey(key)) {
            if (this.sentinelValues == null) {
                this.sentinelValues = new AbstractMutableDoubleValuesMap.SentinelValues();
            } else if (this.sentinelValues.containsZeroKey) {
                double existingValue = this.sentinelValues.zeroValue;
                this.sentinelValues.zeroValue = putValue;
                return existingValue;
            }
            this.addEmptyKeyValue(putValue);
            return defaultValue;
        }
        if (DoubleDoubleHashMap.isRemovedKey(key)) {
            if (this.sentinelValues == null) {
                this.sentinelValues = new AbstractMutableDoubleValuesMap.SentinelValues();
            } else if (this.sentinelValues.containsOneKey) {
                double existingValue = this.sentinelValues.oneValue;
                this.sentinelValues.oneValue = putValue;
                return existingValue;
            }
            this.addRemovedKeyValue(putValue);
            return defaultValue;
        }
        int index = this.probe(key);
        if (Double.compare(this.keysValues[index], key) == 0) {
            double existingValue = this.keysValues[index + 1];
            this.keysValues[index + 1] = putValue;
            return existingValue;
        }
        this.addKeyValueAtIndex(key, putValue, index);
        return defaultValue;
    }

    @Override
    public double getIfAbsentPut(double key, DoubleFunction0 function) {
        if (DoubleDoubleHashMap.isEmptyKey(key)) {
            if (this.sentinelValues == null) {
                double value = function.value();
                this.sentinelValues = new AbstractMutableDoubleValuesMap.SentinelValues();
                this.addEmptyKeyValue(value);
                return value;
            }
            if (this.sentinelValues.containsZeroKey) {
                return this.sentinelValues.zeroValue;
            }
            double value = function.value();
            this.addEmptyKeyValue(value);
            return value;
        }
        if (DoubleDoubleHashMap.isRemovedKey(key)) {
            if (this.sentinelValues == null) {
                double value = function.value();
                this.sentinelValues = new AbstractMutableDoubleValuesMap.SentinelValues();
                this.addRemovedKeyValue(value);
                return value;
            }
            if (this.sentinelValues.containsOneKey) {
                return this.sentinelValues.oneValue;
            }
            double value = function.value();
            this.addRemovedKeyValue(value);
            return value;
        }
        int index = this.probe(key);
        if (Double.compare(this.keysValues[index], key) == 0) {
            return this.keysValues[index + 1];
        }
        double value = function.value();
        this.addKeyValueAtIndex(key, value, index);
        return value;
    }

    @Override
    public <P> double getIfAbsentPutWith(double key, DoubleFunction<? super P> function, P parameter) {
        if (DoubleDoubleHashMap.isEmptyKey(key)) {
            if (this.sentinelValues == null) {
                double value = function.doubleValueOf(parameter);
                this.sentinelValues = new AbstractMutableDoubleValuesMap.SentinelValues();
                this.addEmptyKeyValue(value);
                return value;
            }
            if (this.sentinelValues.containsZeroKey) {
                return this.sentinelValues.zeroValue;
            }
            double value = function.doubleValueOf(parameter);
            this.addEmptyKeyValue(value);
            return value;
        }
        if (DoubleDoubleHashMap.isRemovedKey(key)) {
            if (this.sentinelValues == null) {
                double value = function.doubleValueOf(parameter);
                this.sentinelValues = new AbstractMutableDoubleValuesMap.SentinelValues();
                this.addRemovedKeyValue(value);
                return value;
            }
            if (this.sentinelValues.containsOneKey) {
                return this.sentinelValues.oneValue;
            }
            double value = function.doubleValueOf(parameter);
            this.addRemovedKeyValue(value);
            return value;
        }
        int index = this.probe(key);
        if (Double.compare(this.keysValues[index], key) == 0) {
            return this.keysValues[index + 1];
        }
        double value = function.doubleValueOf(parameter);
        this.addKeyValueAtIndex(key, value, index);
        return value;
    }

    @Override
    public double getIfAbsentPutWithKey(double key, DoubleToDoubleFunction function) {
        if (DoubleDoubleHashMap.isEmptyKey(key)) {
            if (this.sentinelValues == null) {
                double value = function.valueOf(key);
                this.sentinelValues = new AbstractMutableDoubleValuesMap.SentinelValues();
                this.addEmptyKeyValue(value);
                return value;
            }
            if (this.sentinelValues.containsZeroKey) {
                return this.sentinelValues.zeroValue;
            }
            double value = function.valueOf(key);
            this.addEmptyKeyValue(value);
            return value;
        }
        if (DoubleDoubleHashMap.isRemovedKey(key)) {
            if (this.sentinelValues == null) {
                double value = function.valueOf(key);
                this.sentinelValues = new AbstractMutableDoubleValuesMap.SentinelValues();
                this.addRemovedKeyValue(value);
                return value;
            }
            if (this.sentinelValues.containsOneKey) {
                return this.sentinelValues.oneValue;
            }
            double value = function.valueOf(key);
            this.addRemovedKeyValue(value);
            return value;
        }
        int index = this.probe(key);
        if (Double.compare(this.keysValues[index], key) == 0) {
            return this.keysValues[index + 1];
        }
        double value = function.valueOf(key);
        this.addKeyValueAtIndex(key, value, index);
        return value;
    }

    @Override
    public double addToValue(double key, double toBeAdded) {
        if (DoubleDoubleHashMap.isEmptyKey(key)) {
            if (this.sentinelValues == null) {
                this.sentinelValues = new AbstractMutableDoubleValuesMap.SentinelValues();
                this.addEmptyKeyValue(toBeAdded);
            } else if (this.sentinelValues.containsZeroKey) {
                this.sentinelValues.zeroValue += toBeAdded;
            } else {
                this.addEmptyKeyValue(toBeAdded);
            }
            return this.sentinelValues.zeroValue;
        }
        if (DoubleDoubleHashMap.isRemovedKey(key)) {
            if (this.sentinelValues == null) {
                this.sentinelValues = new AbstractMutableDoubleValuesMap.SentinelValues();
                this.addRemovedKeyValue(toBeAdded);
            } else if (this.sentinelValues.containsOneKey) {
                this.sentinelValues.oneValue += toBeAdded;
            } else {
                this.addRemovedKeyValue(toBeAdded);
            }
            return this.sentinelValues.oneValue;
        }
        int index = this.probe(key);
        if (Double.compare(this.keysValues[index], key) == 0) {
            int n = index + 1;
            this.keysValues[n] = this.keysValues[n] + toBeAdded;
            return this.keysValues[index + 1];
        }
        this.addKeyValueAtIndex(key, toBeAdded, index);
        return toBeAdded;
    }

    private void addKeyValueAtIndex(double key, double value, int index) {
        if (Double.compare(this.keysValues[index], 1.0) == 0) {
            --this.occupiedWithSentinels;
        }
        if (this.copyKeysOnWrite) {
            this.copyKeys();
        }
        this.keysValues[index] = key;
        this.keysValues[index + 1] = value;
        ++this.occupiedWithData;
        if (this.occupiedWithData + this.occupiedWithSentinels > this.maxOccupiedWithData()) {
            this.rehashAndGrow();
        }
    }

    private void removeKeyAtIndex(int index) {
        if (this.copyKeysOnWrite) {
            this.copyKeys();
        }
        this.keysValues[index] = 1.0;
        this.keysValues[index + 1] = 0.0;
        --this.occupiedWithData;
        ++this.occupiedWithSentinels;
    }

    private void copyKeys() {
        double[] copy = new double[this.keysValues.length];
        System.arraycopy(this.keysValues, 0, copy, 0, this.keysValues.length);
        this.keysValues = copy;
        this.copyKeysOnWrite = false;
    }

    @Override
    public double updateValue(double key, double initialValueIfAbsent, DoubleToDoubleFunction function) {
        if (DoubleDoubleHashMap.isEmptyKey(key)) {
            if (this.sentinelValues == null) {
                this.sentinelValues = new AbstractMutableDoubleValuesMap.SentinelValues();
                this.addEmptyKeyValue(function.valueOf(initialValueIfAbsent));
            } else if (this.sentinelValues.containsZeroKey) {
                this.sentinelValues.zeroValue = function.valueOf(this.sentinelValues.zeroValue);
            } else {
                this.addEmptyKeyValue(function.valueOf(initialValueIfAbsent));
            }
            return this.sentinelValues.zeroValue;
        }
        if (DoubleDoubleHashMap.isRemovedKey(key)) {
            if (this.sentinelValues == null) {
                this.sentinelValues = new AbstractMutableDoubleValuesMap.SentinelValues();
                this.addRemovedKeyValue(function.valueOf(initialValueIfAbsent));
            } else if (this.sentinelValues.containsOneKey) {
                this.sentinelValues.oneValue = function.valueOf(this.sentinelValues.oneValue);
            } else {
                this.addRemovedKeyValue(function.valueOf(initialValueIfAbsent));
            }
            return this.sentinelValues.oneValue;
        }
        int index = this.probe(key);
        if (Double.compare(this.keysValues[index], key) == 0) {
            this.keysValues[index + 1] = function.valueOf(this.keysValues[index + 1]);
            return this.keysValues[index + 1];
        }
        double value = function.valueOf(initialValueIfAbsent);
        this.addKeyValueAtIndex(key, value, index);
        return value;
    }

    @Override
    public DoubleDoubleHashMap withKeyValue(double key1, double value1) {
        this.put(key1, value1);
        return this;
    }

    public DoubleDoubleHashMap withKeysValues(double key1, double value1, double key2, double value2) {
        this.put(key1, value1);
        this.put(key2, value2);
        return this;
    }

    public DoubleDoubleHashMap withKeysValues(double key1, double value1, double key2, double value2, double key3, double value3) {
        this.put(key1, value1);
        this.put(key2, value2);
        this.put(key3, value3);
        return this;
    }

    public DoubleDoubleHashMap withKeysValues(double key1, double value1, double key2, double value2, double key3, double value3, double key4, double value4) {
        this.put(key1, value1);
        this.put(key2, value2);
        this.put(key3, value3);
        this.put(key4, value4);
        return this;
    }

    @Override
    public DoubleDoubleHashMap withoutKey(double key) {
        this.removeKey(key);
        return this;
    }

    @Override
    public DoubleDoubleHashMap withoutAllKeys(DoubleIterable keys) {
        keys.forEach(this::removeKey);
        return this;
    }

    @Override
    public MutableDoubleDoubleMap asUnmodifiable() {
        return new UnmodifiableDoubleDoubleMap(this);
    }

    @Override
    public MutableDoubleDoubleMap asSynchronized() {
        return new SynchronizedDoubleDoubleMap(this);
    }

    @Override
    public ImmutableDoubleDoubleMap toImmutable() {
        return DoubleDoubleMaps.immutable.ofAll(this);
    }

    @Override
    public double get(double key) {
        return this.getIfAbsent(key, 0.0);
    }

    @Override
    public double getIfAbsent(double key, double ifAbsent) {
        if (DoubleDoubleHashMap.isEmptyKey(key) || DoubleDoubleHashMap.isRemovedKey(key)) {
            return this.getForSentinel(key, ifAbsent);
        }
        if (this.occupiedWithSentinels == 0) {
            return this.fastGetIfAbsent(key, ifAbsent);
        }
        return this.slowGetIfAbsent(key, ifAbsent);
    }

    private double getForSentinel(double key, double ifAbsent) {
        if (DoubleDoubleHashMap.isEmptyKey(key)) {
            if (this.sentinelValues == null || !this.sentinelValues.containsZeroKey) {
                return ifAbsent;
            }
            return this.sentinelValues.zeroValue;
        }
        if (this.sentinelValues == null || !this.sentinelValues.containsOneKey) {
            return ifAbsent;
        }
        return this.sentinelValues.oneValue;
    }

    private double slowGetIfAbsent(double key, double ifAbsent) {
        int index = this.probe(key);
        if (Double.compare(this.keysValues[index], key) == 0) {
            return this.keysValues[index + 1];
        }
        return ifAbsent;
    }

    private double fastGetIfAbsent(double key, double ifAbsent) {
        int index = this.mask((int)key) << 1;
        for (int i = 0; i < 4; i += 2) {
            double keyAtIndex = this.keysValues[index];
            if (Double.compare(keyAtIndex, key) == 0) {
                return this.keysValues[index + 1];
            }
            if (Double.compare(keyAtIndex, 0.0) == 0) {
                return ifAbsent;
            }
            index = index + 2 & this.keysValues.length - 1;
        }
        return this.slowGetIfAbsentTwo(key, ifAbsent);
    }

    private double slowGetIfAbsentTwo(double key, double ifAbsent) {
        int index = this.probeTwo(key, -1);
        if (Double.compare(this.keysValues[index], key) == 0) {
            return this.keysValues[index + 1];
        }
        return ifAbsent;
    }

    @Override
    public double getOrThrow(double key) {
        if (DoubleDoubleHashMap.isEmptyKey(key)) {
            if (this.sentinelValues == null || !this.sentinelValues.containsZeroKey) {
                throw new IllegalStateException("Key " + key + " not present.");
            }
            return this.sentinelValues.zeroValue;
        }
        if (DoubleDoubleHashMap.isRemovedKey(key)) {
            if (this.sentinelValues == null || !this.sentinelValues.containsOneKey) {
                throw new IllegalStateException("Key " + key + " not present.");
            }
            return this.sentinelValues.oneValue;
        }
        int index = this.probe(key);
        if (DoubleDoubleHashMap.isNonSentinel(this.keysValues[index])) {
            return this.keysValues[index + 1];
        }
        throw new IllegalStateException("Key " + key + " not present.");
    }

    @Override
    public boolean containsKey(double key) {
        if (DoubleDoubleHashMap.isEmptyKey(key)) {
            return this.sentinelValues != null && this.sentinelValues.containsZeroKey;
        }
        if (DoubleDoubleHashMap.isRemovedKey(key)) {
            return this.sentinelValues != null && this.sentinelValues.containsOneKey;
        }
        return Double.compare(this.keysValues[this.probe(key)], key) == 0;
    }

    @Override
    public void forEachKey(DoubleProcedure procedure) {
        if (this.sentinelValues != null) {
            if (this.sentinelValues.containsZeroKey) {
                procedure.value(0.0);
            }
            if (this.sentinelValues.containsOneKey) {
                procedure.value(1.0);
            }
        }
        for (int i = 0; i < this.keysValues.length; i += 2) {
            if (!DoubleDoubleHashMap.isNonSentinel(this.keysValues[i])) continue;
            procedure.value(this.keysValues[i]);
        }
    }

    @Override
    public void forEachKeyValue(DoubleDoubleProcedure procedure) {
        if (this.sentinelValues != null) {
            if (this.sentinelValues.containsZeroKey) {
                procedure.value(0.0, this.sentinelValues.zeroValue);
            }
            if (this.sentinelValues.containsOneKey) {
                procedure.value(1.0, this.sentinelValues.oneValue);
            }
        }
        for (int i = 0; i < this.keysValues.length; i += 2) {
            if (!DoubleDoubleHashMap.isNonSentinel(this.keysValues[i])) continue;
            procedure.value(this.keysValues[i], this.keysValues[i + 1]);
        }
    }

    @Override
    public LazyDoubleIterable keysView() {
        return new KeysView();
    }

    @Override
    public RichIterable<DoubleDoublePair> keyValuesView() {
        return new KeyValuesView();
    }

    @Override
    public MutableDoubleDoubleMap flipUniqueValues() {
        MutableDoubleDoubleMap result = DoubleDoubleMaps.mutable.empty();
        this.forEachKeyValue((key, value) -> {
            if (result.containsKey(value)) {
                throw new IllegalStateException("Duplicate value: " + value + " found at key: " + result.get(value) + " and key: " + key);
            }
            result.put(value, key);
        });
        return result;
    }

    @Override
    public DoubleDoubleHashMap select(DoubleDoublePredicate predicate) {
        DoubleDoubleHashMap result = new DoubleDoubleHashMap();
        if (this.sentinelValues != null) {
            if (this.sentinelValues.containsZeroKey && predicate.accept(0.0, this.sentinelValues.zeroValue)) {
                result.put(0.0, this.sentinelValues.zeroValue);
            }
            if (this.sentinelValues.containsOneKey && predicate.accept(1.0, this.sentinelValues.oneValue)) {
                result.put(1.0, this.sentinelValues.oneValue);
            }
        }
        for (int i = 0; i < this.keysValues.length; i += 2) {
            if (!DoubleDoubleHashMap.isNonSentinel(this.keysValues[i]) || !predicate.accept(this.keysValues[i], this.keysValues[i + 1])) continue;
            result.put(this.keysValues[i], this.keysValues[i + 1]);
        }
        return result;
    }

    @Override
    public DoubleDoubleHashMap reject(DoubleDoublePredicate predicate) {
        DoubleDoubleHashMap result = new DoubleDoubleHashMap();
        if (this.sentinelValues != null) {
            if (this.sentinelValues.containsZeroKey && !predicate.accept(0.0, this.sentinelValues.zeroValue)) {
                result.put(0.0, this.sentinelValues.zeroValue);
            }
            if (this.sentinelValues.containsOneKey && !predicate.accept(1.0, this.sentinelValues.oneValue)) {
                result.put(1.0, this.sentinelValues.oneValue);
            }
        }
        for (int i = 0; i < this.keysValues.length; i += 2) {
            if (!DoubleDoubleHashMap.isNonSentinel(this.keysValues[i]) || predicate.accept(this.keysValues[i], this.keysValues[i + 1])) continue;
            result.put(this.keysValues[i], this.keysValues[i + 1]);
        }
        return result;
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeInt(this.size());
        if (this.sentinelValues != null) {
            if (this.sentinelValues.containsZeroKey) {
                out.writeDouble(0.0);
                out.writeDouble(this.sentinelValues.zeroValue);
            }
            if (this.sentinelValues.containsOneKey) {
                out.writeDouble(1.0);
                out.writeDouble(this.sentinelValues.oneValue);
            }
        }
        for (int i = 0; i < this.keysValues.length; i += 2) {
            if (!DoubleDoubleHashMap.isNonSentinel(this.keysValues[i])) continue;
            out.writeDouble(this.keysValues[i]);
            out.writeDouble(this.keysValues[i + 1]);
        }
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        int size2 = in.readInt();
        for (int i = 0; i < size2; ++i) {
            this.put(in.readDouble(), in.readDouble());
        }
    }

    public void compact() {
        this.rehash(this.smallestPowerOfTwoGreaterThan(this.size()));
    }

    private void rehashAndGrow() {
        int max2 = this.maxOccupiedWithData();
        int newCapacity = Math.max(max2, this.smallestPowerOfTwoGreaterThan(this.occupiedWithData + 1 << 1));
        if (this.occupiedWithSentinels > 0 && (max2 >> 1) + (max2 >> 2) < this.occupiedWithData) {
            newCapacity <<= 1;
        }
        this.rehash(newCapacity);
    }

    private void rehash(int newCapacity) {
        int oldLength = this.keysValues.length;
        double[] old = this.keysValues;
        this.allocateTable(newCapacity);
        this.occupiedWithData = 0;
        this.occupiedWithSentinels = 0;
        for (int i = 0; i < oldLength; i += 2) {
            if (!DoubleDoubleHashMap.isNonSentinel(old[i])) continue;
            this.put(old[i], old[i + 1]);
        }
    }

    int probe(double element) {
        int index = this.mask((int)element) << 1;
        double keyAtIndex = this.keysValues[index];
        if (Double.compare(keyAtIndex, element) == 0 || Double.compare(keyAtIndex, 0.0) == 0) {
            return index;
        }
        int removedIndex = Double.compare(keyAtIndex, 1.0) == 0 ? index : -1;
        for (int i = 2; i < 4; i += 2) {
            int nextIndex = index + i & this.keysValues.length - 1;
            keyAtIndex = this.keysValues[nextIndex];
            if (Double.compare(keyAtIndex, element) == 0) {
                return nextIndex;
            }
            if (Double.compare(keyAtIndex, 0.0) == 0) {
                return removedIndex == -1 ? nextIndex : removedIndex;
            }
            if (Double.compare(keyAtIndex, 1.0) != 0 || removedIndex != -1) continue;
            removedIndex = nextIndex;
        }
        return this.probeTwo(element, removedIndex);
    }

    int probeTwo(double element, int removedIndex) {
        int index = this.spreadTwoAndMask(element) << 1;
        for (int i = 0; i < 4; i += 2) {
            int nextIndex = index + i & this.keysValues.length - 1;
            double keyAtIndex = this.keysValues[nextIndex];
            if (Double.compare(keyAtIndex, element) == 0) {
                return nextIndex;
            }
            if (Double.compare(keyAtIndex, 0.0) == 0) {
                return removedIndex == -1 ? nextIndex : removedIndex;
            }
            if (Double.compare(keyAtIndex, 1.0) != 0 || removedIndex != -1) continue;
            removedIndex = nextIndex;
        }
        return this.probeThree(element, removedIndex);
    }

    int probeThree(double element, int removedIndex) {
        int nextIndex = (int)SpreadFunctions.doubleSpreadOne(element) << 1;
        int spreadTwo = (int)Long.reverse(SpreadFunctions.doubleSpreadTwo(element)) | 1;
        double keyAtIndex;
        while (Double.compare(keyAtIndex = this.keysValues[nextIndex = this.mask((nextIndex >> 1) + spreadTwo) << 1], element) != 0) {
            if (Double.compare(keyAtIndex, 0.0) == 0) {
                return removedIndex == -1 ? nextIndex : removedIndex;
            }
            if (Double.compare(keyAtIndex, 1.0) != 0 || removedIndex != -1) continue;
            removedIndex = nextIndex;
        }
        return nextIndex;
    }

    int spreadAndMask(double element) {
        long code = SpreadFunctions.doubleSpreadOne(element);
        return this.mask((int)code);
    }

    int spreadTwoAndMask(double element) {
        long code = SpreadFunctions.doubleSpreadTwo(element);
        return this.mask((int)code);
    }

    private int mask(int spread) {
        return spread & (this.keysValues.length >> 1) - 1;
    }

    protected void allocateTable(int sizeToAllocate) {
        this.keysValues = new double[sizeToAllocate << 1];
    }

    private static boolean isEmptyKey(double key) {
        return Double.compare(key, 0.0) == 0;
    }

    private static boolean isRemovedKey(double key) {
        return Double.compare(key, 1.0) == 0;
    }

    private static boolean isNonSentinel(double key) {
        return !DoubleDoubleHashMap.isEmptyKey(key) && !DoubleDoubleHashMap.isRemovedKey(key);
    }

    @Override
    protected boolean isNonSentinelAtIndex(int index) {
        return !DoubleDoubleHashMap.isEmptyKey(this.keysValues[index * 2]) && !DoubleDoubleHashMap.isRemovedKey(this.keysValues[index * 2]);
    }

    private int maxOccupiedWithData() {
        return this.keysValues.length >> 2;
    }

    @Override
    public MutableDoubleSet keySet() {
        return new KeySet();
    }

    @Override
    public MutableDoubleCollection values() {
        return new ValuesCollection();
    }

    static /* synthetic */ double[] access$302(DoubleDoubleHashMap x0, double[] x1) {
        x0.keysValues = x1;
        return x1;
    }

    private class KeyValuesView
    extends AbstractLazyIterable<DoubleDoublePair> {
        private KeyValuesView() {
        }

        @Override
        public void each(Procedure<? super DoubleDoublePair> procedure) {
            if (DoubleDoubleHashMap.this.sentinelValues != null) {
                if (((DoubleDoubleHashMap)DoubleDoubleHashMap.this).sentinelValues.containsZeroKey) {
                    procedure.value(PrimitiveTuples.pair(0.0, ((DoubleDoubleHashMap)DoubleDoubleHashMap.this).sentinelValues.zeroValue));
                }
                if (((DoubleDoubleHashMap)DoubleDoubleHashMap.this).sentinelValues.containsOneKey) {
                    procedure.value(PrimitiveTuples.pair(1.0, ((DoubleDoubleHashMap)DoubleDoubleHashMap.this).sentinelValues.oneValue));
                }
            }
            for (int i = 0; i < DoubleDoubleHashMap.this.keysValues.length; i += 2) {
                if (!DoubleDoubleHashMap.isNonSentinel(DoubleDoubleHashMap.this.keysValues[i])) continue;
                procedure.value(PrimitiveTuples.pair(DoubleDoubleHashMap.this.keysValues[i], DoubleDoubleHashMap.this.keysValues[i + 1]));
            }
        }

        @Override
        public void forEachWithIndex(ObjectIntProcedure<? super DoubleDoublePair> objectIntProcedure) {
            int index = 0;
            if (DoubleDoubleHashMap.this.sentinelValues != null) {
                if (((DoubleDoubleHashMap)DoubleDoubleHashMap.this).sentinelValues.containsZeroKey) {
                    objectIntProcedure.value(PrimitiveTuples.pair(0.0, ((DoubleDoubleHashMap)DoubleDoubleHashMap.this).sentinelValues.zeroValue), index);
                    ++index;
                }
                if (((DoubleDoubleHashMap)DoubleDoubleHashMap.this).sentinelValues.containsOneKey) {
                    objectIntProcedure.value(PrimitiveTuples.pair(1.0, ((DoubleDoubleHashMap)DoubleDoubleHashMap.this).sentinelValues.oneValue), index);
                    ++index;
                }
            }
            for (int i = 0; i < DoubleDoubleHashMap.this.keysValues.length; i += 2) {
                if (!DoubleDoubleHashMap.isNonSentinel(DoubleDoubleHashMap.this.keysValues[i])) continue;
                objectIntProcedure.value(PrimitiveTuples.pair(DoubleDoubleHashMap.this.keysValues[i], DoubleDoubleHashMap.this.keysValues[i + 1]), index);
                ++index;
            }
        }

        @Override
        public <P> void forEachWith(Procedure2<? super DoubleDoublePair, ? super P> procedure, P parameter) {
            if (DoubleDoubleHashMap.this.sentinelValues != null) {
                if (((DoubleDoubleHashMap)DoubleDoubleHashMap.this).sentinelValues.containsZeroKey) {
                    procedure.value(PrimitiveTuples.pair(0.0, ((DoubleDoubleHashMap)DoubleDoubleHashMap.this).sentinelValues.zeroValue), parameter);
                }
                if (((DoubleDoubleHashMap)DoubleDoubleHashMap.this).sentinelValues.containsOneKey) {
                    procedure.value(PrimitiveTuples.pair(1.0, ((DoubleDoubleHashMap)DoubleDoubleHashMap.this).sentinelValues.oneValue), parameter);
                }
            }
            for (int i = 0; i < DoubleDoubleHashMap.this.keysValues.length; i += 2) {
                if (!DoubleDoubleHashMap.isNonSentinel(DoubleDoubleHashMap.this.keysValues[i])) continue;
                procedure.value(PrimitiveTuples.pair(DoubleDoubleHashMap.this.keysValues[i], DoubleDoubleHashMap.this.keysValues[i + 1]), parameter);
            }
        }

        @Override
        public Iterator<DoubleDoublePair> iterator() {
            return new InternalKeyValuesIterator();
        }

        public class InternalKeyValuesIterator
        implements Iterator<DoubleDoublePair> {
            private int count;
            private int position;
            private boolean handledZero;
            private boolean handledOne;

            @Override
            public DoubleDoublePair next() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException("next() called, but the iterator is exhausted");
                }
                ++this.count;
                if (!this.handledZero) {
                    this.handledZero = true;
                    if (DoubleDoubleHashMap.this.containsKey(0.0)) {
                        return PrimitiveTuples.pair(0.0, ((DoubleDoubleHashMap)DoubleDoubleHashMap.this).sentinelValues.zeroValue);
                    }
                }
                if (!this.handledOne) {
                    this.handledOne = true;
                    if (DoubleDoubleHashMap.this.containsKey(1.0)) {
                        return PrimitiveTuples.pair(1.0, ((DoubleDoubleHashMap)DoubleDoubleHashMap.this).sentinelValues.oneValue);
                    }
                }
                double[] keys = DoubleDoubleHashMap.this.keysValues;
                while (!DoubleDoubleHashMap.isNonSentinel(keys[this.position])) {
                    this.position += 2;
                }
                DoubleDoublePair result = PrimitiveTuples.pair(keys[this.position], DoubleDoubleHashMap.this.keysValues[this.position + 1]);
                this.position += 2;
                return result;
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException("Cannot call remove() on " + this.getClass().getSimpleName());
            }

            @Override
            public boolean hasNext() {
                return this.count != DoubleDoubleHashMap.this.size();
            }
        }
    }

    private class ValuesCollection
    extends AbstractMutableDoubleValuesMap.AbstractDoubleValuesCollection {
        private ValuesCollection() {
        }

        @Override
        public MutableDoubleIterator doubleIterator() {
            return DoubleDoubleHashMap.this.doubleIterator();
        }

        @Override
        public boolean remove(double item) {
            int oldSize = DoubleDoubleHashMap.this.size();
            if (DoubleDoubleHashMap.this.sentinelValues != null && ((DoubleDoubleHashMap)DoubleDoubleHashMap.this).sentinelValues.containsZeroKey && Double.compare(item, ((DoubleDoubleHashMap)DoubleDoubleHashMap.this).sentinelValues.zeroValue) == 0) {
                DoubleDoubleHashMap.this.removeKey(0.0);
            }
            if (DoubleDoubleHashMap.this.sentinelValues != null && ((DoubleDoubleHashMap)DoubleDoubleHashMap.this).sentinelValues.containsOneKey && Double.compare(item, ((DoubleDoubleHashMap)DoubleDoubleHashMap.this).sentinelValues.oneValue) == 0) {
                DoubleDoubleHashMap.this.removeKey(1.0);
            }
            for (int i = 0; i < DoubleDoubleHashMap.this.keysValues.length; i += 2) {
                if (!DoubleDoubleHashMap.isNonSentinel(DoubleDoubleHashMap.this.keysValues[i]) || Double.compare(item, DoubleDoubleHashMap.this.keysValues[i + 1]) != 0) continue;
                DoubleDoubleHashMap.this.removeKey(DoubleDoubleHashMap.this.keysValues[i]);
            }
            return oldSize != DoubleDoubleHashMap.this.size();
        }

        @Override
        public boolean retainAll(DoubleIterable source) {
            int oldSize = DoubleDoubleHashMap.this.size();
            DoubleSet sourceSet = source instanceof DoubleSet ? (DoubleSet)source : source.toSet();
            DoubleDoubleHashMap retained = DoubleDoubleHashMap.this.select((double key, double value) -> sourceSet.contains(value));
            if (retained.size() != oldSize) {
                DoubleDoubleHashMap.access$302(DoubleDoubleHashMap.this, retained.keysValues);
                DoubleDoubleHashMap.this.sentinelValues = retained.sentinelValues;
                DoubleDoubleHashMap.this.occupiedWithData = retained.occupiedWithData;
                DoubleDoubleHashMap.this.occupiedWithSentinels = retained.occupiedWithSentinels;
                return true;
            }
            return false;
        }

        @Override
        public MutableDoubleCollection newEmpty() {
            return new DoubleHashBag();
        }
    }

    private class KeySet
    extends AbstractMutableDoubleKeySet {
        private KeySet() {
        }

        @Override
        protected MutableDoubleKeysMap getOuter() {
            return DoubleDoubleHashMap.this;
        }

        @Override
        protected AbstractMutableDoubleValuesMap.SentinelValues getSentinelValues() {
            return DoubleDoubleHashMap.this.sentinelValues;
        }

        @Override
        protected double getKeyAtIndex(int index) {
            return DoubleDoubleHashMap.this.keysValues[index * 2];
        }

        @Override
        protected int getTableSize() {
            return DoubleDoubleHashMap.this.keysValues.length / 2;
        }

        @Override
        public MutableDoubleIterator doubleIterator() {
            return new KeySetIterator();
        }

        @Override
        public boolean retainAll(DoubleIterable source) {
            int oldSize = DoubleDoubleHashMap.this.size();
            DoubleSet sourceSet = source instanceof DoubleSet ? (DoubleSet)source : source.toSet();
            DoubleDoubleHashMap retained = DoubleDoubleHashMap.this.select((double key, double value) -> sourceSet.contains(key));
            if (retained.size() != oldSize) {
                DoubleDoubleHashMap.access$302(DoubleDoubleHashMap.this, retained.keysValues);
                DoubleDoubleHashMap.this.sentinelValues = retained.sentinelValues;
                DoubleDoubleHashMap.this.occupiedWithData = retained.occupiedWithData;
                DoubleDoubleHashMap.this.occupiedWithSentinels = retained.occupiedWithSentinels;
                return true;
            }
            return false;
        }

        @Override
        public boolean retainAll(double ... source) {
            return this.retainAll(DoubleHashSet.newSetWith(source));
        }

        @Override
        public DoubleSet freeze() {
            DoubleDoubleHashMap.this.copyKeysOnWrite = true;
            boolean containsZeroKey = false;
            boolean containsOneKey = false;
            if (DoubleDoubleHashMap.this.sentinelValues != null) {
                containsZeroKey = ((DoubleDoubleHashMap)DoubleDoubleHashMap.this).sentinelValues.containsZeroKey;
                containsOneKey = ((DoubleDoubleHashMap)DoubleDoubleHashMap.this).sentinelValues.containsOneKey;
            }
            return new ImmutableDoubleDoubleMapKeySet(DoubleDoubleHashMap.this.keysValues, DoubleDoubleHashMap.this.occupiedWithData, containsZeroKey, containsOneKey);
        }

        @Override
        public MutableDoubleSet newEmpty() {
            return new DoubleHashSet();
        }
    }

    private class KeySetIterator
    implements MutableDoubleIterator {
        private int count;
        private int position;
        private double lastKey;
        private boolean handledZero;
        private boolean handledOne;
        private boolean canRemove;

        private KeySetIterator() {
        }

        @Override
        public boolean hasNext() {
            return this.count < DoubleDoubleHashMap.this.size();
        }

        @Override
        public double next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException("next() called, but the iterator is exhausted");
            }
            ++this.count;
            this.canRemove = true;
            if (!this.handledZero) {
                this.handledZero = true;
                if (DoubleDoubleHashMap.this.containsKey(0.0)) {
                    this.lastKey = 0.0;
                    return this.lastKey;
                }
            }
            if (!this.handledOne) {
                this.handledOne = true;
                if (DoubleDoubleHashMap.this.containsKey(1.0)) {
                    this.lastKey = 1.0;
                    return this.lastKey;
                }
            }
            double[] keys = DoubleDoubleHashMap.this.keysValues;
            while (!DoubleDoubleHashMap.isNonSentinel(keys[this.position])) {
                this.position += 2;
            }
            this.lastKey = keys[this.position];
            this.position += 2;
            return this.lastKey;
        }

        @Override
        public void remove() {
            if (!this.canRemove) {
                throw new IllegalStateException();
            }
            DoubleDoubleHashMap.this.removeKey(this.lastKey);
            --this.count;
            this.canRemove = false;
        }
    }

    private class KeysView
    extends AbstractLazyDoubleIterable {
        private KeysView() {
        }

        @Override
        public DoubleIterator doubleIterator() {
            return new UnmodifiableDoubleIterator(new KeySetIterator());
        }

        @Override
        public void each(DoubleProcedure procedure) {
            DoubleDoubleHashMap.this.forEachKey(procedure);
        }
    }

    private class InternalDoubleIterator
    implements MutableDoubleIterator {
        private int count;
        private int position;
        private double lastKey;
        private boolean handledZero;
        private boolean handledOne;
        private boolean canRemove;

        private InternalDoubleIterator() {
        }

        @Override
        public boolean hasNext() {
            return this.count < DoubleDoubleHashMap.this.size();
        }

        @Override
        public double next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException("next() called, but the iterator is exhausted");
            }
            ++this.count;
            this.canRemove = true;
            if (!this.handledZero) {
                this.handledZero = true;
                if (DoubleDoubleHashMap.this.containsKey(0.0)) {
                    this.lastKey = 0.0;
                    return DoubleDoubleHashMap.this.get(0.0);
                }
            }
            if (!this.handledOne) {
                this.handledOne = true;
                if (DoubleDoubleHashMap.this.containsKey(1.0)) {
                    this.lastKey = 1.0;
                    return DoubleDoubleHashMap.this.get(1.0);
                }
            }
            double[] keys = DoubleDoubleHashMap.this.keysValues;
            while (!DoubleDoubleHashMap.isNonSentinel(keys[this.position])) {
                this.position += 2;
            }
            this.lastKey = keys[this.position];
            double result = DoubleDoubleHashMap.this.keysValues[this.position + 1];
            this.position += 2;
            return result;
        }

        @Override
        public void remove() {
            if (!this.canRemove) {
                throw new IllegalStateException();
            }
            DoubleDoubleHashMap.this.removeKey(this.lastKey);
            --this.count;
            this.canRemove = false;
        }
    }
}

