/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.collections.impl.map.immutable.primitive;

import org.eclipse.collections.api.block.function.primitive.ByteFunction;
import org.eclipse.collections.api.block.function.primitive.ShortFunction;
import org.eclipse.collections.api.factory.map.primitive.ImmutableShortByteMapFactory;
import org.eclipse.collections.api.map.primitive.ImmutableShortByteMap;
import org.eclipse.collections.api.map.primitive.ShortByteMap;
import org.eclipse.collections.impl.factory.primitive.ShortByteMaps;
import org.eclipse.collections.impl.map.immutable.primitive.ImmutableShortByteEmptyMap;
import org.eclipse.collections.impl.map.immutable.primitive.ImmutableShortByteHashMap;
import org.eclipse.collections.impl.map.immutable.primitive.ImmutableShortByteSingletonMap;

public class ImmutableShortByteMapFactoryImpl
implements ImmutableShortByteMapFactory {
    public static final ImmutableShortByteMapFactory INSTANCE = new ImmutableShortByteMapFactoryImpl();

    @Override
    public ImmutableShortByteMap empty() {
        return ImmutableShortByteEmptyMap.INSTANCE;
    }

    @Override
    public ImmutableShortByteMap of() {
        return this.empty();
    }

    @Override
    public ImmutableShortByteMap with() {
        return this.empty();
    }

    @Override
    public ImmutableShortByteMap of(short key, byte value) {
        return this.with(key, value);
    }

    @Override
    public ImmutableShortByteMap with(short key, byte value) {
        return new ImmutableShortByteSingletonMap(key, value);
    }

    @Override
    public ImmutableShortByteMap ofAll(ShortByteMap map2) {
        return this.withAll(map2);
    }

    @Override
    public ImmutableShortByteMap withAll(ShortByteMap map2) {
        if (map2 instanceof ImmutableShortByteMap) {
            return (ImmutableShortByteMap)map2;
        }
        if (map2.isEmpty()) {
            return this.with();
        }
        if (map2.size() == 1) {
            short key = map2.keysView().shortIterator().next();
            return new ImmutableShortByteSingletonMap(key, map2.get(key));
        }
        return new ImmutableShortByteHashMap(map2);
    }

    @Override
    public <T> ImmutableShortByteMap from(Iterable<T> iterable, ShortFunction<? super T> keyFunction, ByteFunction<? super T> valueFunction) {
        return ShortByteMaps.mutable.from(iterable, keyFunction, valueFunction).toImmutable();
    }
}

