/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.collections.impl.map.immutable.primitive;

import org.eclipse.collections.api.block.function.Function;
import org.eclipse.collections.api.block.function.primitive.IntFunction;
import org.eclipse.collections.api.factory.map.primitive.ImmutableObjectIntMapFactory;
import org.eclipse.collections.api.map.primitive.ImmutableObjectIntMap;
import org.eclipse.collections.api.map.primitive.MutableObjectIntMap;
import org.eclipse.collections.api.map.primitive.ObjectIntMap;
import org.eclipse.collections.impl.factory.primitive.ObjectIntMaps;
import org.eclipse.collections.impl.map.immutable.primitive.ImmutableObjectIntEmptyMap;
import org.eclipse.collections.impl.map.immutable.primitive.ImmutableObjectIntHashMap;
import org.eclipse.collections.impl.map.immutable.primitive.ImmutableObjectIntSingletonMap;

public class ImmutableObjectIntMapFactoryImpl
implements ImmutableObjectIntMapFactory {
    public static final ImmutableObjectIntMapFactory INSTANCE = new ImmutableObjectIntMapFactoryImpl();

    @Override
    public <K> ImmutableObjectIntMap<K> empty() {
        return ImmutableObjectIntEmptyMap.INSTANCE;
    }

    @Override
    public <K> ImmutableObjectIntMap<K> of() {
        return this.empty();
    }

    @Override
    public <K> ImmutableObjectIntMap<K> with() {
        return this.empty();
    }

    @Override
    public <K> ImmutableObjectIntMap<K> of(K key, int value) {
        return this.with(key, value);
    }

    @Override
    public <K> ImmutableObjectIntMap<K> with(K key, int value) {
        return new ImmutableObjectIntSingletonMap<K>(key, value);
    }

    @Override
    public <K> ImmutableObjectIntMap<K> ofAll(ObjectIntMap<? extends K> map2) {
        return this.withAll(map2);
    }

    @Override
    public <K> ImmutableObjectIntMap<K> withAll(ObjectIntMap<? extends K> map2) {
        if (map2 instanceof ImmutableObjectIntMap) {
            return (ImmutableObjectIntMap)map2;
        }
        if (map2.isEmpty()) {
            return this.with();
        }
        if (map2.size() == 1) {
            Object[] array = new Object[1];
            map2.forEachKey(each2 -> {
                array[0] = each2;
            });
            return new ImmutableObjectIntSingletonMap<Object>(array[0], map2.get(array[0]));
        }
        return new ImmutableObjectIntHashMap<K>(map2);
    }

    @Override
    public <T, K> ImmutableObjectIntMap<K> from(Iterable<T> iterable, Function<? super T, ? extends K> keyFunction, IntFunction<? super T> valueFunction) {
        MutableObjectIntMap<K> map2 = ObjectIntMaps.mutable.from(iterable, keyFunction, valueFunction);
        return map2.toImmutable();
    }
}

