/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.collections.impl.map.immutable.primitive;

import org.eclipse.collections.api.block.function.Function;
import org.eclipse.collections.api.block.function.primitive.DoubleFunction;
import org.eclipse.collections.api.factory.map.primitive.ImmutableObjectDoubleMapFactory;
import org.eclipse.collections.api.map.primitive.ImmutableObjectDoubleMap;
import org.eclipse.collections.api.map.primitive.MutableObjectDoubleMap;
import org.eclipse.collections.api.map.primitive.ObjectDoubleMap;
import org.eclipse.collections.impl.factory.primitive.ObjectDoubleMaps;
import org.eclipse.collections.impl.map.immutable.primitive.ImmutableObjectDoubleEmptyMap;
import org.eclipse.collections.impl.map.immutable.primitive.ImmutableObjectDoubleHashMap;
import org.eclipse.collections.impl.map.immutable.primitive.ImmutableObjectDoubleSingletonMap;

public class ImmutableObjectDoubleMapFactoryImpl
implements ImmutableObjectDoubleMapFactory {
    public static final ImmutableObjectDoubleMapFactory INSTANCE = new ImmutableObjectDoubleMapFactoryImpl();

    @Override
    public <K> ImmutableObjectDoubleMap<K> empty() {
        return ImmutableObjectDoubleEmptyMap.INSTANCE;
    }

    @Override
    public <K> ImmutableObjectDoubleMap<K> of() {
        return this.empty();
    }

    @Override
    public <K> ImmutableObjectDoubleMap<K> with() {
        return this.empty();
    }

    @Override
    public <K> ImmutableObjectDoubleMap<K> of(K key, double value) {
        return this.with(key, value);
    }

    @Override
    public <K> ImmutableObjectDoubleMap<K> with(K key, double value) {
        return new ImmutableObjectDoubleSingletonMap<K>(key, value);
    }

    @Override
    public <K> ImmutableObjectDoubleMap<K> ofAll(ObjectDoubleMap<? extends K> map2) {
        return this.withAll(map2);
    }

    @Override
    public <K> ImmutableObjectDoubleMap<K> withAll(ObjectDoubleMap<? extends K> map2) {
        if (map2 instanceof ImmutableObjectDoubleMap) {
            return (ImmutableObjectDoubleMap)map2;
        }
        if (map2.isEmpty()) {
            return this.with();
        }
        if (map2.size() == 1) {
            Object[] array = new Object[1];
            map2.forEachKey(each2 -> {
                array[0] = each2;
            });
            return new ImmutableObjectDoubleSingletonMap<Object>(array[0], map2.get(array[0]));
        }
        return new ImmutableObjectDoubleHashMap<K>(map2);
    }

    @Override
    public <T, K> ImmutableObjectDoubleMap<K> from(Iterable<T> iterable, Function<? super T, ? extends K> keyFunction, DoubleFunction<? super T> valueFunction) {
        MutableObjectDoubleMap<K> map2 = ObjectDoubleMaps.mutable.from(iterable, keyFunction, valueFunction);
        return map2.toImmutable();
    }
}

