/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.collections.impl.map.immutable.primitive;

import org.eclipse.collections.api.block.function.primitive.DoubleFunction;
import org.eclipse.collections.api.block.function.primitive.IntFunction;
import org.eclipse.collections.api.factory.map.primitive.ImmutableDoubleIntMapFactory;
import org.eclipse.collections.api.map.primitive.DoubleIntMap;
import org.eclipse.collections.api.map.primitive.ImmutableDoubleIntMap;
import org.eclipse.collections.impl.factory.primitive.DoubleIntMaps;
import org.eclipse.collections.impl.map.immutable.primitive.ImmutableDoubleIntEmptyMap;
import org.eclipse.collections.impl.map.immutable.primitive.ImmutableDoubleIntHashMap;
import org.eclipse.collections.impl.map.immutable.primitive.ImmutableDoubleIntSingletonMap;

public class ImmutableDoubleIntMapFactoryImpl
implements ImmutableDoubleIntMapFactory {
    public static final ImmutableDoubleIntMapFactory INSTANCE = new ImmutableDoubleIntMapFactoryImpl();

    @Override
    public ImmutableDoubleIntMap empty() {
        return ImmutableDoubleIntEmptyMap.INSTANCE;
    }

    @Override
    public ImmutableDoubleIntMap of() {
        return this.empty();
    }

    @Override
    public ImmutableDoubleIntMap with() {
        return this.empty();
    }

    @Override
    public ImmutableDoubleIntMap of(double key, int value) {
        return this.with(key, value);
    }

    @Override
    public ImmutableDoubleIntMap with(double key, int value) {
        return new ImmutableDoubleIntSingletonMap(key, value);
    }

    @Override
    public ImmutableDoubleIntMap ofAll(DoubleIntMap map2) {
        return this.withAll(map2);
    }

    @Override
    public ImmutableDoubleIntMap withAll(DoubleIntMap map2) {
        if (map2 instanceof ImmutableDoubleIntMap) {
            return (ImmutableDoubleIntMap)map2;
        }
        if (map2.isEmpty()) {
            return this.with();
        }
        if (map2.size() == 1) {
            double key = map2.keysView().doubleIterator().next();
            return new ImmutableDoubleIntSingletonMap(key, map2.get(key));
        }
        return new ImmutableDoubleIntHashMap(map2);
    }

    @Override
    public <T> ImmutableDoubleIntMap from(Iterable<T> iterable, DoubleFunction<? super T> keyFunction, IntFunction<? super T> valueFunction) {
        return DoubleIntMaps.mutable.from(iterable, keyFunction, valueFunction).toImmutable();
    }
}

