/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.collections.impl.map.immutable.primitive;

import org.eclipse.collections.api.block.function.primitive.CharFunction;
import org.eclipse.collections.api.factory.map.primitive.ImmutableCharCharMapFactory;
import org.eclipse.collections.api.map.primitive.CharCharMap;
import org.eclipse.collections.api.map.primitive.ImmutableCharCharMap;
import org.eclipse.collections.impl.factory.primitive.CharCharMaps;
import org.eclipse.collections.impl.map.immutable.primitive.ImmutableCharCharEmptyMap;
import org.eclipse.collections.impl.map.immutable.primitive.ImmutableCharCharHashMap;
import org.eclipse.collections.impl.map.immutable.primitive.ImmutableCharCharSingletonMap;

public class ImmutableCharCharMapFactoryImpl
implements ImmutableCharCharMapFactory {
    public static final ImmutableCharCharMapFactory INSTANCE = new ImmutableCharCharMapFactoryImpl();

    @Override
    public ImmutableCharCharMap empty() {
        return ImmutableCharCharEmptyMap.INSTANCE;
    }

    @Override
    public ImmutableCharCharMap of() {
        return this.empty();
    }

    @Override
    public ImmutableCharCharMap with() {
        return this.empty();
    }

    @Override
    public ImmutableCharCharMap of(char key, char value) {
        return this.with(key, value);
    }

    @Override
    public ImmutableCharCharMap with(char key, char value) {
        return new ImmutableCharCharSingletonMap(key, value);
    }

    @Override
    public ImmutableCharCharMap ofAll(CharCharMap map2) {
        return this.withAll(map2);
    }

    @Override
    public ImmutableCharCharMap withAll(CharCharMap map2) {
        if (map2 instanceof ImmutableCharCharMap) {
            return (ImmutableCharCharMap)map2;
        }
        if (map2.isEmpty()) {
            return this.with();
        }
        if (map2.size() == 1) {
            char key = map2.keysView().charIterator().next();
            return new ImmutableCharCharSingletonMap(key, map2.get(key));
        }
        return new ImmutableCharCharHashMap(map2);
    }

    @Override
    public <T> ImmutableCharCharMap from(Iterable<T> iterable, CharFunction<? super T> keyFunction, CharFunction<? super T> valueFunction) {
        return CharCharMaps.mutable.from(iterable, keyFunction, valueFunction).toImmutable();
    }
}

