/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.collections.impl.map.immutable.primitive;

import org.eclipse.collections.api.block.function.Function;
import org.eclipse.collections.api.block.function.primitive.ByteFunction;
import org.eclipse.collections.api.factory.map.primitive.ImmutableByteObjectMapFactory;
import org.eclipse.collections.api.map.primitive.ByteObjectMap;
import org.eclipse.collections.api.map.primitive.ImmutableByteObjectMap;
import org.eclipse.collections.api.map.primitive.MutableByteObjectMap;
import org.eclipse.collections.impl.factory.primitive.ByteObjectMaps;
import org.eclipse.collections.impl.map.immutable.primitive.ImmutableByteObjectEmptyMap;
import org.eclipse.collections.impl.map.immutable.primitive.ImmutableByteObjectHashMap;
import org.eclipse.collections.impl.map.immutable.primitive.ImmutableByteObjectSingletonMap;

public class ImmutableByteObjectMapFactoryImpl
implements ImmutableByteObjectMapFactory {
    public static final ImmutableByteObjectMapFactory INSTANCE = new ImmutableByteObjectMapFactoryImpl();

    @Override
    public <V> ImmutableByteObjectMap<V> empty() {
        return ImmutableByteObjectEmptyMap.INSTANCE;
    }

    @Override
    public <V> ImmutableByteObjectMap<V> of() {
        return this.empty();
    }

    @Override
    public <V> ImmutableByteObjectMap<V> with() {
        return this.empty();
    }

    @Override
    public <V> ImmutableByteObjectMap<V> of(byte key, V value) {
        return this.with(key, value);
    }

    @Override
    public <V> ImmutableByteObjectMap<V> with(byte key, V value) {
        return new ImmutableByteObjectSingletonMap<V>(key, value);
    }

    @Override
    public <V> ImmutableByteObjectMap<V> ofAll(ByteObjectMap<? extends V> map2) {
        return this.withAll(map2);
    }

    @Override
    public <V> ImmutableByteObjectMap<V> withAll(ByteObjectMap<? extends V> map2) {
        if (map2 instanceof ImmutableByteObjectMap) {
            return (ImmutableByteObjectMap)map2;
        }
        if (map2.isEmpty()) {
            return this.with();
        }
        if (map2.size() == 1) {
            byte[] array = new byte[1];
            map2.forEachKey(each2 -> {
                array[0] = each2;
            });
            return new ImmutableByteObjectSingletonMap<V>(array[0], map2.get(array[0]));
        }
        return new ImmutableByteObjectHashMap<V>(map2);
    }

    @Override
    public <T, V> ImmutableByteObjectMap<V> from(Iterable<T> iterable, ByteFunction<? super T> keyFunction, Function<? super T, ? extends V> valueFunction) {
        MutableByteObjectMap<V> map2 = ByteObjectMaps.mutable.from(iterable, keyFunction, valueFunction);
        return map2.toImmutable();
    }
}

