/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.collections.impl.list.mutable.primitive;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Spliterator;
import java.util.Spliterators;
import org.eclipse.collections.api.LazyLongIterable;
import org.eclipse.collections.api.LongIterable;
import org.eclipse.collections.api.RichIterable;
import org.eclipse.collections.api.block.comparator.primitive.LongComparator;
import org.eclipse.collections.api.block.function.primitive.LongToObjectFunction;
import org.eclipse.collections.api.block.function.primitive.ObjectLongIntToObjectFunction;
import org.eclipse.collections.api.block.function.primitive.ObjectLongToObjectFunction;
import org.eclipse.collections.api.block.predicate.primitive.LongPredicate;
import org.eclipse.collections.api.block.procedure.primitive.LongIntProcedure;
import org.eclipse.collections.api.block.procedure.primitive.LongProcedure;
import org.eclipse.collections.api.collection.primitive.MutableLongCollection;
import org.eclipse.collections.api.factory.Lists;
import org.eclipse.collections.api.iterator.LongIterator;
import org.eclipse.collections.api.iterator.MutableLongIterator;
import org.eclipse.collections.api.list.MutableList;
import org.eclipse.collections.api.list.primitive.ImmutableLongList;
import org.eclipse.collections.api.list.primitive.LongList;
import org.eclipse.collections.api.list.primitive.MutableLongList;
import org.eclipse.collections.api.set.primitive.LongSet;
import org.eclipse.collections.api.tuple.primitive.LongLongPair;
import org.eclipse.collections.api.tuple.primitive.LongObjectPair;
import org.eclipse.collections.impl.factory.primitive.LongLists;
import org.eclipse.collections.impl.lazy.primitive.ReverseLongIterable;
import org.eclipse.collections.impl.list.mutable.primitive.SynchronizedLongList;
import org.eclipse.collections.impl.list.mutable.primitive.UnmodifiableLongList;
import org.eclipse.collections.impl.primitive.AbstractLongIterable;
import org.eclipse.collections.impl.set.mutable.primitive.LongHashSet;
import org.eclipse.collections.impl.tuple.primitive.PrimitiveTuples;
import org.eclipse.collections.impl.utility.Iterate;
import org.eclipse.collections.impl.utility.primitive.LongQuickSort;

public class LongArrayList
extends AbstractLongIterable
implements MutableLongList,
Externalizable {
    private static final long serialVersionUID = 1L;
    private static final long[] DEFAULT_SIZED_EMPTY_ARRAY = new long[0];
    private static final long[] ZERO_SIZED_ARRAY = new long[0];
    private static final int MAXIMUM_ARRAY_SIZE = 0x7FFFFFF7;
    protected int size;
    protected transient long[] items = DEFAULT_SIZED_EMPTY_ARRAY;

    public LongArrayList() {
    }

    public LongArrayList(int initialCapacity) {
        this.items = initialCapacity == 0 ? ZERO_SIZED_ARRAY : new long[initialCapacity];
    }

    public LongArrayList(long ... array) {
        this.size = array.length;
        this.items = array;
    }

    public static LongArrayList newListWith(long ... elements) {
        return new LongArrayList(elements);
    }

    public static LongArrayList newList(LongIterable source) {
        return LongArrayList.newListWith(source.toArray());
    }

    public static LongArrayList newWithNValues(int size2, long value) {
        LongArrayList newList = new LongArrayList(size2);
        newList.size = size2;
        Arrays.fill(newList.items, value);
        return newList;
    }

    public static LongArrayList wrapCopy(long ... array) {
        long[] newArray = new long[array.length];
        System.arraycopy(array, 0, newArray, 0, array.length);
        return new LongArrayList(newArray);
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public void clear() {
        Arrays.fill(this.items, 0, this.size, 0L);
        this.size = 0;
    }

    @Override
    public boolean contains(long value) {
        for (int i = 0; i < this.size; ++i) {
            if (this.items[i] != value) continue;
            return true;
        }
        return false;
    }

    @Override
    public long get(int index) {
        if (index < this.size) {
            return this.items[index];
        }
        throw this.newIndexOutOfBoundsException(index);
    }

    private IndexOutOfBoundsException newIndexOutOfBoundsException(int index) {
        return new IndexOutOfBoundsException("Index: " + index + " Size: " + this.size);
    }

    @Override
    public long getFirst() {
        this.checkEmpty();
        return this.items[0];
    }

    @Override
    public long getLast() {
        this.checkEmpty();
        return this.items[this.size() - 1];
    }

    private void checkEmpty() {
        if (this.isEmpty()) {
            throw this.newIndexOutOfBoundsException(0);
        }
    }

    @Override
    public int indexOf(long value) {
        for (int i = 0; i < this.size; ++i) {
            if (this.items[i] != value) continue;
            return i;
        }
        return -1;
    }

    @Override
    public int lastIndexOf(long value) {
        for (int i = this.size - 1; i >= 0; --i) {
            if (this.items[i] != value) continue;
            return i;
        }
        return -1;
    }

    public void trimToSize() {
        if (this.size < this.items.length) {
            this.transferItemsToNewArrayWithCapacity(this.size);
        }
    }

    private void transferItemsToNewArrayWithCapacity(int newCapacity) {
        this.items = this.copyItemsWithNewCapacity(newCapacity);
    }

    private long[] copyItemsWithNewCapacity(int newCapacity) {
        long[] newItems = new long[newCapacity];
        System.arraycopy(this.items, 0, newItems, 0, Math.min(this.size, newCapacity));
        return newItems;
    }

    private int sizePlusFiftyPercent(int oldSize) {
        int result = oldSize + (oldSize >> 1) + 1;
        return result < oldSize ? 0x7FFFFFF7 : result;
    }

    public void ensureCapacity(int minCapacity) {
        int oldCapacity = this.items.length;
        if (minCapacity > oldCapacity) {
            int newCapacity = Math.max(this.sizePlusFiftyPercent(oldCapacity), minCapacity);
            this.transferItemsToNewArrayWithCapacity(newCapacity);
        }
    }

    private void ensureCapacityForAdd() {
        if (this.items == DEFAULT_SIZED_EMPTY_ARRAY) {
            this.items = new long[10];
        } else {
            this.transferItemsToNewArrayWithCapacity(this.sizePlusFiftyPercent(this.size));
        }
    }

    @Override
    public boolean add(long newItem) {
        if (this.items.length == this.size) {
            this.ensureCapacityForAdd();
        }
        this.items[this.size] = newItem;
        ++this.size;
        return true;
    }

    @Override
    public boolean addAll(long ... source) {
        if (source.length < 1) {
            return false;
        }
        this.copyItems(source.length, source);
        return true;
    }

    @Override
    public boolean addAll(LongIterable source) {
        if (source instanceof LongArrayList) {
            if (source.isEmpty()) {
                return false;
            }
            LongArrayList other = (LongArrayList)source;
            this.copyItems(other.size(), other.items);
            return true;
        }
        return this.addAll(source.toArray());
    }

    private void copyItems(int sourceSize, long[] source) {
        int newSize = this.size + sourceSize;
        this.ensureCapacity(newSize);
        System.arraycopy(source, 0, this.items, this.size, sourceSize);
        this.size = newSize;
    }

    private void throwOutOfBounds(int index) {
        throw this.newIndexOutOfBoundsException(index);
    }

    @Override
    public void addAtIndex(int index, long element) {
        if (index > -1 && index < this.size) {
            this.addAtIndexLessThanSize(index, element);
        } else if (index == this.size) {
            this.add(element);
        } else {
            this.throwOutOfBounds(index);
        }
    }

    private void addAtIndexLessThanSize(int index, long element) {
        int oldSize;
        if (this.items.length == (oldSize = this.size++)) {
            long[] newItems = new long[this.sizePlusFiftyPercent(oldSize)];
            if (index > 0) {
                System.arraycopy(this.items, 0, newItems, 0, index);
            }
            System.arraycopy(this.items, index, newItems, index + 1, oldSize - index);
            this.items = newItems;
        } else {
            System.arraycopy(this.items, index, this.items, index + 1, oldSize - index);
        }
        this.items[index] = element;
    }

    @Override
    public boolean addAllAtIndex(int index, long ... source) {
        if (index > this.size || index < 0) {
            this.throwOutOfBounds(index);
        }
        if (source.length == 0) {
            return false;
        }
        int sourceSize = source.length;
        int newSize = this.size + sourceSize;
        this.ensureCapacity(newSize);
        this.shiftElementsAtIndex(index, sourceSize);
        System.arraycopy(source, 0, this.items, index, sourceSize);
        this.size = newSize;
        return true;
    }

    @Override
    public boolean addAllAtIndex(int index, LongIterable source) {
        return this.addAllAtIndex(index, source.toArray());
    }

    private void shiftElementsAtIndex(int index, int sourceSize) {
        int numberToMove = this.size - index;
        if (numberToMove > 0) {
            System.arraycopy(this.items, index, this.items, index + sourceSize, numberToMove);
        }
    }

    @Override
    public boolean remove(long value) {
        int index = this.indexOf(value);
        if (index >= 0) {
            this.removeAtIndex(index);
            return true;
        }
        return false;
    }

    @Override
    public boolean removeIf(LongPredicate predicate) {
        int currentFilledIndex = 0;
        for (int i = 0; i < this.size; ++i) {
            long item = this.items[i];
            if (predicate.accept(item)) continue;
            if (currentFilledIndex != i) {
                this.items[currentFilledIndex] = item;
            }
            ++currentFilledIndex;
        }
        boolean changed = currentFilledIndex < this.size;
        this.wipeAndResetTheEnd(currentFilledIndex);
        return changed;
    }

    private void wipeAndResetTheEnd(int newCurrentFilledIndex) {
        for (int i = newCurrentFilledIndex; i < this.size; ++i) {
            this.items[i] = 0L;
        }
        this.size = newCurrentFilledIndex;
    }

    @Override
    public boolean removeAll(LongIterable source) {
        boolean modified = false;
        for (int index = 0; index < this.size; ++index) {
            if (!source.contains(this.get(index))) continue;
            this.removeAtIndex(index);
            --index;
            modified = true;
        }
        return modified;
    }

    @Override
    public boolean removeAll(long ... source) {
        LongHashSet set = LongHashSet.newSetWith(source);
        long[] newItems = new long[this.size];
        int count2 = 0;
        int oldSize = this.size;
        for (int index = 0; index < this.size; ++index) {
            if (set.contains(this.items[index])) continue;
            newItems[count2] = this.items[index];
            ++count2;
        }
        this.items = newItems;
        this.size = count2;
        return oldSize != this.size;
    }

    @Override
    public boolean retainAll(LongIterable source) {
        int oldSize = this.size();
        LongSet sourceSet = source instanceof LongSet ? (LongSet)source : source.toSet();
        LongArrayList retained = this.select(sourceSet::contains);
        this.size = retained.size;
        this.items = retained.items;
        return oldSize != this.size();
    }

    @Override
    public boolean retainAll(long ... source) {
        return this.retainAll(LongHashSet.newSetWith(source));
    }

    @Override
    public long removeAtIndex(int index) {
        long previous = this.get(index);
        int totalOffset = this.size - index - 1;
        if (totalOffset > 0) {
            System.arraycopy(this.items, index + 1, this.items, index, totalOffset);
        }
        --this.size;
        this.items[this.size] = 0L;
        return previous;
    }

    @Override
    public long set(int index, long element) {
        long previous = this.get(index);
        this.items[index] = element;
        return previous;
    }

    @Override
    public void swap(int index1, int index2) {
        long value = this.get(index1);
        this.items[index1] = this.items[index2];
        this.items[index2] = value;
    }

    @Override
    public LongArrayList with(long element) {
        this.add(element);
        return this;
    }

    @Override
    public LongArrayList without(long element) {
        this.remove(element);
        return this;
    }

    @Override
    public LongArrayList withAll(LongIterable elements) {
        this.addAll(elements.toArray());
        return this;
    }

    @Override
    public LongArrayList withoutAll(LongIterable elements) {
        this.removeAll(elements);
        return this;
    }

    public LongArrayList with(long element1, long element2) {
        this.add(element1);
        this.add(element2);
        return this;
    }

    public LongArrayList with(long element1, long element2, long element3) {
        this.add(element1);
        this.add(element2);
        this.add(element3);
        return this;
    }

    public LongArrayList with(long element1, long element2, long element3, long ... elements) {
        this.add(element1);
        this.add(element2);
        this.add(element3);
        return this.withArrayCopy(elements, 0, elements.length);
    }

    private LongArrayList withArrayCopy(long[] elements, int begin, int length) {
        this.ensureCapacity(this.size + length);
        System.arraycopy(elements, begin, this.items, this.size, length);
        this.size += length;
        return this;
    }

    @Override
    public MutableLongIterator longIterator() {
        return new InternalLongIterator();
    }

    @Override
    public void each(LongProcedure procedure) {
        for (int i = 0; i < this.size; ++i) {
            procedure.value(this.items[i]);
        }
    }

    @Override
    public void forEachWithIndex(LongIntProcedure procedure) {
        for (int i = 0; i < this.size; ++i) {
            procedure.value(this.items[i], i);
        }
    }

    @Override
    public <T> T injectInto(T injectedValue, ObjectLongToObjectFunction<? super T, ? extends T> function) {
        T result = injectedValue;
        for (int i = 0; i < this.size; ++i) {
            result = function.valueOf(result, this.items[i]);
        }
        return result;
    }

    @Override
    public <T> T injectIntoWithIndex(T injectedValue, ObjectLongIntToObjectFunction<? super T, ? extends T> function) {
        T result = injectedValue;
        for (int i = 0; i < this.size; ++i) {
            result = function.valueOf(result, this.items[i], i);
        }
        return result;
    }

    @Override
    public RichIterable<LongIterable> chunk(int size2) {
        if (size2 <= 0) {
            throw new IllegalArgumentException("Size for groups must be positive but was: " + size2);
        }
        MutableList<LongIterable> result = Lists.mutable.empty();
        if (this.notEmpty()) {
            if (this.size() <= size2) {
                result.add(LongLists.mutable.withAll(this));
            } else {
                MutableLongIterator iterator2 = this.longIterator();
                while (iterator2.hasNext()) {
                    MutableLongList batch = LongLists.mutable.empty();
                    for (int i = 0; i < size2 && iterator2.hasNext(); ++i) {
                        batch.add(iterator2.next());
                    }
                    result.add(batch);
                }
            }
        }
        return result;
    }

    @Override
    public int count(LongPredicate predicate) {
        int count2 = 0;
        for (int i = 0; i < this.size; ++i) {
            if (!predicate.accept(this.items[i])) continue;
            ++count2;
        }
        return count2;
    }

    @Override
    public boolean anySatisfy(LongPredicate predicate) {
        for (int i = 0; i < this.size; ++i) {
            if (!predicate.accept(this.items[i])) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean allSatisfy(LongPredicate predicate) {
        for (int i = 0; i < this.size; ++i) {
            if (predicate.accept(this.items[i])) continue;
            return false;
        }
        return true;
    }

    @Override
    public LongArrayList select(LongPredicate predicate) {
        return this.select(predicate, new LongArrayList());
    }

    @Override
    public <R extends MutableLongCollection> R select(LongPredicate predicate, R target) {
        for (int i = 0; i < this.size; ++i) {
            long item = this.items[i];
            if (!predicate.accept(item)) continue;
            target.add(item);
        }
        return target;
    }

    @Override
    public LongArrayList reject(LongPredicate predicate) {
        return this.reject(predicate, new LongArrayList());
    }

    @Override
    public <R extends MutableLongCollection> R reject(LongPredicate predicate, R target) {
        for (int i = 0; i < this.size; ++i) {
            long item = this.items[i];
            if (predicate.accept(item)) continue;
            target.add(item);
        }
        return target;
    }

    @Override
    public long detectIfNone(LongPredicate predicate, long ifNone) {
        for (int i = 0; i < this.size; ++i) {
            long item = this.items[i];
            if (!predicate.accept(item)) continue;
            return item;
        }
        return ifNone;
    }

    @Override
    public <V> MutableList<V> collect(LongToObjectFunction<? extends V> function) {
        return this.collect(function, Lists.mutable.withInitialCapacity(this.size));
    }

    @Override
    public <V, R extends Collection<V>> R collect(LongToObjectFunction<? extends V> function, R target) {
        for (int i = 0; i < this.size; ++i) {
            target.add(function.valueOf(this.items[i]));
        }
        return target;
    }

    @Override
    public long max() {
        if (this.isEmpty()) {
            throw new NoSuchElementException();
        }
        long max2 = this.items[0];
        for (int i = 1; i < this.size; ++i) {
            long value = this.items[i];
            if (max2 >= value) continue;
            max2 = value;
        }
        return max2;
    }

    @Override
    public long min() {
        if (this.isEmpty()) {
            throw new NoSuchElementException();
        }
        long min2 = this.items[0];
        for (int i = 1; i < this.size; ++i) {
            long value = this.items[i];
            if (value >= min2) continue;
            min2 = value;
        }
        return min2;
    }

    @Override
    public long sum() {
        long result = 0L;
        for (int i = 0; i < this.size; ++i) {
            result += this.items[i];
        }
        return result;
    }

    @Override
    public long dotProduct(LongList list) {
        if (this.size != list.size()) {
            throw new IllegalArgumentException("Lists used in dotProduct must be the same size");
        }
        long sum2 = 0L;
        for (int i = 0; i < this.size; ++i) {
            sum2 += this.items[i] * list.get(i);
        }
        return sum2;
    }

    @Override
    public long[] toArray() {
        long[] newItems = new long[this.size];
        System.arraycopy(this.items, 0, newItems, 0, this.size);
        return newItems;
    }

    @Override
    public long[] toArray(long[] target) {
        if (target.length < this.size) {
            target = new long[this.size];
        }
        System.arraycopy(this.items, 0, target, 0, this.size);
        return target;
    }

    @Override
    public boolean equals(Object otherList) {
        if (otherList == this) {
            return true;
        }
        if (!(otherList instanceof LongList)) {
            return false;
        }
        LongList list = (LongList)otherList;
        if (this.size != list.size()) {
            return false;
        }
        for (int i = 0; i < this.size; ++i) {
            if (this.items[i] == list.get(i)) continue;
            return false;
        }
        return true;
    }

    @Override
    public int hashCode() {
        int hashCode2 = 1;
        for (int i = 0; i < this.size; ++i) {
            long item = this.items[i];
            hashCode2 = 31 * hashCode2 + (int)(item ^ item >>> 32);
        }
        return hashCode2;
    }

    @Override
    public void appendString(Appendable appendable, String start, String separator, String end) {
        try {
            appendable.append(start);
            for (int i = 0; i < this.size; ++i) {
                if (i > 0) {
                    appendable.append(separator);
                }
                long value = this.items[i];
                appendable.append(String.valueOf(value));
            }
            appendable.append(end);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public MutableLongList asUnmodifiable() {
        return new UnmodifiableLongList(this);
    }

    @Override
    public MutableLongList asSynchronized() {
        return new SynchronizedLongList(this);
    }

    @Override
    public ImmutableLongList toImmutable() {
        return LongLists.immutable.withAll(this);
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeInt(this.size);
        for (int i = 0; i < this.size; ++i) {
            out.writeLong(this.items[i]);
        }
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException {
        this.size = in.readInt();
        this.items = new long[this.size];
        for (int i = 0; i < this.size; ++i) {
            this.items[i] = in.readLong();
        }
    }

    @Override
    public LazyLongIterable asReversed() {
        return ReverseLongIterable.adapt(this);
    }

    @Override
    public LongArrayList reverseThis() {
        int endIndex = this.size - 1;
        for (int i = 0; i < this.size / 2; ++i) {
            long tempSwapValue = this.items[i];
            this.items[i] = this.items[endIndex - i];
            this.items[endIndex - i] = tempSwapValue;
        }
        return this;
    }

    @Override
    public LongArrayList sortThis() {
        Arrays.sort(this.items, 0, this.size);
        return this;
    }

    @Override
    public LongArrayList sortThis(LongComparator comparator) {
        LongQuickSort.sort(this.items, 0, this.size() - 1, comparator);
        return this;
    }

    @Override
    public LongArrayList toReversed() {
        return LongArrayList.newList(this.asReversed());
    }

    @Override
    public int binarySearch(long value) {
        return Arrays.binarySearch(this.items, 0, this.size, value);
    }

    @Override
    public MutableLongList distinct() {
        LongArrayList target = new LongArrayList();
        LongHashSet seenSoFar = new LongHashSet(this.size());
        for (int i = 0; i < this.size; ++i) {
            long each2 = this.items[i];
            if (!seenSoFar.add(each2)) continue;
            target.add(each2);
        }
        return target;
    }

    @Override
    public MutableLongList subList(int fromIndex, int toIndex) {
        throw new UnsupportedOperationException("subList not yet implemented!");
    }

    @Override
    public MutableList<LongLongPair> zipLong(LongIterable iterable) {
        int size2 = this.size();
        int otherSize = iterable.size();
        MutableList<LongLongPair> target = Lists.mutable.withInitialCapacity(Math.min(size2, otherSize));
        LongIterator iterator2 = iterable.longIterator();
        for (int i = 0; i < size2 && i < otherSize; ++i) {
            target.add(PrimitiveTuples.pair(this.items[i], iterator2.next()));
        }
        return target;
    }

    @Override
    public LongArrayList newEmpty() {
        return new LongArrayList();
    }

    @Override
    public <T> MutableList<LongObjectPair<T>> zip(Iterable<T> iterable) {
        int size2 = this.size();
        int otherSize = Iterate.sizeOf(iterable);
        MutableList<LongObjectPair<T>> target = Lists.mutable.withInitialCapacity(Math.min(size2, otherSize));
        Iterator<T> iterator2 = iterable.iterator();
        for (int i = 0; i < size2 && iterator2.hasNext(); ++i) {
            target.add(PrimitiveTuples.pair(this.items[i], iterator2.next()));
        }
        return target;
    }

    @Override
    public Spliterator.OfLong spliterator() {
        int characteristics = 16;
        return Spliterators.spliterator(this.items, 0, this.size, characteristics);
    }

    private class InternalLongIterator
    implements MutableLongIterator {
        private int currentIndex;
        private int lastIndex = -1;

        private InternalLongIterator() {
        }

        @Override
        public boolean hasNext() {
            return this.currentIndex != LongArrayList.this.size();
        }

        @Override
        public long next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            long next = LongArrayList.this.items[this.currentIndex];
            this.lastIndex = this.currentIndex++;
            return next;
        }

        @Override
        public void remove() {
            if (this.lastIndex == -1) {
                throw new IllegalStateException();
            }
            LongArrayList.this.removeAtIndex(this.lastIndex);
            --this.currentIndex;
            this.lastIndex = -1;
        }
    }
}

