/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.collections.impl.list.mutable;

import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.eclipse.collections.api.block.function.Function0;
import org.eclipse.collections.api.factory.list.MultiReaderListFactory;
import org.eclipse.collections.api.list.MultiReaderList;
import org.eclipse.collections.impl.list.mutable.MultiReaderFastList;

public class MultiReaderMutableListFactory
implements MultiReaderListFactory {
    public static final MultiReaderListFactory INSTANCE = new MultiReaderMutableListFactory();

    @Override
    public <T> MultiReaderList<T> empty() {
        return MultiReaderFastList.newList();
    }

    @Override
    public <T> MultiReaderList<T> with(T ... items) {
        return MultiReaderFastList.newListWith(items);
    }

    @Override
    public <T> MultiReaderList<T> withInitialCapacity(int capacity) {
        if (capacity < 0) {
            throw new IllegalArgumentException("initial capacity cannot be less than 0");
        }
        return MultiReaderFastList.newList(capacity);
    }

    @Override
    public <T> MultiReaderList<T> withAll(Iterable<? extends T> iterable) {
        return MultiReaderFastList.newList(iterable);
    }

    @Override
    public <T> MultiReaderList<T> fromStream(Stream<? extends T> stream) {
        return stream.collect(Collectors.toCollection(MultiReaderFastList::newList));
    }

    @Override
    public <T> MultiReaderList<T> withNValues(int size2, Function0<? extends T> factory) {
        MultiReaderFastList<T> newFastList = MultiReaderFastList.newList(size2);
        for (int i = 0; i < size2; ++i) {
            newFastList.add(factory.value());
        }
        return newFastList;
    }
}

