/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.collections.impl.list.immutable.primitive;

import java.io.IOException;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Spliterator;
import java.util.Spliterators;
import org.eclipse.collections.api.IntIterable;
import org.eclipse.collections.api.LazyIntIterable;
import org.eclipse.collections.api.RichIterable;
import org.eclipse.collections.api.bag.primitive.MutableIntBag;
import org.eclipse.collections.api.block.function.primitive.IntToObjectFunction;
import org.eclipse.collections.api.block.function.primitive.ObjectIntIntToObjectFunction;
import org.eclipse.collections.api.block.function.primitive.ObjectIntToObjectFunction;
import org.eclipse.collections.api.block.predicate.primitive.IntPredicate;
import org.eclipse.collections.api.block.procedure.primitive.IntIntProcedure;
import org.eclipse.collections.api.block.procedure.primitive.IntProcedure;
import org.eclipse.collections.api.collection.primitive.MutableIntCollection;
import org.eclipse.collections.api.factory.Lists;
import org.eclipse.collections.api.iterator.IntIterator;
import org.eclipse.collections.api.list.ImmutableList;
import org.eclipse.collections.api.list.MutableList;
import org.eclipse.collections.api.list.primitive.ImmutableIntList;
import org.eclipse.collections.api.list.primitive.IntList;
import org.eclipse.collections.api.list.primitive.MutableIntList;
import org.eclipse.collections.api.set.primitive.MutableIntSet;
import org.eclipse.collections.api.tuple.primitive.IntIntPair;
import org.eclipse.collections.api.tuple.primitive.IntObjectPair;
import org.eclipse.collections.impl.bag.mutable.primitive.IntHashBag;
import org.eclipse.collections.impl.factory.primitive.IntLists;
import org.eclipse.collections.impl.lazy.primitive.LazyIntIterableAdapter;
import org.eclipse.collections.impl.lazy.primitive.ReverseIntIterable;
import org.eclipse.collections.impl.list.mutable.primitive.IntArrayList;
import org.eclipse.collections.impl.set.mutable.primitive.IntHashSet;
import org.eclipse.collections.impl.tuple.primitive.PrimitiveTuples;
import org.eclipse.collections.impl.utility.Iterate;

final class ImmutableIntArrayList
implements ImmutableIntList,
Serializable {
    private static final long serialVersionUID = 1L;
    private final int[] items;

    private ImmutableIntArrayList(int[] newElements) {
        if (newElements.length <= 1) {
            throw new IllegalArgumentException("Use IntLists.immutable.with() to instantiate an optimized collection");
        }
        this.items = newElements;
    }

    public static ImmutableIntArrayList newList(IntIterable iterable) {
        return new ImmutableIntArrayList(iterable.toArray());
    }

    public static ImmutableIntArrayList newListWith(int ... elements) {
        int[] newArray = new int[elements.length];
        System.arraycopy(elements, 0, newArray, 0, elements.length);
        return new ImmutableIntArrayList(newArray);
    }

    @Override
    public int get(int index) {
        return this.items[index];
    }

    @Override
    public int getFirst() {
        return this.items[0];
    }

    @Override
    public int getLast() {
        return this.items[this.items.length - 1];
    }

    @Override
    public int indexOf(int value) {
        for (int i = 0; i < this.items.length; ++i) {
            if (this.items[i] != value) continue;
            return i;
        }
        return -1;
    }

    @Override
    public int lastIndexOf(int value) {
        for (int i = this.items.length - 1; i >= 0; --i) {
            if (this.items[i] != value) continue;
            return i;
        }
        return -1;
    }

    @Override
    public IntIterator intIterator() {
        return new InternalIntIterator();
    }

    @Override
    public void each(IntProcedure procedure) {
        for (int item : this.items) {
            procedure.value(item);
        }
    }

    @Override
    public void forEachWithIndex(IntIntProcedure procedure) {
        for (int i = 0; i < this.items.length; ++i) {
            procedure.value(this.items[i], i);
        }
    }

    @Override
    public int count(IntPredicate predicate) {
        int count2 = 0;
        for (int item : this.items) {
            if (!predicate.accept(item)) continue;
            ++count2;
        }
        return count2;
    }

    @Override
    public boolean anySatisfy(IntPredicate predicate) {
        for (int item : this.items) {
            if (!predicate.accept(item)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean allSatisfy(IntPredicate predicate) {
        for (int item : this.items) {
            if (predicate.accept(item)) continue;
            return false;
        }
        return true;
    }

    @Override
    public ImmutableIntList select(IntPredicate predicate) {
        return this.select(predicate, new IntArrayList()).toImmutable();
    }

    @Override
    public <R extends MutableIntCollection> R select(IntPredicate predicate, R target) {
        for (int item : this.items) {
            if (!predicate.accept(item)) continue;
            target.add(item);
        }
        return target;
    }

    @Override
    public ImmutableIntList reject(IntPredicate predicate) {
        return this.reject(predicate, new IntArrayList()).toImmutable();
    }

    @Override
    public <R extends MutableIntCollection> R reject(IntPredicate predicate, R target) {
        for (int item : this.items) {
            if (predicate.accept(item)) continue;
            target.add(item);
        }
        return target;
    }

    @Override
    public int detectIfNone(IntPredicate predicate, int ifNone) {
        for (int item : this.items) {
            if (!predicate.accept(item)) continue;
            return item;
        }
        return ifNone;
    }

    @Override
    public <V> ImmutableList<V> collect(IntToObjectFunction<? extends V> function) {
        MutableList list = this.collect(function, Lists.mutable.withInitialCapacity(this.items.length));
        return list.toImmutable();
    }

    @Override
    public <V, R extends Collection<V>> R collect(IntToObjectFunction<? extends V> function, R target) {
        for (int item : this.items) {
            target.add(function.valueOf(item));
        }
        return target;
    }

    @Override
    public long sum() {
        long result = 0L;
        for (int item : this.items) {
            result += (long)item;
        }
        return result;
    }

    @Override
    public int max() {
        int max2 = this.items[0];
        for (int i = 1; i < this.items.length; ++i) {
            int value = this.items[i];
            if (max2 >= value) continue;
            max2 = value;
        }
        return max2;
    }

    @Override
    public int maxIfEmpty(int defaultValue) {
        return this.max();
    }

    @Override
    public int min() {
        int min2 = this.items[0];
        for (int i = 1; i < this.items.length; ++i) {
            int value = this.items[i];
            if (value >= min2) continue;
            min2 = value;
        }
        return min2;
    }

    @Override
    public int minIfEmpty(int defaultValue) {
        return this.min();
    }

    @Override
    public double average() {
        return (double)this.sum() / (double)this.size();
    }

    @Override
    public double median() {
        int[] sortedArray = this.toSortedArray();
        int middleIndex = sortedArray.length >> 1;
        if (sortedArray.length > 1 && (sortedArray.length & 1) == 0) {
            int first = sortedArray[middleIndex];
            int second = sortedArray[middleIndex - 1];
            return ((double)first + (double)second) / 2.0;
        }
        return sortedArray[middleIndex];
    }

    @Override
    public int[] toSortedArray() {
        int[] array = this.toArray();
        Arrays.sort(array);
        return array;
    }

    @Override
    public long dotProduct(IntList list) {
        if (this.size() != list.size()) {
            throw new IllegalArgumentException("Lists used in dotProduct must be the same size");
        }
        long sum2 = 0L;
        for (int i = 0; i < this.size(); ++i) {
            sum2 += (long)this.items[i] * (long)list.get(i);
        }
        return sum2;
    }

    @Override
    public LazyIntIterable asReversed() {
        return ReverseIntIterable.adapt(this);
    }

    @Override
    public MutableIntList toSortedList() {
        return IntArrayList.newList(this).sortThis();
    }

    @Override
    public int binarySearch(int value) {
        return Arrays.binarySearch(this.items, value);
    }

    @Override
    public int[] toArray() {
        int[] newItems = new int[this.items.length];
        System.arraycopy(this.items, 0, newItems, 0, this.items.length);
        return newItems;
    }

    @Override
    public int[] toArray(int[] target) {
        if (target.length < this.items.length) {
            target = new int[this.items.length];
        }
        System.arraycopy(this.items, 0, target, 0, this.items.length);
        return target;
    }

    @Override
    public boolean contains(int value) {
        for (int item : this.items) {
            if (item != value) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean containsAll(int ... source) {
        for (int value : source) {
            if (this.contains(value)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean containsAll(IntIterable source) {
        IntIterator iterator2 = source.intIterator();
        while (iterator2.hasNext()) {
            if (this.contains(iterator2.next())) continue;
            return false;
        }
        return true;
    }

    @Override
    public MutableIntList toList() {
        return IntArrayList.newList(this);
    }

    @Override
    public MutableIntSet toSet() {
        return IntHashSet.newSet(this);
    }

    @Override
    public MutableIntBag toBag() {
        return IntHashBag.newBag(this);
    }

    @Override
    public LazyIntIterable asLazy() {
        return new LazyIntIterableAdapter(this);
    }

    @Override
    public ImmutableIntList toImmutable() {
        return this;
    }

    @Override
    public ImmutableIntArrayList toReversed() {
        return ImmutableIntArrayList.newList(this.asReversed());
    }

    @Override
    public ImmutableIntList newWith(int element) {
        int[] newItems = new int[this.items.length + 1];
        System.arraycopy(this.items, 0, newItems, 0, this.items.length);
        newItems[this.items.length] = element;
        return new ImmutableIntArrayList(newItems);
    }

    @Override
    public ImmutableIntList newWithout(int element) {
        int index = this.indexOf(element);
        if (index != -1) {
            int[] newItems = new int[this.items.length - 1];
            System.arraycopy(this.items, 0, newItems, 0, index);
            System.arraycopy(this.items, index + 1, newItems, index, this.items.length - index - 1);
            return IntLists.immutable.with(newItems);
        }
        return this;
    }

    @Override
    public ImmutableIntList newWithAll(IntIterable elements) {
        int[] newItems = new int[this.items.length + elements.size()];
        System.arraycopy(this.items, 0, newItems, 0, this.items.length);
        int index = 0;
        IntIterator iterator2 = elements.intIterator();
        while (iterator2.hasNext()) {
            newItems[this.items.length + index] = iterator2.next();
            ++index;
        }
        return new ImmutableIntArrayList(newItems);
    }

    @Override
    public ImmutableIntList newWithoutAll(IntIterable elements) {
        MutableIntList mutableIntList = this.toList();
        mutableIntList.removeAll(elements);
        return mutableIntList.toImmutable();
    }

    @Override
    public int size() {
        return this.items.length;
    }

    @Override
    public boolean isEmpty() {
        return false;
    }

    @Override
    public boolean notEmpty() {
        return true;
    }

    @Override
    public <T> T injectInto(T injectedValue, ObjectIntToObjectFunction<? super T, ? extends T> function) {
        T result = injectedValue;
        for (int i = 0; i < this.items.length; ++i) {
            result = function.valueOf(result, this.items[i]);
        }
        return result;
    }

    @Override
    public <T> T injectIntoWithIndex(T injectedValue, ObjectIntIntToObjectFunction<? super T, ? extends T> function) {
        T result = injectedValue;
        for (int i = 0; i < this.items.length; ++i) {
            result = function.valueOf(result, this.items[i], i);
        }
        return result;
    }

    @Override
    public RichIterable<IntIterable> chunk(int size2) {
        if (size2 <= 0) {
            throw new IllegalArgumentException("Size for groups must be positive but was: " + size2);
        }
        MutableList result = Lists.mutable.empty();
        if (this.notEmpty()) {
            if (this.size() <= size2) {
                result.add(this);
            } else {
                IntIterator iterator2 = this.intIterator();
                while (iterator2.hasNext()) {
                    MutableIntList batch = IntLists.mutable.empty();
                    for (int i = 0; i < size2 && iterator2.hasNext(); ++i) {
                        batch.add(iterator2.next());
                    }
                    result.add(batch.toImmutable());
                }
            }
        }
        return result.toImmutable();
    }

    @Override
    public boolean equals(Object otherList) {
        if (otherList == this) {
            return true;
        }
        if (!(otherList instanceof IntList)) {
            return false;
        }
        IntList list = (IntList)otherList;
        if (this.items.length != list.size()) {
            return false;
        }
        for (int i = 0; i < this.items.length; ++i) {
            if (this.items[i] == list.get(i)) continue;
            return false;
        }
        return true;
    }

    @Override
    public int hashCode() {
        int hashCode2 = 1;
        for (int item : this.items) {
            hashCode2 = 31 * hashCode2 + item;
        }
        return hashCode2;
    }

    @Override
    public String toString() {
        return this.makeString("[", ", ", "]");
    }

    @Override
    public String makeString() {
        return this.makeString(", ");
    }

    @Override
    public String makeString(String separator) {
        return this.makeString("", separator, "");
    }

    @Override
    public String makeString(String start, String separator, String end) {
        StringBuilder stringBuilder = new StringBuilder();
        this.appendString(stringBuilder, start, separator, end);
        return ((Object)stringBuilder).toString();
    }

    @Override
    public void appendString(Appendable appendable) {
        this.appendString(appendable, ", ");
    }

    @Override
    public void appendString(Appendable appendable, String separator) {
        this.appendString(appendable, "", separator, "");
    }

    @Override
    public void appendString(Appendable appendable, String start, String separator, String end) {
        try {
            appendable.append(start);
            for (int i = 0; i < this.items.length; ++i) {
                if (i > 0) {
                    appendable.append(separator);
                }
                int value = this.items[i];
                appendable.append(String.valueOf(value));
            }
            appendable.append(end);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public ImmutableIntList distinct() {
        IntArrayList target = new IntArrayList();
        IntHashSet seenSoFar = new IntHashSet(this.size());
        for (int each2 : this.items) {
            if (!seenSoFar.add(each2)) continue;
            target.add(each2);
        }
        return target.toImmutable();
    }

    @Override
    public ImmutableIntList subList(int fromIndex, int toIndex) {
        throw new UnsupportedOperationException("subList not yet implemented!");
    }

    @Override
    public ImmutableList<IntIntPair> zipInt(IntIterable iterable) {
        int size2 = this.size();
        int otherSize = iterable.size();
        MutableList target = Lists.mutable.withInitialCapacity(Math.min(size2, otherSize));
        IntIterator iterator2 = iterable.intIterator();
        for (int i = 0; i < size2 && iterator2.hasNext(); ++i) {
            target.add(PrimitiveTuples.pair(this.items[i], iterator2.next()));
        }
        return target.toImmutable();
    }

    @Override
    public <T> ImmutableList<IntObjectPair<T>> zip(Iterable<T> iterable) {
        int size2 = this.size();
        int otherSize = Iterate.sizeOf(iterable);
        MutableList target = Lists.mutable.withInitialCapacity(Math.min(size2, otherSize));
        Iterator<T> iterator2 = iterable.iterator();
        for (int i = 0; i < size2 && iterator2.hasNext(); ++i) {
            target.add(PrimitiveTuples.pair(this.items[i], iterator2.next()));
        }
        return target.toImmutable();
    }

    @Override
    public Spliterator.OfInt spliterator() {
        int characteristics = 1040;
        return Spliterators.spliterator(this.items, characteristics);
    }

    private class InternalIntIterator
    implements IntIterator {
        private int currentIndex;

        private InternalIntIterator() {
        }

        @Override
        public boolean hasNext() {
            return this.currentIndex != ImmutableIntArrayList.this.items.length;
        }

        @Override
        public int next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            int next = ImmutableIntArrayList.this.items[this.currentIndex];
            ++this.currentIndex;
            return next;
        }
    }
}

