/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.collections.impl.lazy.primitive;

import org.eclipse.collections.api.FloatIterable;
import org.eclipse.collections.api.block.predicate.primitive.FloatPredicate;
import org.eclipse.collections.api.block.procedure.primitive.FloatProcedure;
import org.eclipse.collections.api.iterator.FloatIterator;
import org.eclipse.collections.impl.lazy.primitive.AbstractLazyFloatIterable;

public class TapFloatIterable
extends AbstractLazyFloatIterable {
    private final FloatIterable adapted;
    private final FloatProcedure procedure;

    public TapFloatIterable(FloatIterable delegate, FloatProcedure procedure) {
        this.adapted = delegate;
        this.procedure = procedure;
    }

    @Override
    public void each(FloatProcedure procedure) {
        this.adapted.forEach(each2 -> {
            this.procedure.value(each2);
            procedure.value(each2);
        });
    }

    @Override
    public boolean anySatisfy(FloatPredicate predicate) {
        return this.adapted.anySatisfy(each2 -> {
            this.procedure.value(each2);
            return predicate.accept(each2);
        });
    }

    @Override
    public boolean allSatisfy(FloatPredicate predicate) {
        return this.adapted.allSatisfy(each2 -> {
            this.procedure.value(each2);
            return predicate.accept(each2);
        });
    }

    @Override
    public boolean noneSatisfy(FloatPredicate predicate) {
        return this.adapted.noneSatisfy(each2 -> {
            this.procedure.value(each2);
            return predicate.accept(each2);
        });
    }

    @Override
    public float detectIfNone(FloatPredicate predicate, float ifNone) {
        return this.adapted.detectIfNone(each2 -> {
            this.procedure.value(each2);
            return predicate.accept(each2);
        }, ifNone);
    }

    @Override
    public FloatIterator floatIterator() {
        return new TapFloatIterator(this.adapted, this.procedure);
    }

    public static class TapFloatIterator
    implements FloatIterator {
        private final FloatIterator iterator;
        private final FloatProcedure procedure;

        public TapFloatIterator(FloatIterable iterable, FloatProcedure procedure) {
            this(iterable.floatIterator(), procedure);
        }

        public TapFloatIterator(FloatIterator iterator2, FloatProcedure procedure) {
            this.iterator = iterator2;
            this.procedure = procedure;
        }

        @Override
        public boolean hasNext() {
            return this.iterator.hasNext();
        }

        @Override
        public float next() {
            float next = this.iterator.next();
            this.procedure.value(next);
            return next;
        }
    }
}

