/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.collections.impl.lazy.primitive;

import java.util.NoSuchElementException;
import org.eclipse.collections.api.ShortIterable;
import org.eclipse.collections.api.bag.primitive.MutableShortBag;
import org.eclipse.collections.api.block.predicate.primitive.ShortPredicate;
import org.eclipse.collections.api.block.procedure.primitive.ShortProcedure;
import org.eclipse.collections.api.factory.primitive.ShortBags;
import org.eclipse.collections.api.factory.primitive.ShortLists;
import org.eclipse.collections.api.factory.primitive.ShortSets;
import org.eclipse.collections.api.iterator.ShortIterator;
import org.eclipse.collections.api.list.primitive.MutableShortList;
import org.eclipse.collections.api.set.primitive.MutableShortSet;
import org.eclipse.collections.impl.lazy.primitive.AbstractLazyShortIterable;

public class SelectShortIterable
extends AbstractLazyShortIterable {
    private final ShortIterable delegate;
    private final ShortPredicate predicate;

    public SelectShortIterable(ShortIterable delegate, ShortPredicate predicate) {
        this.delegate = delegate;
        this.predicate = predicate;
    }

    @Override
    public ShortIterator shortIterator() {
        return new SelectShortIterator(this.delegate, this.predicate);
    }

    @Override
    public void each(ShortProcedure procedure) {
        this.delegate.forEach(new IfShortProcedure(procedure));
    }

    @Override
    public int size() {
        return this.delegate.count(this.predicate);
    }

    @Override
    public boolean isEmpty() {
        return !this.shortIterator().hasNext();
    }

    @Override
    public boolean notEmpty() {
        return this.shortIterator().hasNext();
    }

    @Override
    public int count(ShortPredicate predicate) {
        CountShortProcedure countShortProcedure = new CountShortProcedure(predicate);
        this.forEach(countShortProcedure);
        return countShortProcedure.getCount();
    }

    @Override
    public boolean anySatisfy(ShortPredicate predicate) {
        return this.delegate.anySatisfy(each2 -> this.predicate.accept(each2) && predicate.accept(each2));
    }

    @Override
    public boolean allSatisfy(ShortPredicate predicate) {
        return this.noneSatisfy(each2 -> !predicate.accept(each2));
    }

    @Override
    public short[] toArray() {
        final short[] array = new short[this.size()];
        this.forEach(new ShortProcedure(){
            private int index = 0;

            @Override
            public void value(short each2) {
                array[this.index++] = each2;
            }
        });
        return array;
    }

    @Override
    public boolean containsAll(short ... source) {
        for (short value : source) {
            if (this.contains(value)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean containsAll(ShortIterable source) {
        ShortIterator iterator2 = source.shortIterator();
        while (iterator2.hasNext()) {
            if (this.contains(iterator2.next())) continue;
            return false;
        }
        return true;
    }

    @Override
    public MutableShortList toList() {
        return ShortLists.mutable.withAll(this);
    }

    @Override
    public MutableShortSet toSet() {
        return ShortSets.mutable.withAll(this);
    }

    @Override
    public MutableShortBag toBag() {
        return ShortBags.mutable.withAll(this);
    }

    private static final class SelectShortIterator
    implements ShortIterator {
        private final ShortIterator iterator;
        private final ShortPredicate predicate;
        private short next;
        private boolean verifiedHasNext = false;

        private SelectShortIterator(ShortIterable iterable, ShortPredicate predicate) {
            this(iterable.shortIterator(), predicate);
        }

        private SelectShortIterator(ShortIterator iterator2, ShortPredicate predicate) {
            this.iterator = iterator2;
            this.predicate = predicate;
        }

        @Override
        public boolean hasNext() {
            if (this.verifiedHasNext) {
                return true;
            }
            while (this.iterator.hasNext()) {
                short temp = this.iterator.next();
                if (!this.predicate.accept(temp)) continue;
                this.next = temp;
                this.verifiedHasNext = true;
                return true;
            }
            return false;
        }

        @Override
        public short next() {
            if (this.verifiedHasNext || this.hasNext()) {
                this.verifiedHasNext = false;
                return this.next;
            }
            throw new NoSuchElementException();
        }
    }

    private final class IfShortProcedure
    implements ShortProcedure {
        private static final long serialVersionUID = 1L;
        private final ShortProcedure procedure;

        private IfShortProcedure(ShortProcedure procedure) {
            this.procedure = procedure;
        }

        @Override
        public void value(short each2) {
            if (SelectShortIterable.this.predicate.accept(each2)) {
                this.procedure.value(each2);
            }
        }
    }

    private static final class CountShortProcedure
    implements ShortProcedure {
        private static final long serialVersionUID = 1L;
        private final ShortPredicate predicate;
        private int counter = 0;

        private CountShortProcedure(ShortPredicate predicate) {
            this.predicate = predicate;
        }

        @Override
        public void value(short each2) {
            if (this.predicate.accept(each2)) {
                ++this.counter;
            }
        }

        public int getCount() {
            return this.counter;
        }
    }
}

