/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.collections.impl.lazy.primitive;

import java.util.NoSuchElementException;
import org.eclipse.collections.api.ByteIterable;
import org.eclipse.collections.api.bag.primitive.MutableByteBag;
import org.eclipse.collections.api.block.predicate.primitive.BytePredicate;
import org.eclipse.collections.api.block.procedure.primitive.ByteProcedure;
import org.eclipse.collections.api.factory.primitive.ByteBags;
import org.eclipse.collections.api.factory.primitive.ByteLists;
import org.eclipse.collections.api.factory.primitive.ByteSets;
import org.eclipse.collections.api.iterator.ByteIterator;
import org.eclipse.collections.api.list.primitive.MutableByteList;
import org.eclipse.collections.api.set.primitive.MutableByteSet;
import org.eclipse.collections.impl.lazy.primitive.AbstractLazyByteIterable;

public class SelectByteIterable
extends AbstractLazyByteIterable {
    private final ByteIterable delegate;
    private final BytePredicate predicate;

    public SelectByteIterable(ByteIterable delegate, BytePredicate predicate) {
        this.delegate = delegate;
        this.predicate = predicate;
    }

    @Override
    public ByteIterator byteIterator() {
        return new SelectByteIterator(this.delegate, this.predicate);
    }

    @Override
    public void each(ByteProcedure procedure) {
        this.delegate.forEach(new IfByteProcedure(procedure));
    }

    @Override
    public int size() {
        return this.delegate.count(this.predicate);
    }

    @Override
    public boolean isEmpty() {
        return !this.byteIterator().hasNext();
    }

    @Override
    public boolean notEmpty() {
        return this.byteIterator().hasNext();
    }

    @Override
    public int count(BytePredicate predicate) {
        CountByteProcedure countByteProcedure = new CountByteProcedure(predicate);
        this.forEach(countByteProcedure);
        return countByteProcedure.getCount();
    }

    @Override
    public boolean anySatisfy(BytePredicate predicate) {
        return this.delegate.anySatisfy(each2 -> this.predicate.accept(each2) && predicate.accept(each2));
    }

    @Override
    public boolean allSatisfy(BytePredicate predicate) {
        return this.noneSatisfy(each2 -> !predicate.accept(each2));
    }

    @Override
    public byte[] toArray() {
        final byte[] array = new byte[this.size()];
        this.forEach(new ByteProcedure(){
            private int index = 0;

            @Override
            public void value(byte each2) {
                array[this.index++] = each2;
            }
        });
        return array;
    }

    @Override
    public boolean containsAll(byte ... source) {
        for (byte value : source) {
            if (this.contains(value)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean containsAll(ByteIterable source) {
        ByteIterator iterator2 = source.byteIterator();
        while (iterator2.hasNext()) {
            if (this.contains(iterator2.next())) continue;
            return false;
        }
        return true;
    }

    @Override
    public MutableByteList toList() {
        return ByteLists.mutable.withAll(this);
    }

    @Override
    public MutableByteSet toSet() {
        return ByteSets.mutable.withAll(this);
    }

    @Override
    public MutableByteBag toBag() {
        return ByteBags.mutable.withAll(this);
    }

    private static final class SelectByteIterator
    implements ByteIterator {
        private final ByteIterator iterator;
        private final BytePredicate predicate;
        private byte next;
        private boolean verifiedHasNext = false;

        private SelectByteIterator(ByteIterable iterable, BytePredicate predicate) {
            this(iterable.byteIterator(), predicate);
        }

        private SelectByteIterator(ByteIterator iterator2, BytePredicate predicate) {
            this.iterator = iterator2;
            this.predicate = predicate;
        }

        @Override
        public boolean hasNext() {
            if (this.verifiedHasNext) {
                return true;
            }
            while (this.iterator.hasNext()) {
                byte temp = this.iterator.next();
                if (!this.predicate.accept(temp)) continue;
                this.next = temp;
                this.verifiedHasNext = true;
                return true;
            }
            return false;
        }

        @Override
        public byte next() {
            if (this.verifiedHasNext || this.hasNext()) {
                this.verifiedHasNext = false;
                return this.next;
            }
            throw new NoSuchElementException();
        }
    }

    private final class IfByteProcedure
    implements ByteProcedure {
        private static final long serialVersionUID = 1L;
        private final ByteProcedure procedure;

        private IfByteProcedure(ByteProcedure procedure) {
            this.procedure = procedure;
        }

        @Override
        public void value(byte each2) {
            if (SelectByteIterable.this.predicate.accept(each2)) {
                this.procedure.value(each2);
            }
        }
    }

    private static final class CountByteProcedure
    implements ByteProcedure {
        private static final long serialVersionUID = 1L;
        private final BytePredicate predicate;
        private int counter = 0;

        private CountByteProcedure(BytePredicate predicate) {
            this.predicate = predicate;
        }

        @Override
        public void value(byte each2) {
            if (this.predicate.accept(each2)) {
                ++this.counter;
            }
        }

        public int getCount() {
            return this.counter;
        }
    }
}

