/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.collections.impl.lazy.primitive;

import java.util.Arrays;
import java.util.Iterator;
import org.eclipse.collections.api.LazyIterable;
import org.eclipse.collections.api.ShortIterable;
import org.eclipse.collections.api.bag.primitive.MutableShortBag;
import org.eclipse.collections.api.block.function.primitive.ShortFunction;
import org.eclipse.collections.api.block.predicate.primitive.ShortPredicate;
import org.eclipse.collections.api.block.procedure.Procedure2;
import org.eclipse.collections.api.block.procedure.primitive.ShortProcedure;
import org.eclipse.collections.api.factory.primitive.ShortBags;
import org.eclipse.collections.api.factory.primitive.ShortLists;
import org.eclipse.collections.api.factory.primitive.ShortSets;
import org.eclipse.collections.api.iterator.ShortIterator;
import org.eclipse.collections.api.list.primitive.MutableShortList;
import org.eclipse.collections.api.set.primitive.MutableShortSet;
import org.eclipse.collections.impl.lazy.primitive.AbstractLazyShortIterable;

public class CollectShortIterable<T>
extends AbstractLazyShortIterable {
    private final LazyIterable<T> iterable;
    private final ShortFunction<? super T> function;
    private final ShortFunctionToProcedure<T> shortFunctionToProcedure;

    public CollectShortIterable(LazyIterable<T> adapted, ShortFunction<? super T> function) {
        this.iterable = adapted;
        this.function = function;
        this.shortFunctionToProcedure = new ShortFunctionToProcedure(function);
    }

    @Override
    public ShortIterator shortIterator() {
        return new ShortIterator(){
            private final Iterator<T> iterator;
            {
                this.iterator = CollectShortIterable.this.iterable.iterator();
            }

            @Override
            public short next() {
                return CollectShortIterable.this.function.shortValueOf(this.iterator.next());
            }

            @Override
            public boolean hasNext() {
                return this.iterator.hasNext();
            }
        };
    }

    @Override
    public void each(ShortProcedure procedure) {
        this.iterable.forEachWith(this.shortFunctionToProcedure, procedure);
    }

    @Override
    public int size() {
        return this.iterable.size();
    }

    @Override
    public boolean isEmpty() {
        return this.iterable.isEmpty();
    }

    @Override
    public boolean notEmpty() {
        return this.iterable.notEmpty();
    }

    @Override
    public int count(ShortPredicate predicate) {
        return this.iterable.count((? super T each2) -> predicate.accept(this.function.shortValueOf(each2)));
    }

    @Override
    public boolean anySatisfy(ShortPredicate predicate) {
        return this.iterable.anySatisfy((? super T each2) -> predicate.accept(this.function.shortValueOf(each2)));
    }

    @Override
    public boolean allSatisfy(ShortPredicate predicate) {
        return this.iterable.allSatisfy((? super T each2) -> predicate.accept(this.function.shortValueOf(each2)));
    }

    @Override
    public short[] toArray() {
        short[] array = new short[this.size()];
        this.iterable.forEachWithIndex((each2, index) -> {
            array[index] = this.function.shortValueOf(each2);
        });
        return array;
    }

    @Override
    public short[] toSortedArray() {
        short[] array = this.toArray();
        Arrays.sort(array);
        return array;
    }

    @Override
    public MutableShortList toList() {
        return ShortLists.mutable.withAll(this);
    }

    @Override
    public MutableShortSet toSet() {
        return ShortSets.mutable.withAll(this);
    }

    @Override
    public MutableShortBag toBag() {
        return ShortBags.mutable.withAll(this);
    }

    @Override
    public boolean containsAll(short ... source) {
        for (short value : source) {
            if (this.contains(value)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean containsAll(ShortIterable source) {
        ShortIterator iterator2 = source.shortIterator();
        while (iterator2.hasNext()) {
            if (this.contains(iterator2.next())) continue;
            return false;
        }
        return true;
    }

    private static final class ShortFunctionToProcedure<T>
    implements Procedure2<T, ShortProcedure> {
        private static final long serialVersionUID = 1L;
        private final ShortFunction<? super T> function;

        private ShortFunctionToProcedure(ShortFunction<? super T> function) {
            this.function = function;
        }

        @Override
        public void value(T each2, ShortProcedure procedure) {
            procedure.value(this.function.shortValueOf(each2));
        }
    }
}

