/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.collections.impl.lazy.primitive;

import java.util.Arrays;
import java.util.Iterator;
import org.eclipse.collections.api.IntIterable;
import org.eclipse.collections.api.LazyIterable;
import org.eclipse.collections.api.bag.primitive.MutableIntBag;
import org.eclipse.collections.api.block.function.primitive.IntFunction;
import org.eclipse.collections.api.block.predicate.primitive.IntPredicate;
import org.eclipse.collections.api.block.procedure.Procedure2;
import org.eclipse.collections.api.block.procedure.primitive.IntProcedure;
import org.eclipse.collections.api.factory.primitive.IntBags;
import org.eclipse.collections.api.factory.primitive.IntLists;
import org.eclipse.collections.api.factory.primitive.IntSets;
import org.eclipse.collections.api.iterator.IntIterator;
import org.eclipse.collections.api.list.primitive.MutableIntList;
import org.eclipse.collections.api.set.primitive.MutableIntSet;
import org.eclipse.collections.impl.lazy.primitive.AbstractLazyIntIterable;

public class CollectIntIterable<T>
extends AbstractLazyIntIterable {
    private final LazyIterable<T> iterable;
    private final IntFunction<? super T> function;
    private final IntFunctionToProcedure<T> intFunctionToProcedure;

    public CollectIntIterable(LazyIterable<T> adapted, IntFunction<? super T> function) {
        this.iterable = adapted;
        this.function = function;
        this.intFunctionToProcedure = new IntFunctionToProcedure(function);
    }

    @Override
    public IntIterator intIterator() {
        return new IntIterator(){
            private final Iterator<T> iterator;
            {
                this.iterator = CollectIntIterable.this.iterable.iterator();
            }

            @Override
            public int next() {
                return CollectIntIterable.this.function.intValueOf(this.iterator.next());
            }

            @Override
            public boolean hasNext() {
                return this.iterator.hasNext();
            }
        };
    }

    @Override
    public void each(IntProcedure procedure) {
        this.iterable.forEachWith(this.intFunctionToProcedure, procedure);
    }

    @Override
    public int size() {
        return this.iterable.size();
    }

    @Override
    public boolean isEmpty() {
        return this.iterable.isEmpty();
    }

    @Override
    public boolean notEmpty() {
        return this.iterable.notEmpty();
    }

    @Override
    public int count(IntPredicate predicate) {
        return this.iterable.count((? super T each2) -> predicate.accept(this.function.intValueOf(each2)));
    }

    @Override
    public boolean anySatisfy(IntPredicate predicate) {
        return this.iterable.anySatisfy((? super T each2) -> predicate.accept(this.function.intValueOf(each2)));
    }

    @Override
    public boolean allSatisfy(IntPredicate predicate) {
        return this.iterable.allSatisfy((? super T each2) -> predicate.accept(this.function.intValueOf(each2)));
    }

    @Override
    public int[] toArray() {
        int[] array = new int[this.size()];
        this.iterable.forEachWithIndex((each2, index) -> {
            array[index] = this.function.intValueOf(each2);
        });
        return array;
    }

    @Override
    public int[] toSortedArray() {
        int[] array = this.toArray();
        Arrays.sort(array);
        return array;
    }

    @Override
    public MutableIntList toList() {
        return IntLists.mutable.withAll(this);
    }

    @Override
    public MutableIntSet toSet() {
        return IntSets.mutable.withAll(this);
    }

    @Override
    public MutableIntBag toBag() {
        return IntBags.mutable.withAll(this);
    }

    @Override
    public boolean containsAll(int ... source) {
        for (int value : source) {
            if (this.contains(value)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean containsAll(IntIterable source) {
        IntIterator iterator2 = source.intIterator();
        while (iterator2.hasNext()) {
            if (this.contains(iterator2.next())) continue;
            return false;
        }
        return true;
    }

    private static final class IntFunctionToProcedure<T>
    implements Procedure2<T, IntProcedure> {
        private static final long serialVersionUID = 1L;
        private final IntFunction<? super T> function;

        private IntFunctionToProcedure(IntFunction<? super T> function) {
            this.function = function;
        }

        @Override
        public void value(T each2, IntProcedure procedure) {
            procedure.value(this.function.intValueOf(each2));
        }
    }
}

