/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.collections.impl.lazy.primitive;

import java.util.Iterator;
import java.util.NoSuchElementException;
import org.eclipse.collections.api.ShortIterable;
import org.eclipse.collections.api.block.function.Function0;
import org.eclipse.collections.api.block.procedure.Procedure;
import org.eclipse.collections.api.collection.primitive.MutableShortCollection;
import org.eclipse.collections.api.factory.primitive.ShortLists;
import org.eclipse.collections.api.iterator.ShortIterator;
import org.eclipse.collections.impl.lazy.AbstractLazyIterable;
import org.eclipse.collections.impl.utility.internal.IterableIterate;

public class ChunkShortIterable
extends AbstractLazyIterable<ShortIterable> {
    private final ShortIterable adapted;
    private final int size;

    public ChunkShortIterable(ShortIterable delegate, int size2) {
        if (size2 <= 0) {
            throw new IllegalArgumentException("Size for groups must be positive but was: " + size2);
        }
        this.adapted = delegate;
        this.size = size2;
    }

    @Override
    public Iterator<ShortIterable> iterator() {
        return new ChunkShortIterator(this.adapted, this.size);
    }

    @Override
    public void each(Procedure<? super ShortIterable> procedure) {
        IterableIterate.forEach(this, procedure);
    }

    public static class ChunkShortIterator
    implements Iterator<ShortIterable> {
        private final ShortIterator iterator;
        private final int size;
        private final Function0<MutableShortCollection> speciesNewStrategy;

        public ChunkShortIterator(ShortIterable iterable, int size2) {
            if (size2 <= 0) {
                throw new IllegalArgumentException("Size for groups must be positive but was: " + size2);
            }
            this.size = size2;
            this.iterator = iterable.shortIterator();
            this.speciesNewStrategy = iterable instanceof MutableShortCollection ? ((MutableShortCollection)iterable)::newEmpty : ShortLists.mutable::empty;
        }

        @Override
        public boolean hasNext() {
            return this.iterator.hasNext();
        }

        @Override
        public ShortIterable next() {
            if (!this.iterator.hasNext()) {
                throw new NoSuchElementException();
            }
            MutableShortCollection result = this.speciesNewStrategy.value();
            for (int i = this.size; i > 0 && this.iterator.hasNext(); --i) {
                result.add(this.iterator.next());
            }
            return result;
        }
    }
}

