/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.collections.impl.lazy;

import java.util.Iterator;
import java.util.Optional;
import org.eclipse.collections.api.LazyIterable;
import org.eclipse.collections.api.block.predicate.Predicate;
import org.eclipse.collections.api.block.procedure.Procedure;
import org.eclipse.collections.api.block.procedure.primitive.ObjectIntProcedure;
import org.eclipse.collections.api.factory.Sets;
import org.eclipse.collections.api.set.MutableSet;
import org.eclipse.collections.impl.block.procedure.AdaptObjectIntProcedureToProcedure;
import org.eclipse.collections.impl.lazy.AbstractLazyIterable;
import org.eclipse.collections.impl.lazy.iterator.DistinctIterator;
import org.eclipse.collections.impl.utility.Iterate;

public class DistinctIterable<T>
extends AbstractLazyIterable<T> {
    private final Iterable<T> adapted;

    public DistinctIterable(Iterable<T> newAdapted) {
        this.adapted = newAdapted;
    }

    @Override
    public LazyIterable<T> distinct() {
        return this;
    }

    @Override
    public void each(Procedure<? super T> procedure) {
        MutableSet seenSoFar = Sets.mutable.empty();
        Iterate.forEach(this.adapted, each2 -> {
            if (seenSoFar.add(each2)) {
                procedure.value(each2);
            }
        });
    }

    @Override
    public void forEachWithIndex(ObjectIntProcedure<? super T> objectIntProcedure) {
        this.each(new AdaptObjectIntProcedureToProcedure<T>(objectIntProcedure));
    }

    @Override
    public boolean anySatisfy(Predicate<? super T> predicate) {
        MutableSet seenSoFar = Sets.mutable.empty();
        return Iterate.anySatisfy(this.adapted, each2 -> seenSoFar.add(each2) && predicate.accept(each2));
    }

    @Override
    public boolean allSatisfy(Predicate<? super T> predicate) {
        MutableSet seenSoFar = Sets.mutable.empty();
        return Iterate.allSatisfy(this.adapted, each2 -> !seenSoFar.add(each2) || predicate.accept(each2));
    }

    @Override
    public boolean noneSatisfy(Predicate<? super T> predicate) {
        MutableSet seenSoFar = Sets.mutable.empty();
        return Iterate.allSatisfy(this.adapted, each2 -> !seenSoFar.add(each2) || !predicate.accept(each2));
    }

    @Override
    public T detect(Predicate<? super T> predicate) {
        MutableSet seenSoFar = Sets.mutable.empty();
        return (T)Iterate.detect(this.adapted, each2 -> seenSoFar.add(each2) && predicate.accept(each2));
    }

    @Override
    public Optional<T> detectOptional(Predicate<? super T> predicate) {
        MutableSet seenSoFar = Sets.mutable.empty();
        return Iterate.detectOptional(this.adapted, each2 -> seenSoFar.add(each2) && predicate.accept(each2));
    }

    @Override
    public Iterator<T> iterator() {
        return new DistinctIterator<T>(this.adapted);
    }
}

