/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.collections.impl.block.procedure;

import org.eclipse.collections.api.block.function.primitive.FloatFunction;
import org.eclipse.collections.api.block.procedure.Procedure;
import org.eclipse.collections.impl.block.procedure.DoubleSumResultHolder;

public class SumOfFloatProcedure<T>
implements Procedure<T>,
DoubleSumResultHolder {
    private static final long serialVersionUID = 2L;
    private final FloatFunction<? super T> function;
    private double result;
    private double compensation;

    public SumOfFloatProcedure(FloatFunction<? super T> function) {
        this.function = function;
    }

    @Override
    public double getResult() {
        return this.result;
    }

    @Override
    public double getCompensation() {
        return this.compensation;
    }

    @Override
    public void value(T each2) {
        double adjustedValue = (double)this.function.floatValueOf(each2) - this.compensation;
        double nextSum = this.result + adjustedValue;
        this.compensation = nextSum - this.result - adjustedValue;
        this.result = nextSum;
    }
}

