/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.collections.impl.bag.mutable;

import java.io.Serializable;
import java.util.Collection;
import org.eclipse.collections.api.RichIterable;
import org.eclipse.collections.api.bag.ImmutableBag;
import org.eclipse.collections.api.bag.MutableBag;
import org.eclipse.collections.api.bag.primitive.MutableBooleanBag;
import org.eclipse.collections.api.bag.primitive.MutableByteBag;
import org.eclipse.collections.api.bag.primitive.MutableCharBag;
import org.eclipse.collections.api.bag.primitive.MutableDoubleBag;
import org.eclipse.collections.api.bag.primitive.MutableFloatBag;
import org.eclipse.collections.api.bag.primitive.MutableIntBag;
import org.eclipse.collections.api.bag.primitive.MutableLongBag;
import org.eclipse.collections.api.bag.primitive.MutableShortBag;
import org.eclipse.collections.api.block.function.Function;
import org.eclipse.collections.api.block.function.Function2;
import org.eclipse.collections.api.block.function.primitive.BooleanFunction;
import org.eclipse.collections.api.block.function.primitive.ByteFunction;
import org.eclipse.collections.api.block.function.primitive.CharFunction;
import org.eclipse.collections.api.block.function.primitive.DoubleFunction;
import org.eclipse.collections.api.block.function.primitive.FloatFunction;
import org.eclipse.collections.api.block.function.primitive.IntFunction;
import org.eclipse.collections.api.block.function.primitive.LongFunction;
import org.eclipse.collections.api.block.function.primitive.ObjectIntToObjectFunction;
import org.eclipse.collections.api.block.function.primitive.ShortFunction;
import org.eclipse.collections.api.block.predicate.Predicate;
import org.eclipse.collections.api.block.predicate.Predicate2;
import org.eclipse.collections.api.block.predicate.primitive.IntPredicate;
import org.eclipse.collections.api.block.predicate.primitive.ObjectIntPredicate;
import org.eclipse.collections.api.block.procedure.Procedure;
import org.eclipse.collections.api.block.procedure.primitive.ObjectIntProcedure;
import org.eclipse.collections.api.factory.Bags;
import org.eclipse.collections.api.list.MutableList;
import org.eclipse.collections.api.map.MutableMap;
import org.eclipse.collections.api.multimap.bag.MutableBagMultimap;
import org.eclipse.collections.api.partition.bag.PartitionMutableBag;
import org.eclipse.collections.api.set.MutableSet;
import org.eclipse.collections.api.tuple.Pair;
import org.eclipse.collections.api.tuple.primitive.ObjectIntPair;
import org.eclipse.collections.impl.SynchronizedRichIterable;
import org.eclipse.collections.impl.bag.mutable.UnmodifiableBag;
import org.eclipse.collections.impl.collection.mutable.AbstractSynchronizedMutableCollection;
import org.eclipse.collections.impl.collection.mutable.SynchronizedCollectionSerializationProxy;

public class SynchronizedBag<T>
extends AbstractSynchronizedMutableCollection<T>
implements MutableBag<T>,
Serializable {
    private static final long serialVersionUID = 2L;

    SynchronizedBag(MutableBag<T> bag) {
        super(bag);
    }

    public SynchronizedBag(MutableBag<T> bag, Object newLock) {
        super(bag, newLock);
    }

    public static <E, B extends MutableBag<E>> SynchronizedBag<E> of(B bag) {
        return new SynchronizedBag(bag);
    }

    public static <E, B extends MutableBag<E>> SynchronizedBag<E> of(B bag, Object lock) {
        return new SynchronizedBag(bag, lock);
    }

    @Override
    protected MutableBag<T> getDelegate() {
        return (MutableBag)super.getDelegate();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public MutableBag<T> newEmpty() {
        Object object = this.getLock();
        synchronized (object) {
            return this.getDelegate().newEmpty().asSynchronized();
        }
    }

    protected Object writeReplace() {
        return new SynchronizedCollectionSerializationProxy(this.getDelegate());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int addOccurrences(T item, int occurrences) {
        Object object = this.getLock();
        synchronized (object) {
            return this.getDelegate().addOccurrences(item, occurrences);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean removeOccurrences(Object item, int occurrences) {
        Object object = this.getLock();
        synchronized (object) {
            return this.getDelegate().removeOccurrences(item, occurrences);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean setOccurrences(T item, int occurrences) {
        Object object = this.getLock();
        synchronized (object) {
            return this.getDelegate().setOccurrences(item, occurrences);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public MutableMap<T, Integer> toMapOfItemToCount() {
        Object object = this.getLock();
        synchronized (object) {
            return this.getDelegate().toMapOfItemToCount();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public MutableBag<T> selectByOccurrences(IntPredicate predicate) {
        Object object = this.getLock();
        synchronized (object) {
            return this.getDelegate().selectByOccurrences(predicate);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public MutableList<ObjectIntPair<T>> topOccurrences(int count2) {
        Object object = this.getLock();
        synchronized (object) {
            return this.getDelegate().topOccurrences(count2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public MutableList<ObjectIntPair<T>> bottomOccurrences(int count2) {
        Object object = this.getLock();
        synchronized (object) {
            return this.getDelegate().bottomOccurrences(count2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean anySatisfyWithOccurrences(ObjectIntPredicate<? super T> predicate) {
        Object object = this.getLock();
        synchronized (object) {
            return this.getDelegate().anySatisfyWithOccurrences(predicate);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean allSatisfyWithOccurrences(ObjectIntPredicate<? super T> predicate) {
        Object object = this.getLock();
        synchronized (object) {
            return this.getDelegate().allSatisfyWithOccurrences(predicate);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean noneSatisfyWithOccurrences(ObjectIntPredicate<? super T> predicate) {
        Object object = this.getLock();
        synchronized (object) {
            return this.getDelegate().noneSatisfyWithOccurrences(predicate);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public T detectWithOccurrences(ObjectIntPredicate<? super T> predicate) {
        Object object = this.getLock();
        synchronized (object) {
            return this.getDelegate().detectWithOccurrences(predicate);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void forEachWithOccurrences(ObjectIntProcedure<? super T> objectIntProcedure) {
        Object object = this.getLock();
        synchronized (object) {
            this.getDelegate().forEachWithOccurrences(objectIntProcedure);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <V> MutableBag<V> collectWithOccurrences(ObjectIntToObjectFunction<? super T, ? extends V> function) {
        Object object = this.getLock();
        synchronized (object) {
            return this.getDelegate().collectWithOccurrences(function);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <V, R extends Collection<V>> R collectWithOccurrences(ObjectIntToObjectFunction<? super T, ? extends V> function, R target) {
        Object object = this.getLock();
        synchronized (object) {
            return this.getDelegate().collectWithOccurrences(function, target);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int occurrencesOf(Object item) {
        Object object = this.getLock();
        synchronized (object) {
            return this.getDelegate().occurrencesOf(item);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int sizeDistinct() {
        Object object = this.getLock();
        synchronized (object) {
            return this.getDelegate().sizeDistinct();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String toStringOfItemToCount() {
        Object object = this.getLock();
        synchronized (object) {
            return this.getDelegate().toStringOfItemToCount();
        }
    }

    @Override
    public MutableBag<T> tap(Procedure<? super T> procedure) {
        return (MutableBag)super.tap((Procedure)procedure);
    }

    @Override
    public MutableBag<T> select(Predicate<? super T> predicate) {
        return (MutableBag)super.select((Predicate)predicate);
    }

    @Override
    public <P> MutableBag<T> selectWith(Predicate2<? super T, ? super P> predicate, P parameter) {
        return (MutableBag)super.selectWith((Predicate2)predicate, (Object)parameter);
    }

    @Override
    public MutableBag<T> reject(Predicate<? super T> predicate) {
        return (MutableBag)super.reject((Predicate)predicate);
    }

    @Override
    public <P> MutableBag<T> rejectWith(Predicate2<? super T, ? super P> predicate, P parameter) {
        return (MutableBag)super.rejectWith((Predicate2)predicate, (Object)parameter);
    }

    @Override
    public PartitionMutableBag<T> partition(Predicate<? super T> predicate) {
        return (PartitionMutableBag)super.partition((Predicate)predicate);
    }

    @Override
    public <P> PartitionMutableBag<T> partitionWith(Predicate2<? super T, ? super P> predicate, P parameter) {
        return (PartitionMutableBag)super.partitionWith((Predicate2)predicate, (Object)parameter);
    }

    @Override
    public MutableBooleanBag collectBoolean(BooleanFunction<? super T> booleanFunction) {
        return (MutableBooleanBag)super.collectBoolean((BooleanFunction)booleanFunction);
    }

    @Override
    public MutableByteBag collectByte(ByteFunction<? super T> byteFunction) {
        return (MutableByteBag)super.collectByte((ByteFunction)byteFunction);
    }

    @Override
    public MutableCharBag collectChar(CharFunction<? super T> charFunction) {
        return (MutableCharBag)super.collectChar((CharFunction)charFunction);
    }

    @Override
    public MutableDoubleBag collectDouble(DoubleFunction<? super T> doubleFunction) {
        return (MutableDoubleBag)super.collectDouble((DoubleFunction)doubleFunction);
    }

    @Override
    public MutableFloatBag collectFloat(FloatFunction<? super T> floatFunction) {
        return (MutableFloatBag)super.collectFloat((FloatFunction)floatFunction);
    }

    @Override
    public MutableIntBag collectInt(IntFunction<? super T> intFunction) {
        return (MutableIntBag)super.collectInt((IntFunction)intFunction);
    }

    @Override
    public MutableLongBag collectLong(LongFunction<? super T> longFunction) {
        return (MutableLongBag)super.collectLong((LongFunction)longFunction);
    }

    @Override
    public MutableShortBag collectShort(ShortFunction<? super T> shortFunction) {
        return (MutableShortBag)super.collectShort((ShortFunction)shortFunction);
    }

    @Override
    public <S> MutableBag<S> selectInstancesOf(Class<S> clazz) {
        return (MutableBag)super.selectInstancesOf((Class)clazz);
    }

    @Override
    public <V> MutableBag<V> collect(Function<? super T, ? extends V> function) {
        return (MutableBag)super.collect((Function)function);
    }

    @Override
    @Deprecated
    public MutableSet<Pair<T, Integer>> zipWithIndex() {
        return (MutableSet)super.zipWithIndex();
    }

    @Override
    public <P, V> MutableBag<V> collectWith(Function2<? super T, ? super P, ? extends V> function, P parameter) {
        return (MutableBag)super.collectWith((Function2)function, (Object)parameter);
    }

    @Override
    public <V> MutableBag<V> collectIf(Predicate<? super T> predicate, Function<? super T, ? extends V> function) {
        return (MutableBag)super.collectIf((Predicate)predicate, (Function)function);
    }

    @Override
    public <V> MutableBag<V> flatCollect(Function<? super T, ? extends Iterable<V>> function) {
        return (MutableBag)super.flatCollect((Function)function);
    }

    @Override
    public <V> MutableBagMultimap<V, T> groupBy(Function<? super T, ? extends V> function) {
        return (MutableBagMultimap)super.groupBy((Function)function);
    }

    @Override
    public <V> MutableBagMultimap<V, T> groupByEach(Function<? super T, ? extends Iterable<V>> function) {
        return (MutableBagMultimap)super.groupByEach((Function)function);
    }

    @Override
    @Deprecated
    public <S> MutableBag<Pair<T, S>> zip(Iterable<S> that) {
        return (MutableBag)super.zip((Iterable)that);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public MutableBag<T> asUnmodifiable() {
        Object object = this.getLock();
        synchronized (object) {
            return UnmodifiableBag.of(this);
        }
    }

    @Override
    public MutableBag<T> asSynchronized() {
        return this;
    }

    @Override
    public ImmutableBag<T> toImmutable() {
        return Bags.immutable.withAll(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public MutableSet<T> selectUnique() {
        Object object = this.getLock();
        synchronized (object) {
            return this.getDelegate().selectUnique();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public RichIterable<T> distinctView() {
        Object object = this.getLock();
        synchronized (object) {
            return SynchronizedRichIterable.of(this.getDelegate().distinctView(), this.lock);
        }
    }
}

